/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.stdout;

import com.codahale.metrics.Timer;
import io.nosqlbench.activitytype.stdout.StdoutActivity;
import io.nosqlbench.engine.api.activityapi.core.SyncAction;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.virtdata.api.templates.StringBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdoutAction
implements SyncAction {
    private static final Logger logger = LoggerFactory.getLogger(StdoutAction.class);
    private int slot;
    private StdoutActivity activity;
    private int maxTries = 10;
    private boolean showstmts;
    private OpSequence<StringBindings> sequencer;

    public StdoutAction(int slot, StdoutActivity activity) {
        this.slot = slot;
        this.activity = activity;
    }

    public void init() {
        this.sequencer = this.activity.getOpSequence();
    }

    public int runCycle(long cycleValue) {
        String statement = null;
        try (Timer.Context bindTime = this.activity.bindTimer.time();){
            StringBindings stringBindings = (StringBindings)this.sequencer.get(cycleValue);
            statement = stringBindings.bind(cycleValue);
            this.showstmts = this.activity.getShowstmts();
            if (this.showstmts) {
                logger.info("STMT(cycle=" + cycleValue + "):\n" + statement);
            }
        }
        try (Timer.Context executeTime = this.activity.executeTimer.time();){
            this.activity.write(statement);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing output:" + e, e);
        }
        return 0;
    }
}

