/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.adapter.mongodb.core;

import io.nosqlbench.adapter.mongodb.core.MongoDBOpTypes;
import io.nosqlbench.adapter.mongodb.core.MongoSpace;
import io.nosqlbench.adapter.mongodb.core.MongodbDriverAdapter;
import io.nosqlbench.adapter.mongodb.dispensers.MongoCommandOpDispenser;
import io.nosqlbench.engine.api.activityimpl.OpDispenser;
import io.nosqlbench.engine.api.activityimpl.OpMapper;
import io.nosqlbench.engine.api.activityimpl.uniform.DriverAdapter;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.Op;
import io.nosqlbench.engine.api.templating.ParsedOp;
import io.nosqlbench.engine.api.templating.TypeAndTarget;
import java.util.Optional;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MongoOpMapper
implements OpMapper<Op> {
    private static final Logger logger = LogManager.getLogger(MongoOpMapper.class);
    private final MongodbDriverAdapter adapter;

    public MongoOpMapper(MongodbDriverAdapter adapter) {
        this.adapter = adapter;
    }

    public OpDispenser<? extends Op> apply(ParsedOp op) {
        Optional target;
        LongFunction ctxNamer = op.getAsFunctionOr("space", (Object)"default");
        LongFunction<MongoSpace> spaceF = l -> (MongoSpace)this.adapter.getSpaceCache().get((String)ctxNamer.apply(l));
        Optional oDatabaseF = op.getAsOptionalFunction("database");
        if (oDatabaseF.isEmpty()) {
            logger.warn(() -> "op field 'database' was not defined");
        }
        if ((target = op.getOptionalTypeAndTargetEnum(MongoDBOpTypes.class, String.class)).isPresent()) {
            TypeAndTarget targetdata = (TypeAndTarget)target.get();
            switch ((MongoDBOpTypes)targetdata.enumId) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case command: 
            }
            return new MongoCommandOpDispenser((DriverAdapter)this.adapter, spaceF, op);
        }
        return new MongoCommandOpDispenser((DriverAdapter)this.adapter, spaceF, op);
    }
}

