/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.adapter.mongodb.core;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.nosqlbench.api.config.NBNamedElement;
import io.nosqlbench.api.config.standard.ConfigModel;
import io.nosqlbench.api.config.standard.NBConfigModel;
import io.nosqlbench.api.config.standard.NBConfiguration;
import io.nosqlbench.api.config.standard.Param;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class MongoSpace
implements NBNamedElement {
    private final String name;
    private final NBConfiguration cfg;
    private final String connectionString;
    private final MongoClient client;
    private MongoDatabase mongoDatabase;

    public MongoSpace(String name, NBConfiguration cfg) {
        this.name = name;
        this.cfg = cfg;
        this.connectionString = (String)cfg.get("connection", String.class);
        this.client = this.createMongoClient(this.connectionString);
    }

    public static NBConfigModel getConfigModel() {
        return ConfigModel.of(MongoSpace.class).add(Param.required((String)"connection", String.class).setDescription("The connection string for your MongoDB endpoint")).add(Param.required((String)"database", String.class).setDescription("The database name to connect to.")).asReadOnly();
    }

    public String getName() {
        return this.name;
    }

    public MongoClient createMongoClient(String connectionString) {
        CodecRegistry codecRegistry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()});
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).codecRegistry(codecRegistry).uuidRepresentation(UuidRepresentation.STANDARD).build();
        return MongoClients.create((MongoClientSettings)settings);
    }

    protected MongoDatabase getDatabase() {
        return this.mongoDatabase;
    }

    public MongoClient getClient() {
        return this.client;
    }
}

