/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.adapter.mongodb.dispensers;

import com.mongodb.ReadPreference;
import io.nosqlbench.adapter.mongodb.core.MongoSpace;
import io.nosqlbench.adapter.mongodb.ops.MongoDirectCommandOp;
import io.nosqlbench.engine.api.activityimpl.BaseOpDispenser;
import io.nosqlbench.engine.api.activityimpl.uniform.DriverAdapter;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.Op;
import io.nosqlbench.engine.api.templating.ParsedOp;
import java.util.Map;
import java.util.function.LongFunction;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoCommandOpDispenser
extends BaseOpDispenser<Op, MongoSpace> {
    private final LongFunction<MongoDirectCommandOp> opFunc;
    private final LongFunction<MongoDirectCommandOp> mongoOpF;

    public MongoCommandOpDispenser(DriverAdapter adapter, LongFunction<MongoSpace> ctxFunc, ParsedOp op) {
        super(adapter, op);
        this.opFunc = this.createOpFunc(ctxFunc, op);
        this.mongoOpF = this.createOpFunc(ctxFunc, op);
    }

    private LongFunction<MongoDirectCommandOp> createOpFunc(LongFunction<MongoSpace> ctxFunc, ParsedOp op) {
        LongFunction<Bson> bsonFunc;
        LongFunction rpstring = op.getAsOptionalFunction("readPreference").orElseGet(() -> op.getAsOptionalFunction("read-preference").orElse(l -> "primary"));
        LongFunction<ReadPreference> readPreferenceF = l -> ReadPreference.valueOf((String)((String)rpstring.apply(l)));
        LongFunction payload = op.getAsRequiredFunction("stmt", Object.class);
        Object exampleValue = payload.apply(0L);
        if (exampleValue instanceof CharSequence) {
            CharSequence cs = (CharSequence)exampleValue;
            bsonFunc = l -> Document.parse((String)payload.apply(l).toString());
        } else if (exampleValue instanceof Map) {
            Map map = (Map)exampleValue;
            bsonFunc = l -> new Document((Map)payload.apply(l));
        } else {
            throw new RuntimeException("You must provide a String or Map for your BSON payload.");
        }
        LongFunction databaseNamerF = op.getAsRequiredFunction("database", String.class);
        return l -> new MongoDirectCommandOp(((MongoSpace)ctxFunc.apply(l)).getClient(), (String)databaseNamerF.apply(l), (Bson)bsonFunc.apply(l));
    }

    public Op apply(long cycle) {
        return (Op)this.mongoOpF.apply(cycle);
    }
}

