/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.adapter.mongodb.dispensers;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import io.nosqlbench.adapter.mongodb.core.MongoSpace;
import io.nosqlbench.adapter.mongodb.core.MongodbDriverAdapter;
import io.nosqlbench.engine.api.activityimpl.BaseOpDispenser;
import io.nosqlbench.engine.api.activityimpl.uniform.DriverAdapter;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.Op;
import io.nosqlbench.engine.api.templating.ParsedOp;
import java.util.function.LongFunction;

public class MongoDbUpdateOpDispenser
extends BaseOpDispenser<Op, MongoSpace> {
    private final LongFunction<MongoSpace> spaceF;
    private final LongFunction<Op> opF;
    private LongFunction<String> collectionF;

    public MongoDbUpdateOpDispenser(MongodbDriverAdapter adapter, ParsedOp pop, LongFunction<String> collectionF) {
        super((DriverAdapter)adapter, pop);
        this.collectionF = collectionF;
        this.spaceF = adapter.getSpaceFunc(pop);
        this.opF = this.createOpF(pop);
    }

    private LongFunction<Op> createOpF(ParsedOp pop) {
        LongFunction<MongoClient> clientF = cycle -> this.spaceF.apply(cycle).getClient();
        LongFunction<MongoDatabase> docF = l -> ((MongoClient)clientF.apply(l)).getDatabase(this.collectionF.apply(l));
        return l -> new Op(){};
    }

    public Op apply(long value) {
        Op op = this.opF.apply(value);
        return op;
    }
}

