/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.adapter.mongodb.ops;

import com.mongodb.client.MongoClient;
import io.nosqlbench.adapter.mongodb.ops.MongoOpFailedException;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.CycleOp;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDirectCommandOp
implements CycleOp<Document> {
    private final MongoClient client;
    private final Bson rqBson;
    private final String database;
    private int resultSize;

    public MongoDirectCommandOp(MongoClient client, String database, Bson rqBson) {
        this.client = client;
        this.database = database;
        this.rqBson = rqBson;
    }

    public Document apply(long value) {
        Document document = this.client.getDatabase(this.database).runCommand(this.rqBson);
        int okcode = 0;
        Object ok = document.get((Object)"ok");
        if (ok instanceof Number) {
            Number n = (Number)ok;
            okcode = n.intValue();
        }
        if (okcode != 1) {
            throw new MongoOpFailedException(this.rqBson, okcode, document);
        }
        Object nObj = document.get((Object)"n");
        if (nObj instanceof Number) {
            Number n = (Number)nObj;
            this.resultSize = n.intValue();
        }
        return document;
    }

    public long getResultSize() {
        return this.resultSize;
    }
}

