/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.diag;

import com.codahale.metrics.Timer;
import io.nosqlbench.activitytype.diag.DiagActivity;
import io.nosqlbench.activitytype.diag.DiagDummyError;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.core.MultiPhaseAction;
import io.nosqlbench.engine.api.activityapi.core.SyncAction;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagAction
implements SyncAction,
ActivityDefObserver,
MultiPhaseAction {
    private static final Logger logger = LoggerFactory.getLogger(DiagAction.class);
    private final ActivityDef activityDef;
    private final DiagActivity diagActivity;
    private int slot;
    private long lastUpdate;
    private long quantizedInterval;
    private long reportModulo;
    private int phasesPerCycle;
    private int completedPhase;
    private int resultmodulo = Integer.MIN_VALUE;
    private long erroroncycle = Long.MIN_VALUE;
    private long throwoncycle = Long.MIN_VALUE;
    private boolean logcycle;
    private int staticvalue = Integer.MIN_VALUE;
    private RateLimiter diagRateLimiter = null;
    private Timer resultTimer;

    public DiagAction(int slot, ActivityDef activityDef, DiagActivity diagActivity) {
        this.activityDef = activityDef;
        this.slot = slot;
        this.diagActivity = diagActivity;
        this.onActivityDefUpdate(activityDef);
    }

    private void updateReportTime() {
        this.reportModulo = this.activityDef.getParams().getOptionalLong("modulo").orElse(10000000L);
        this.lastUpdate = System.currentTimeMillis() - this.calculateOffset(this.slot, this.activityDef);
        this.quantizedInterval = this.calculateInterval(this.activityDef);
        logger.trace("updating report time for slot:" + this.slot + ", def:" + this.activityDef + " to " + this.quantizedInterval + ", and modulo " + this.reportModulo);
    }

    private void updatePhases() {
        this.phasesPerCycle = this.activityDef.getParams().getOptionalInteger("phases").orElse(1);
    }

    private long calculateOffset(long timeslot, ActivityDef activityDef) {
        long updateInterval = activityDef.getParams().getOptionalLong("interval").orElse(1000L);
        long offset = this.calculateInterval(activityDef) - updateInterval * timeslot;
        return offset;
    }

    private long calculateInterval(ActivityDef activityDef) {
        long updateInterval = activityDef.getParams().getOptionalLong("interval").orElse(1000L);
        if (updateInterval == 0L) {
            return Long.MAX_VALUE;
        }
        int threads = activityDef.getThreads();
        return updateInterval * (long)threads;
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.updateReportTime();
        this.updatePhases();
        this.resultmodulo = activityDef.getParams().getOptionalInteger("resultmodulo").orElse(Integer.MIN_VALUE);
        this.erroroncycle = activityDef.getParams().getOptionalLong("erroroncycle").orElse(Long.MIN_VALUE);
        this.throwoncycle = activityDef.getParams().getOptionalLong("throwoncycle").orElse(Long.MIN_VALUE);
        this.logcycle = activityDef.getParams().getOptionalBoolean("logcycle").orElse(false);
        this.staticvalue = activityDef.getParams().getOptionalInteger("staticvalue").orElse(-1);
        this.diagRateLimiter = this.diagActivity.getDiagRateLimiter();
        this.resultTimer = this.diagActivity.getResultTimer();
    }

    public boolean incomplete() {
        return this.completedPhase < this.phasesPerCycle;
    }

    public int runPhase(long value) {
        return this.runCycle(value);
    }

    public int runCycle(long value) {
        if (this.logcycle) {
            logger.trace("cycle " + value);
        }
        try (Timer.Context timerctx = this.resultTimer.time();){
            if (this.diagRateLimiter != null) {
                long l = this.diagRateLimiter.maybeWaitForOp();
            }
            long now = System.currentTimeMillis();
            if (this.completedPhase >= this.phasesPerCycle) {
                this.completedPhase = 0;
            }
            if (now - this.lastUpdate > this.quantizedInterval) {
                long delay = now - this.lastUpdate - this.quantizedInterval;
                logger.info("diag action interval, input=" + value + ", phase=" + this.completedPhase + ", report delay=" + delay + "ms");
                this.lastUpdate += this.quantizedInterval;
                this.diagActivity.delayHistogram.update(delay);
            }
            if (value % this.reportModulo == 0L) {
                logger.info("diag action   modulo, input=" + value + ", phase=" + this.completedPhase);
            }
            ++this.completedPhase;
            byte result = 0;
            if (this.resultmodulo >= 0) {
                result = value % (long)this.resultmodulo == 0L ? (byte)1 : 0;
            } else {
                if (this.staticvalue >= 0) {
                    int n = this.staticvalue;
                    return n;
                }
                result = (byte)(value % 128L);
            }
            if (this.erroroncycle == value) {
                this.diagActivity.getActivityController().stopActivityWithReasonAsync("Diag was requested to stop on cycle " + this.erroroncycle);
            }
            if (this.throwoncycle == value) {
                throw new DiagDummyError("Diag was asked to throw an error on cycle " + this.throwoncycle);
            }
            byte by = result;
            return by;
        }
    }
}

