/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.diag;

import io.nosqlbench.activitytype.diag.DiagActivity;
import io.nosqlbench.activitytype.diag.DiagOpData;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.BaseAsyncAction;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.CompletedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.nosqlbench.engine.api.activityapi.core.ops.fluent.opfacets.TrackedOp;
import io.nosqlbench.engine.api.activityapi.cyclelog.buffers.op_output.StrideOutputConsumer;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ParameterMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDiagAction
extends BaseAsyncAction<DiagOpData, DiagActivity>
implements Thread.UncaughtExceptionHandler,
StrideOutputConsumer<DiagOpData> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncDiagAction.class);
    private long lastUpdate;
    private long quantizedInterval;
    private long reportModulo;
    private int phasesPerCycle;
    private int completedPhase;
    private long erroroncycle = Long.MIN_VALUE;
    private long throwoncycle = Long.MIN_VALUE;
    private boolean logcycle;
    private RateLimiter diagRateLimiter = null;
    private LongToIntFunction resultFunc;
    private LongUnaryOperator delayFunc;
    private LinkedBlockingDeque<StartedOp<DiagOpData>> opQueue;
    private OpFinisher finisher;
    private boolean enableOutputProcessing;

    public AsyncDiagAction(DiagActivity activity, int slot) {
        super((Activity)activity, slot);
        this.onActivityDefUpdate(activity.getActivityDef());
    }

    public void requestStop() {
        super.requestStop();
    }

    private void updateReportTime() {
        ParameterMap params = ((DiagActivity)this.activity).getActivityDef().getParams();
        this.reportModulo = params.getOptionalLong("modulo").orElse(10000000L);
        this.lastUpdate = System.currentTimeMillis() - this.calculateOffset(this.slot, params);
        this.quantizedInterval = this.calculateInterval(params, ((DiagActivity)this.activity).getActivityDef().getThreads());
        logger.trace("updating report time for slot:" + this.slot + ", def:" + params + " to " + this.quantizedInterval + ", and modulo " + this.reportModulo);
    }

    private long calculateOffset(long timeslot, ParameterMap params) {
        long updateInterval = params.getOptionalLong("interval").orElse(1000L);
        long offset = this.calculateInterval(params, ((DiagActivity)this.activity).getActivityDef().getThreads()) - updateInterval * timeslot;
        return offset;
    }

    private long calculateInterval(ParameterMap params, int threads) {
        long updateInterval = params.getOptionalLong("interval").orElse(1000L);
        if (updateInterval == 0L) {
            return Long.MAX_VALUE;
        }
        return updateInterval * (long)threads;
    }

    public void init() {
        this.opQueue = new LinkedBlockingDeque();
        this.finisher = new OpFinisher(((DiagActivity)this.activity).getAlias() + "_finisher_" + this.slot, this.opQueue, this);
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        ParameterMap params = activityDef.getParams();
        this.updateReportTime();
        this.delayFunc = ((DiagActivity)this.activity).getDelayFunc();
        this.resultFunc = ((DiagActivity)this.activity).getResultFunc();
        this.erroroncycle = params.getOptionalLong("erroroncycle").orElse(Long.MIN_VALUE);
        this.throwoncycle = params.getOptionalLong("throwoncycle").orElse(Long.MIN_VALUE);
        this.logcycle = params.getOptionalBoolean("logcycle").orElse(false);
        this.diagRateLimiter = ((DiagActivity)this.activity).getDiagRateLimiter();
        this.enableOutputProcessing = params.getOptionalBoolean("enable_output_processing").orElse(false);
    }

    public LongFunction<DiagOpData> getOpInitFunction() {
        return l -> new DiagOpData("a diag op");
    }

    public void startOpCycle(TrackedOp<DiagOpData> opc) {
        ((DiagOpData)opc.getOpData()).log("starting at " + System.nanoTime());
        ((DiagOpData)opc.getOpData()).setSimulatedDelayNanos(this.delayFunc.applyAsLong(opc.getCycle()));
        StartedOp started = opc.start();
        this.opQueue.add((StartedOp<DiagOpData>)started);
    }

    private int backendExecuteOp(StartedOp<DiagOpData> opc) {
        long cycle = opc.getCycle();
        if (this.logcycle) {
            logger.trace("cycle " + cycle);
        }
        if (this.diagRateLimiter != null) {
            this.diagRateLimiter.maybeWaitForOp();
        }
        long now = System.currentTimeMillis();
        if (this.completedPhase >= this.phasesPerCycle) {
            this.completedPhase = 0;
        }
        if (now - this.lastUpdate > this.quantizedInterval) {
            long delay = now - this.lastUpdate - this.quantizedInterval;
            logger.info("diag action interval, input=" + cycle + ", phase=" + this.completedPhase + ", report delay=" + delay + "ms");
            this.lastUpdate += this.quantizedInterval;
            ((DiagActivity)this.activity).delayHistogram.update(delay);
        }
        if (cycle % this.reportModulo == 0L) {
            logger.info("diag action   modulo, input=" + cycle + ", phase=" + this.completedPhase);
        }
        ++this.completedPhase;
        int result = this.resultFunc.applyAsInt(cycle);
        if (this.erroroncycle == cycle) {
            ((DiagActivity)this.activity).getActivityController().stopActivityWithReasonAsync("Diag was requested to stop on cycle " + this.erroroncycle);
        }
        if (this.throwoncycle == cycle) {
            throw new RuntimeException("Diag was asked to throw an error on cycle " + this.throwoncycle);
        }
        return result;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error("Error on finisher thread: " + t.getName() + ", error: " + e.getMessage());
        this.requestStop();
    }

    public void onStrideOutput(List<CompletedOp<DiagOpData>> completedOps) {
        if (this.enableOutputProcessing) {
            logger.info("processing stride output for " + completedOps.get(0).getCycle());
            long start = completedOps.get(0).getCycle();
            long endPlus = completedOps.get(completedOps.size() - 1).getCycle() + 1L;
            String diagLog = ((DiagOpData)completedOps.get(0).getOpData()).getDiagLog().stream().collect(Collectors.joining("\n"));
            ((DiagActivity)this.activity).getSequenceBlocker().awaitAndRun(start, endPlus, () -> logger.info(" => " + start + " -> " + endPlus + ": " + diagLog));
        }
    }

    private static class OpFinisher
    implements Runnable {
        final BlockingQueue<StartedOp<DiagOpData>> queue;
        private final AsyncDiagAction action;
        AsyncDiagAction mainContext;
        private volatile boolean running = true;
        private Thread thread;
        private String name;

        public OpFinisher(String name, BlockingQueue<StartedOp<DiagOpData>> queue, AsyncDiagAction action) {
            this.queue = queue;
            this.action = action;
            this.name = name;
            this.thread = new Thread(this);
            this.thread.setName(name);
            this.thread.setUncaughtExceptionHandler(action);
            this.thread.start();
        }

        public void requestStop() {
            this.running = false;
        }

        @Override
        public void run() {
            logger.debug("stopping finisher thread for diagnostic action " + this.name);
            while (this.running) {
                try {
                    int result;
                    StartedOp<DiagOpData> opc = this.queue.take();
                    DiagOpData op = (DiagOpData)opc.getOpData();
                    long now = System.nanoTime();
                    long simulatedCompletionTime = opc.getStartedAtNanos() + op.getSimulatedDelayNanos();
                    long nanodelay = Math.max(0L, simulatedCompletionTime - now);
                    if (nanodelay >= 1000L) {
                        LockSupport.parkNanos(nanodelay);
                    }
                    if ((result = this.action.backendExecuteOp(opc)) == 0) {
                        opc.succeed(result);
                        continue;
                    }
                    opc.fail(result);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug("stopping finisher thread for diagnostic action " + this.name);
        }
    }
}

