/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.diag;

import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceBlocker {
    private static final Logger logger = LoggerFactory.getLogger(SequenceBlocker.class);
    private final AtomicLong sequence;
    private final AtomicLong waiting = new AtomicLong(0L);
    private final boolean errorsAreFatal;
    private Exception fatalError;

    public SequenceBlocker(long start, boolean errorsAreFatal) {
        this.sequence = new AtomicLong(start);
        this.errorsAreFatal = errorsAreFatal;
    }

    public synchronized void awaitAndRun(long startAt, long endPlus, Runnable task) {
        this.waiting.incrementAndGet();
        if (this.fatalError != null) {
            throw new RuntimeException("There was previously a fatal error, not allowing new tasks. Error=" + this.fatalError.getMessage());
        }
        while (this.sequence.get() != startAt) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            task.run();
        }
        catch (Exception e) {
            logger.error("Runnable errored in SequenceBlocker: " + e.getMessage());
            if (this.errorsAreFatal) {
                this.fatalError = e;
            }
            throw e;
        }
        finally {
            this.waiting.decrementAndGet();
            if (!this.sequence.compareAndSet(startAt, endPlus)) {
                throw new InvalidParameterException("Serious logic error in synchronizer. This should never fail.");
            }
        }
        this.notifyAll();
    }

    public synchronized void awaitCompletion() {
        while (this.waiting.get() > 0L) {
            try {
                this.wait(60000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static final class TakeANumber
    implements Comparable<TakeANumber> {
        private final long start;
        private final long endPlus;
        private final Runnable task;

        public TakeANumber(long start, long endPlus, Runnable task) {
            this.start = start;
            this.endPlus = endPlus;
            this.task = task;
        }

        @Override
        public int compareTo(TakeANumber o) {
            return Long.compare(this.start, o.start);
        }

        public long getStart() {
            return this.start;
        }

        public long getEndPlus() {
            return this.endPlus;
        }

        public String toString() {
            return "[" + this.getStart() + "-" + this.getEndPlus() + ")";
        }
    }
}

