/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.activitytype.diag;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import io.nosqlbench.activitytype.diag.SequenceBlocker;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiters;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.SimpleActivity;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class DiagActivity
extends SimpleActivity
implements Activity,
ActivityDefObserver {
    public Counter pendingOpsCounter;
    protected Histogram delayHistogram;
    private RateLimiter diagRateLimiter;
    private boolean async = false;
    private long maxAsync;
    private LongToIntFunction resultFunc = new ResultFunc_Modulo128();
    private LongUnaryOperator delayFunc = new DelayFunc_NoDelay();
    private SequenceBlocker sequenceBlocker;

    public DiagActivity(ActivityDef activityDef) {
        super(activityDef);
    }

    public void initActivity() {
        super.initActivity();
        this.delayHistogram = ActivityMetrics.histogram((ActivityDef)this.activityDef, (String)"diagdelay");
        Integer initdelay = this.activityDef.getParams().getOptionalInteger("initdelay").orElse(0);
        try {
            Thread.sleep(initdelay.intValue());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAsync()) {
            this.pendingOpsCounter = ActivityMetrics.counter((ActivityDef)this.activityDef, (String)"pending_ops");
        }
    }

    public RateLimiter getDiagRateLimiter() {
        return this.diagRateLimiter;
    }

    public synchronized void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        activityDef.getParams().getOptionalString(new String[]{"diagrate"}).map(RateSpec::new).ifPresent(spec -> {
            this.diagRateLimiter = RateLimiters.createOrUpdate((ActivityDef)this.getActivityDef(), (String)"diag", (RateLimiter)this.diagRateLimiter, (RateSpec)spec);
        });
        this.delayFunc = activityDef.getParams().getOptionalString(new String[]{"delayfunc"}).map(m -> (LongUnaryOperator)VirtData.getFunction((String)m, LongUnaryOperator.class)).orElse(null);
        if (this.delayFunc == null) {
            this.delayFunc = new DelayFunc_NoDelay();
        }
        activityDef.getParams().assertOnlyOneOf(new String[]{"resultfunc", "resultmodulo", "staticvalue"});
        activityDef.getParams().getOptionalString(new String[]{"resultfunc"}).map(m -> (LongToIntFunction)VirtData.getFunction((String)m, LongToIntFunction.class)).ifPresent(f -> {
            this.resultFunc = f;
        });
        activityDef.getParams().getOptionalString(new String[]{"resultmodulo"}).map(Long::valueOf).map(x$0 -> new ResultFunc_ResultModulo((long)x$0)).ifPresent(f -> {
            this.resultFunc = f;
        });
        activityDef.getParams().getOptionalString(new String[]{"staticvalue"}).map(Long::valueOf).map(x$0 -> new ResultFunc_StaticValue((long)x$0)).ifPresent(f -> {
            this.resultFunc = f;
        });
        if (this.resultFunc == null) {
            this.resultFunc = new ResultFunc_Modulo128();
        }
    }

    public LongToIntFunction getResultFunc() {
        return this.resultFunc;
    }

    public LongUnaryOperator getDelayFunc() {
        return this.delayFunc;
    }

    public boolean isAsync() {
        return this.activityDef.getParams().getOptionalInteger("async").isPresent();
    }

    public long getMaxAsync() {
        return this.activityDef.getParams().getOptionalInteger("async").orElse(1).intValue();
    }

    public synchronized SequenceBlocker getSequenceBlocker() {
        if (this.sequenceBlocker == null) {
            this.sequenceBlocker = new SequenceBlocker(this.getActivityDef().getStartCycle(), true);
        }
        return this.sequenceBlocker;
    }

    private final class ResultFunc_Modulo128
    implements LongToIntFunction {
        private ResultFunc_Modulo128() {
        }

        @Override
        public int applyAsInt(long value) {
            return (byte)(value % 128L);
        }
    }

    private final class DelayFunc_NoDelay
    implements LongUnaryOperator {
        private DelayFunc_NoDelay() {
        }

        @Override
        public long applyAsLong(long operand) {
            return 0L;
        }
    }

    private final class ResultFunc_StaticValue
    implements LongToIntFunction {
        private final long resultValue;

        public ResultFunc_StaticValue(long resultValue) {
            this.resultValue = resultValue;
        }

        @Override
        public int applyAsInt(long value) {
            return (int)this.resultValue;
        }
    }

    private final class ResultFunc_ResultModulo
    implements LongToIntFunction {
        private long modulo;

        private ResultFunc_ResultModulo(long modulo) {
            this.modulo = modulo;
        }

        @Override
        public int applyAsInt(long value) {
            if (value % this.modulo == 0L) {
                return 1;
            }
            return 0;
        }
    }
}

