/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.jmx;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecureUtils {
    private static final Logger logger = LogManager.getLogger(SecureUtils.class);

    public static String readSecret(String description, String source) {
        if (source == null) {
            return null;
        }
        if (source.startsWith("file:")) {
            String sourceFile = source.substring("file:".length());
            try {
                return Files.readString(Path.of(sourceFile, new String[0]), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (source.startsWith("console:") || source.equals("")) {
            System.out.print("Enter " + description + ":");
            char[] chars = System.console().readPassword("%s:", description);
            return new String(chars);
        }
        logger.warn("Parameter for '" + description + "' was passed directly. This is less secure. Consider using 'file:<file>' or 'console:' for this value instead");
        return source;
    }
}

