/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.jmx.ops;

import io.nosqlbench.driver.jmx.ValueConverter;
import io.nosqlbench.driver.jmx.ops.JmxOp;
import io.nosqlbench.virtdata.library.basics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class JMXReadOperation
extends JmxOp {
    public static final String READVAR = "readvar";
    public static final String AS_TYPE = "as_type";
    public static final String AS_NAME = "as_name";
    public static final String SCOPE = "scope";
    protected final String attribute;
    protected final String asType;
    protected final String asName;
    protected final SharedState.Scope scope;

    public JMXReadOperation(JMXConnector connector, ObjectName objectName, String attribute, Map<String, String> cfg) {
        super(connector, objectName);
        this.attribute = attribute;
        this.asType = cfg.remove(AS_TYPE);
        this.asName = cfg.remove(AS_NAME);
        String scopeName = cfg.remove(SCOPE);
        this.scope = scopeName != null ? SharedState.Scope.valueOf((String)scopeName) : SharedState.Scope.process;
    }

    @Override
    public void execute() {
        Object value = this.readObject(this.attribute);
        if (this.asType != null) {
            value = ValueConverter.convert(this.asType, value);
        }
        String storedName = this.asName == null ? this.attribute : this.asName;
        switch (this.scope) {
            case process: {
                SharedState.gl_ObjectMap.put(storedName, value);
                break;
            }
            case thread: {
                ((HashMap)SharedState.tl_ObjectMap.get()).put(storedName, value);
            }
        }
    }
}

