/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.jmx.ops;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JmxOp {
    protected static final Logger logger = LogManager.getLogger(JmxOp.class);
    protected JMXConnector connector;
    protected ObjectName objectName;

    public JmxOp(JMXConnector connector, ObjectName objectName) {
        this.connector = connector;
        this.objectName = objectName;
    }

    public MBeanServerConnection getMBeanConnection() {
        MBeanServerConnection connection = null;
        try {
            connection = this.connector.getMBeanServerConnection();
            return connection;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object readObject(String attributeName) {
        try {
            Object value = this.getMBeanConnection().getAttribute(this.objectName, attributeName);
            logger.trace("read attribute '" + value + "': " + value);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void execute();
}

