/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.jmx.formats;

import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class MBeanInfoConsoleFormat {
    private static final Map<Integer, String> MbeanOpImpacts = Map.of(1, "ACTION", 2, "ACTION_INFO", 3, "UNKNOWN", 0, "INFO");

    public static String formatAsText(MBeanInfo info, ObjectName objectName) {
        MBeanOperationInfo[] operations;
        MBeanNotificationInfo[] notifications;
        MBeanAttributeInfo[] attributes;
        StringBuilder sb = new StringBuilder();
        sb.append("### MBeanInfo for '").append(objectName).append("'\n");
        String className = info.getClassName();
        sb.append("# classname: ").append(className).append("\n");
        String description = info.getDescription();
        sb.append("# ").append(description).append("\n");
        MBeanConstructorInfo[] constructors = info.getConstructors();
        if (constructors.length > 0) {
            sb.append("## constructors:\n");
            for (MBeanConstructorInfo constructor : constructors) {
                String ctorDesc = constructor.getDescription();
                sb.append("# ").append(ctorDesc).append("\n");
                String name = constructor.getName();
                sb.append("# ").append(name).append("(");
                sb.append(MBeanInfoConsoleFormat.pramDetail(constructor.getSignature(), "  "));
                sb.append("  )\n");
            }
        }
        if ((attributes = info.getAttributes()).length > 0) {
            sb.append("## attributes:\n");
            for (MBeanAttributeInfo attribute : attributes) {
                String attrDesc = attribute.getDescription();
                String attrName = attribute.getName();
                String attrType = attribute.getType();
                sb.append("# ").append(attrDesc).append("\n");
                sb.append("- '").append(attrName).append("' type=").append(attrType);
                sb.append("readable=").append(attribute.isReadable()).append(" writable=").append(attribute.isWritable()).append(" is_is=").append(attribute.isIs());
                sb.append("\n");
            }
        }
        if ((notifications = info.getNotifications()).length > 0) {
            sb.append("## notifications:\n");
            for (MBeanNotificationInfo notification : notifications) {
                String notifName = notification.getName();
                String notifDesc = notification.getDescription();
                String[] notifTypes = notification.getNotifTypes();
                Class<?> notifClass = notification.getClass();
                sb.append("# ").append(notifDesc).append("\n");
                sb.append("- ").append(notifName).append(" [").append(MBeanInfoConsoleFormat.descriptorDetail(notification.getDescriptor())).append("]\n");
                if (notifTypes.length <= 0) continue;
                for (String notifType : notifTypes) {
                    sb.append(" - ").append(notifType).append("\n");
                }
            }
        }
        if ((operations = info.getOperations()).length > 0) {
            sb.append("## operations:\n");
            for (MBeanOperationInfo operation : operations) {
                String opDesc = operation.getDescription();
                String opName = operation.getName();
                MBeanParameterInfo[] opSig = operation.getSignature();
                Class<?> opClass = operation.getClass();
                sb.append("# ").append(opDesc).append("\n");
                sb.append("- ").append(opName).append("(");
                sb.append(MBeanInfoConsoleFormat.pramDetail(operation.getSignature(), " "));
                sb.append(") -> ").append(operation.getReturnType());
                sb.append(" impact=").append(MbeanOpImpacts.get(operation.getImpact())).append("\n");
            }
        }
        return sb.toString();
    }

    private static String descriptorDetail(Descriptor descriptor) {
        String[] fieldNames;
        StringBuilder sb = new StringBuilder();
        sb.append("valid=").append(descriptor.isValid());
        for (String field : fieldNames = descriptor.getFieldNames()) {
            sb.append(" ").append(field).append("=").append(descriptor.getFieldValue(field));
        }
        return sb.toString();
    }

    private static String pramDetail(MBeanParameterInfo[] signature, String prefix) {
        StringBuilder sb = new StringBuilder();
        for (MBeanParameterInfo paramInfo : signature) {
            String desc = paramInfo.getDescription();
            if (desc != null) {
                sb.append(prefix).append(" # ").append(desc).append("\n");
            }
            sb.append(prefix).append(" - ").append(paramInfo.getName()).append("\n");
        }
        return sb.toString();
    }
}

