/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.jmx;

import io.nosqlbench.driver.jmx.SecureUtils;
import io.nosqlbench.driver.jmx.ops.JMXExplainOperation;
import io.nosqlbench.driver.jmx.ops.JMXPrintOperation;
import io.nosqlbench.driver.jmx.ops.JMXReadOperation;
import io.nosqlbench.driver.jmx.ops.JmxOp;
import io.nosqlbench.engine.api.activityimpl.OpDispenser;
import io.nosqlbench.engine.api.templating.CommandTemplate;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ReadyJmxOp
implements OpDispenser<JmxOp> {
    private final CommandTemplate command;

    public ReadyJmxOp(CommandTemplate command) {
        this.command = command;
    }

    public JmxOp apply(long value) {
        Map cmdmap = this.command.getCommand(value);
        JMXConnector connector = this.bindConnector(cmdmap);
        if (!cmdmap.containsKey("object")) {
            throw new RuntimeException("You must specify an object in a jmx operation as in object=...");
        }
        ObjectName objectName = null;
        try {
            String object = (String)cmdmap.get("object");
            if (object == null) {
                throw new RuntimeException("You must specify an object name for any JMX operation.");
            }
            objectName = new ObjectName(object);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        if (cmdmap.containsKey("readvar")) {
            return new JMXReadOperation(connector, objectName, (String)cmdmap.get("readvar"), cmdmap);
        }
        if (cmdmap.containsKey("printvar")) {
            return new JMXPrintOperation(connector, objectName, (String)cmdmap.get("printvar"), cmdmap);
        }
        if (cmdmap.containsKey("explain")) {
            return new JMXExplainOperation(connector, objectName);
        }
        throw new RuntimeException("No valid form of JMX operation was determined from the provided command details:" + cmdmap.toString());
    }

    private JMXConnector bindConnector(Map<String, String> cmdmap) {
        HashMap<String, String[]> connectorEnv = new HashMap<String, String[]>();
        String username = cmdmap.remove("username");
        String password = cmdmap.remove("password");
        username = SecureUtils.readSecret("JMX username", username);
        password = SecureUtils.readSecret("JMX password", password);
        if (username != null && password != null) {
            connectorEnv.put("jmx.remote.credentials", new String[]{username, password});
        }
        JMXConnector connector = null;
        try {
            JMXServiceURL url = this.bindJMXServiceURL(cmdmap);
            connector = JMXConnectorFactory.connect(url, connectorEnv);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return connector;
    }

    private JMXServiceURL bindJMXServiceURL(Map<String, String> cmdmap) {
        JMXServiceURL url = null;
        try {
            if (cmdmap.containsKey("url")) {
                url = new JMXServiceURL(cmdmap.get("url"));
            } else {
                if (cmdmap.containsKey("host")) {
                    throw new RuntimeException("You must provide at least a host if you do not provide a url.");
                }
                String protocol = cmdmap.get("protocol");
                String host = cmdmap.get("host");
                int port = Optional.ofNullable(cmdmap.get("port")).map(Integer::parseInt).orElse(0);
                String path = cmdmap.get("path");
                url = new JMXServiceURL(protocol, host, port, path);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return url;
    }
}

