/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver.verbs;

import io.nosqlbench.driver.webdriver.CommandTemplate;
import io.nosqlbench.driver.webdriver.WebContext;
import io.nosqlbench.driver.webdriver.verbs.Bys;
import io.nosqlbench.driver.webdriver.verbs.Get;
import io.nosqlbench.driver.webdriver.verbs.MouseOut;
import io.nosqlbench.driver.webdriver.verbs.MouseOver;
import io.nosqlbench.driver.webdriver.verbs.Open;
import io.nosqlbench.driver.webdriver.verbs.SetWindowSize;
import io.nosqlbench.driver.webdriver.verbs.WebDriverVerb;
import io.nosqlbench.nb.api.errors.BasicError;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverVerbs {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverVerbs.class);
    public static final String COMMAND = "command";

    public static void execute(long cycle, CommandTemplate commandTemplate, WebContext context, boolean dryrun) {
        Map<String, String> cmdprops = commandTemplate.getCommand(cycle);
        logger.debug("cycle:" + cmdprops + " command:" + cmdprops);
        String command = cmdprops.get(COMMAND);
        Optional<Verb> oVerb = Verb.find(command);
        Verb verb = oVerb.orElseThrow(() -> new BasicError("I don't know how to '" + command + "'"));
        WebDriverVerb resolve = verb.resolve(cmdprops);
        if (dryrun) {
            logger.info("skipping cycle " + cycle + " because dryrun is set to true");
            return;
        }
        logger.info("running cycle " + cycle + " because dryrun is set to false");
        resolve.execute(context);
    }

    public static enum Verb {
        open(Open.class, m -> new Open((String)m.get("url"), (String)m.get("target"))),
        get(Get.class, m -> new Get((String)m.get("target"))),
        mouseOver(MouseOver.class, m -> new MouseOver(Bys.get((String)m.get("target")))),
        mouseOut(MouseOut.class, m -> new MouseOut()),
        setWindowSize(SetWindowSize.class, m -> new SetWindowSize((String)m.get("target")));

        private final Class<? extends WebDriverVerb> verbClass;
        private final Function<Map<String, String>, WebDriverVerb> initializer;

        private Verb(Class<? extends WebDriverVerb> verbClass, Function<Map<String, String>, WebDriverVerb> initializer) {
            this.verbClass = verbClass;
            this.initializer = initializer;
        }

        public static Optional<Verb> find(String command) {
            try {
                return Optional.of(Verb.valueOf(command));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }

        public WebDriverVerb resolve(Map<String, String> commandProps) {
            String cmd = commandProps.get(WebDriverVerbs.COMMAND);
            if (cmd == null) {
                throw new InvalidParameterException("command properties must always contain a 'command' entry'");
            }
            Verb verb = Verb.valueOf(cmd);
            return verb.initializer.apply(commandProps);
        }
    }
}

