/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver;

import io.nosqlbench.engine.api.activityconfig.yaml.StmtDef;
import io.nosqlbench.engine.api.activityimpl.motor.ParamsParser;
import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import io.nosqlbench.virtdata.core.templates.StringBindings;
import io.nosqlbench.virtdata.core.templates.StringBindingsTemplate;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTemplate {
    private static final Logger logger = LoggerFactory.getLogger(CommandTemplate.class);
    private final String name;
    private LinkedHashMap<String, StringBindings> cmdspec = new LinkedHashMap();

    public CommandTemplate(StmtDef stmt, boolean canonicalize) {
        this.name = stmt.getName();
        String prefixed = "command=" + stmt.getStmt();
        Map cmdMap = ParamsParser.parse((String)prefixed, (boolean)canonicalize);
        Map paramsMap = stmt.getParams();
        paramsMap.forEach((k, v) -> {
            if (cmdMap.containsKey(k)) {
                logger.warn("command property override: '" + k + "' superseded by param form with value '" + v + "'");
            }
            cmdMap.put(k, v);
        });
        cmdMap.forEach((param, value) -> {
            ParsedTemplate paramTemplate = new ParsedTemplate(value, stmt.getBindings());
            BindingsTemplate paramBindings = new BindingsTemplate(paramTemplate.getBindPoints());
            StringBindings paramStringBindings = new StringBindingsTemplate(value, paramBindings).resolve();
            this.cmdspec.put((String)param, paramStringBindings);
        });
    }

    public CommandTemplate(String command, Map<String, String> bindings, String name, boolean canonicalize) {
        this.name = name;
        Map cmdMap = ParamsParser.parse((String)command, (boolean)canonicalize);
        cmdMap.forEach((param, value) -> {
            ParsedTemplate paramTemplate = new ParsedTemplate(command, bindings);
            BindingsTemplate paramBindings = new BindingsTemplate(paramTemplate.getBindPoints());
            StringBindings paramStringBindings = new StringBindingsTemplate(value, paramBindings).resolve();
            this.cmdspec.put((String)param, paramStringBindings);
        });
    }

    public Map<String, String> getCommand(long cycle) {
        LinkedHashMap<String, String> cmd = new LinkedHashMap<String, String>(this.cmdspec.size());
        this.cmdspec.forEach((k, v) -> cmd.put((String)k, v.bind(cycle)));
        return cmd;
    }

    public String getName() {
        return this.name;
    }
}

