/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver;

import io.nosqlbench.driver.webdriver.WebContext;
import io.nosqlbench.driver.webdriver.WebDriverActivity;
import io.nosqlbench.driver.webdriver.verbs.WebDriverVerbs;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.core.SyncAction;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.templating.CommandTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverAction
implements SyncAction,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverAction.class);
    private final WebDriverActivity activity;
    private final int slot;
    private String errors;
    private boolean dryrun;
    private WebContext context;

    public WebDriverAction(WebDriverActivity activity, int slot) {
        this.activity = activity;
        this.slot = slot;
    }

    public void init() {
        this.onActivityDefUpdate(this.activity.getActivityDef());
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.errors = activityDef.getParams().getOptionalString(new String[]{"errors"}).orElse("stop");
        this.dryrun = activityDef.getParams().getOptionalBoolean("dryrun").orElse(false);
        this.context = this.activity.getWebContext(this.slot);
    }

    public int runCycle(long value) {
        CommandTemplate commandTemplate = (CommandTemplate)this.activity.getOpSequence().get(value);
        try {
            WebDriverVerbs.execute(value, commandTemplate, this.context, this.dryrun);
            return 0;
        }
        catch (Exception e) {
            logger.error("Error with cycle(" + value + "), statement(" + commandTemplate.getName() + "): " + e.getMessage());
            if (this.errors.equals("stop")) {
                throw e;
            }
            return 1;
        }
    }
}

