/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.nosqlbench.driver.webdriver.CommandTemplate;
import io.nosqlbench.driver.webdriver.WebContext;
import io.nosqlbench.driver.webdriver.side.Command;
import io.nosqlbench.driver.webdriver.side.SideConfig;
import io.nosqlbench.driver.webdriver.side.Test;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencePlanner;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import io.nosqlbench.engine.api.activityconfig.StatementsLoader;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtDef;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.SimpleActivity;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverActivity
extends SimpleActivity {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverActivity.class);
    private OpSequence<CommandTemplate> opSequence;
    private ConcurrentHashMap<Integer, WebContext> contexts = new ConcurrentHashMap();

    public WebDriverActivity(ActivityDef activityDef) {
        super(activityDef);
    }

    public void initActivity() {
        super.initActivity();
        this.opSequence = this.initOpSequence();
        this.onActivityDefUpdate(this.activityDef);
        this.setDefaultsFromOpSequence(this.opSequence);
        int threads = this.getActivityDef().getThreads();
        logger.info("pre-initializing web browsers");
        for (int i = 0; i < threads; ++i) {
            this.getWebContext(i);
        }
    }

    private OpSequence<CommandTemplate> initOpSequence() {
        String yaml_loc = this.getParams().getOptionalString(new String[]{"yaml"}).orElse(null);
        String side_loc = this.getParams().getOptionalString(new String[]{"side"}).orElse(null);
        if (yaml_loc == null && side_loc == null) {
            throw new BasicError("You must provide yaml= or side=, but neither was found");
        }
        if (yaml_loc != null && side_loc != null) {
            throw new BasicError("You must provide either yaml= or side=, but not both.");
        }
        OpSequence<CommandTemplate> sequence = yaml_loc != null ? this.initOpSequenceFromYaml() : this.initOpSequenceFromSide();
        if (sequence.getSequence().length == 0) {
            logger.warn("The sequence contains zero operations.");
        }
        return sequence;
    }

    private OpSequence<CommandTemplate> initOpSequenceFromSide() {
        Optional sideFile = this.activityDef.getParams().getOptionalString(new String[]{"side"});
        String sideToImport = (String)sideFile.get();
        String side = NBIO.all().name(new String[]{sideToImport}).extension(new String[]{"side"}).one().asString();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        SideConfig sc = (SideConfig)gson.fromJson(side, SideConfig.class);
        String sideName = sc.getName();
        String sideUrl = sc.getUrl();
        LinkedHashMap<Object, String> commands = new LinkedHashMap<Object, String>();
        for (Test test : sc.getTests()) {
            int idx = 0;
            StringBuilder testBuilder = new StringBuilder();
            for (Command command : test.getCommands()) {
                StringBuilder cmdBuilder = new StringBuilder();
                String cmd2 = command.getCommand();
                cmdBuilder.append(cmd2);
                if (command.getCommand().equals("open")) {
                    cmdBuilder.append(" url='").append(sideUrl.replaceAll("'", "\\\\'")).append("'");
                }
                if (command.getTarget() != null && !command.getTarget().isEmpty()) {
                    String tg = null;
                    if (command.getTargets().size() > 0) {
                        for (int i = 0; i < command.getTargets().size(); ++i) {
                            List<String> strings = command.getTargets().get(i);
                            if (!strings.get(1).equals("xpath:idRelative")) continue;
                            logger.debug("favoring xpath form of selector:" + strings.get(0));
                            tg = strings.get(0);
                        }
                    }
                    if (tg == null) {
                        tg = command.getTarget();
                    }
                    cmdBuilder.append(" target='").append(tg.replaceAll("'", "\\\\'")).append("'");
                }
                if (command.getValue() != null && !command.getValue().isEmpty()) {
                    cmdBuilder.append(" value='").append(command.getValue().replaceAll("'", "\\\\'")).append("'");
                }
                cmdBuilder.append("\n");
                logger.debug("build cmd: '" + testBuilder.toString() + "'");
                String cmdName = sideName + "_" + String.format("%s_%03d", sideName, ++idx);
                commands.put(cmdName, cmdBuilder.toString());
            }
        }
        String export = this.activityDef.getParams().getOptionalString(new String[]{"export"}).orElse(null);
        if (export != null) {
            Path exportTo = Path.of(export, new String[0]);
            if (Files.exists(exportTo, new LinkOption[0])) {
                throw new BasicError("File exists: " + exportTo + ", remove it first.");
            }
            try {
                StringBuilder stmts = new StringBuilder();
                stmts.append("statements:\n");
                commands.forEach((name, cmd) -> {
                    System.out.println("name: " + name);
                    System.out.println("cmd: " + cmd);
                    stmts.append("  - ").append((String)name).append(": ").append((String)cmd);
                });
                Files.writeString(exportTo, (CharSequence)stmts.toString(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.info("completed importing from " + sideFile + " to " + exportTo);
            System.exit(0);
        }
        SequencerType sequencerType = this.getParams().getOptionalString(new String[]{"seq"}).map(SequencerType::valueOf).orElse(SequencerType.bucket);
        SequencePlanner planner = new SequencePlanner(sequencerType);
        commands.forEach((name, cmd) -> {
            CommandTemplate commandTemplate = new CommandTemplate((String)cmd, Map.of(), (String)name);
            planner.addOp((Object)commandTemplate, c -> 1L);
        });
        OpSequence sequence = planner.resolve();
        return sequence;
    }

    private OpSequence<CommandTemplate> initOpSequenceFromYaml() {
        StrInterpolator interp = new StrInterpolator(new ActivityDef[]{this.activityDef});
        String yaml_loc = this.activityDef.getParams().getOptionalString(new String[]{"yaml", "workload"}).orElse("default");
        StmtsDocList stmtsDocList = StatementsLoader.load((Logger)logger, (String)yaml_loc, (Function)interp, (String[])new String[]{"activities"});
        SequencerType sequencerType = this.getParams().getOptionalString(new String[]{"seq"}).map(SequencerType::valueOf).orElse(SequencerType.bucket);
        SequencePlanner planner = new SequencePlanner(sequencerType);
        String tagfilter = this.activityDef.getParams().getOptionalString(new String[]{"tags"}).orElse("");
        List stmts = stmtsDocList.getStmts(tagfilter);
        if (stmts.size() == 0) {
            throw new BasicError("There were no active statements with tag filter '" + tagfilter + "'");
        }
        for (StmtDef optemplate : stmts) {
            long ratio = Long.parseLong(optemplate.getParams().getOrDefault("ratio", "1"));
            CommandTemplate cmd = new CommandTemplate(optemplate);
            planner.addOp((Object)cmd, ratio);
        }
        return planner.resolve();
    }

    public OpSequence<CommandTemplate> getOpSequence() {
        return this.opSequence;
    }

    public synchronized WebContext getWebContext(int slot) {
        try {
            WebContext context = this.contexts.get(slot);
            if (context == null) {
                logger.info("initializing chromedriver for thread " + slot);
                System.setProperty("webdriver.http.factory", "okhttp");
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setHeadless(this.activityDef.getParams().getOptionalBoolean("headless").orElse(false).booleanValue());
                ChromeDriver webdriver = new ChromeDriver(chromeOptions);
                context = new WebContext((WebDriver)webdriver);
                this.contexts.put(slot, context);
            } else {
                logger.info("using cached chromedriver for thread " + slot);
            }
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdownActivity() {
        this.contexts.forEach((s, d) -> {
            logger.debug("closing driver for thread " + s);
            d.driver().close();
        });
    }
}

