/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class WebContext {
    private static final Logger logger = LogManager.getLogger(WebContext.class);
    private final WebDriver rootwindow;
    WebDriver focus;
    LinkedList<WebElement> elements = new LinkedList();
    private final LinkedList<Cookie> cookies = new LinkedList();
    private final HashMap<String, Object> vars = new HashMap();
    private Alert alert;

    public WebContext(WebDriver initial) {
        this.focus = initial;
        this.rootwindow = initial;
    }

    public void pushElement(WebElement element) {
        this.elements.push(element);
    }

    public WebElement peekElement() {
        return this.elements.peek();
    }

    public LinkedList<Cookie> getCookies() {
        return this.cookies;
    }

    public LinkedList<WebElement> getElements() {
        return this.elements;
    }

    public void setElements(List<WebElement> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
    }

    public void pushCookie(Cookie cookie) {
        this.cookies.push(cookie);
    }

    public void setCookies(Collection<Cookie> cookies) {
        this.cookies.clear();
        this.cookies.addAll(cookies);
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public WebDriver driver() {
        return this.focus;
    }

    public void setFocus(WebDriver driver) {
        this.focus = driver;
    }

    public void clearAlert() {
        this.alert = null;
    }

    public void setVar(String key, Object value) {
        this.vars.put(key, value);
        logger.debug("context vars: '" + key + "'='" + value.toString() + "'");
    }

    public <T> T getVar(String name, Class<? extends T> type) {
        Object o = this.vars.get(name);
        if (o == null) {
            return null;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return type.cast(o);
        }
        throw new RuntimeException("Could not cast named var '" + name + "' to a " + type.getCanonicalName());
    }
}

