/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.driver.webdriver;

import io.nosqlbench.driver.webdriver.WebContext;
import io.nosqlbench.driver.webdriver.WebDriverActivity;
import io.nosqlbench.driver.webdriver.verbs.WebDriverVerbs;
import io.nosqlbench.engine.api.activityapi.core.ActivityDefObserver;
import io.nosqlbench.engine.api.activityapi.core.SyncAction;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.templating.CommandTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebDriverAction
implements SyncAction,
ActivityDefObserver {
    private static final Logger logger = LogManager.getLogger(WebDriverAction.class);
    private final WebDriverActivity activity;
    private final int slot;
    private String errors;
    private boolean dryrun;
    private WebContext context;

    public WebDriverAction(WebDriverActivity activity, int slot) {
        this.activity = activity;
        this.slot = slot;
    }

    public void init() {
        this.onActivityDefUpdate(this.activity.getActivityDef());
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.errors = activityDef.getParams().getOptionalString(new String[]{"errors"}).orElse("stop");
        this.dryrun = activityDef.getParams().getOptionalBoolean("dryrun").orElse(false);
        this.context = this.activity.getWebContext(this.slot);
    }

    public int runCycle(long cycle) {
        CommandTemplate commandTemplate = (CommandTemplate)this.activity.getOpSequence().get(cycle);
        try {
            WebDriverVerbs.execute(cycle, commandTemplate, this.context, this.dryrun);
            return 0;
        }
        catch (Exception e) {
            logger.error("Error with cycle(" + cycle + "), statement(" + commandTemplate.getName() + "): " + e.getMessage());
            if (this.errors.equals("stop")) {
                throw e;
            }
            return 1;
        }
    }
}

