/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.docsys.core.NBWebServerApp;
import io.nosqlbench.engine.api.activityapi.core.ActivityType;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogDumperUtility;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogImporterUtility;
import io.nosqlbench.engine.api.activityapi.input.InputType;
import io.nosqlbench.engine.api.activityapi.output.OutputType;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.cli.BasicScriptBuffer;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.NBCLIOptions;
import io.nosqlbench.engine.cli.NBCLIScenarios;
import io.nosqlbench.engine.cli.NBCLIScripts;
import io.nosqlbench.engine.cli.ScriptBuffer;
import io.nosqlbench.engine.cli.SessionNamer;
import io.nosqlbench.engine.cli.VersionInfo;
import io.nosqlbench.engine.core.annotation.Annotators;
import io.nosqlbench.engine.core.lifecycle.ScenarioErrorHandler;
import io.nosqlbench.engine.core.lifecycle.ScenariosResults;
import io.nosqlbench.engine.core.lifecycle.ShutdownManager;
import io.nosqlbench.engine.core.logging.LoggerConfig;
import io.nosqlbench.engine.core.metadata.MarkdownDocInfo;
import io.nosqlbench.engine.core.metrics.MetricReporters;
import io.nosqlbench.engine.core.script.MetricsMapper;
import io.nosqlbench.engine.core.script.Scenario;
import io.nosqlbench.engine.core.script.ScenariosExecutor;
import io.nosqlbench.engine.core.script.ScriptParams;
import io.nosqlbench.engine.docker.DockerMetricsManager;
import io.nosqlbench.nb.api.SystemId;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Layer;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.logging.NBLogLevel;
import io.nosqlbench.nb.api.markdown.exporter.MarkdownExporter;
import io.nosqlbench.virtdata.userlibs.apps.VirtDataMainApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.LockSupport;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;

public class NBCLI {
    private static Logger logger;
    private static LoggerConfig loggerConfig;
    private final String commandName;

    public NBCLI(String commandName) {
        this.commandName = commandName;
    }

    public static void main(String[] args) {
        try {
            NBCLI cli = new NBCLI("eb");
            cli.run(args);
        }
        catch (Exception e) {
            String error = ScenarioErrorHandler.handle((Throwable)e, (boolean)true);
            if (error != null) {
                System.err.println(error);
            }
            System.err.flush();
            System.out.flush();
            System.exit(2);
        }
    }

    public void run(String[] args) {
        Optional pendingResult;
        loggerConfig.setConsoleLevel(NBLogLevel.ERROR);
        NBCLIOptions globalOptions = new NBCLIOptions(args, NBCLIOptions.Mode.ParseGlobalsOnly);
        String sessionName = new SessionNamer().format(globalOptions.getSessionName());
        loggerConfig.setSessionName(sessionName).setConsoleLevel(globalOptions.getConsoleLogLevel()).setConsolePattern(globalOptions.getConsoleLoggingPattern()).setLogfileLevel(globalOptions.getScenarioLogLevel()).getLoggerLevelOverrides(globalOptions.getLogLevelOverrides()).setMaxLogs(globalOptions.getLogsMax()).setLogsDirectory(globalOptions.getLogsDirectory()).activate();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)loggerConfig);
        logger = LogManager.getLogger((String)"NBCLI");
        loggerConfig.purgeOldFiles(LogManager.getLogger((String)"SCENARIO"));
        logger.info("Configured scenario log at " + loggerConfig.getLogfileLocation());
        logger.debug("Scenario log started");
        if (args.length == 0) {
            System.out.println(this.loadHelpFile("commandline.md"));
            System.exit(0);
        }
        logger.info("Running NoSQLBench Version " + new VersionInfo().getVersion());
        logger.info("command-line: " + Arrays.stream(args).collect(Collectors.joining(" ")));
        logger.info("client-hardware: " + SystemId.getHostSummary());
        boolean dockerMetrics = globalOptions.wantsDockerMetrics();
        String dockerMetricsAt = globalOptions.wantsDockerMetricsAt();
        Object reportGraphiteTo = globalOptions.wantsReportGraphiteTo();
        Object annotatorsConfig = globalOptions.getAnnotatorsConfig();
        int mOpts = (dockerMetrics ? 1 : 0) + (dockerMetricsAt != null ? 1 : 0) + (reportGraphiteTo != null ? 1 : 0);
        if (mOpts > 1 && (reportGraphiteTo == null || annotatorsConfig == null)) {
            throw new BasicError("You have multiple conflicting options which attempt to set\n the destination for metrics and annotations. Please select only one of\n --docker-metrics, --docker-metrics-at <addr>, or other options like \n --report-graphite-to <addr> and --annotators <config>\n For more details, see run 'nb help docker-metrics'");
        }
        String metricsAddr = null;
        if (dockerMetrics) {
            logger.info("Docker metrics is enabled. Docker must be installed for this to work");
            DockerMetricsManager dmh = new DockerMetricsManager();
            Map<String, String> dashboardOptions = Map.of("grafana_tag", globalOptions.getDockerGrafanaTag(), "prom_tag", globalOptions.getDockerPromTag(), "tsdb_days", String.valueOf(globalOptions.getDockerPromRetentionDays()));
            dmh.startMetrics(dashboardOptions);
            String warn = "Docker Containers are started, for grafana and prometheus, hit these urls in your browser: http://<host>:3000 and http://<host>:9090";
            logger.warn(warn);
            metricsAddr = "localhost";
        } else if (dockerMetricsAt != null) {
            metricsAddr = dockerMetricsAt;
        }
        if (metricsAddr != null) {
            reportGraphiteTo = metricsAddr + ":9109";
            annotatorsConfig = "[{type:'log',level:'info'},{type:'grafana',baseurl:'http://" + metricsAddr + ":3000/',tags:'appname:nosqlbench',timeoutms:5000,onerror:'warn'}]";
        } else {
            annotatorsConfig = "[{type:'log',level:'info'}]";
        }
        if (args.length > 0 && args[0].toLowerCase().equals("virtdata")) {
            VirtDataMainApp.main((String[])Arrays.copyOfRange(args, 1, args.length));
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().matches("docserver|appserver")) {
            NBWebServerApp.main((String[])Arrays.copyOfRange(args, 1, args.length));
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().equals("exporter")) {
            MarkdownExporter.main((String[])Arrays.copyOfRange(args, 1, args.length));
            System.exit(0);
        }
        NBCLIOptions options = new NBCLIOptions(args);
        logger = LogManager.getLogger((String)"NBCLI");
        NBIO.addGlobalIncludes((String[])options.wantsIncludes());
        ActivityMetrics.setHdrDigits((int)options.getHdrDigits());
        if (options.wantsBasicHelp()) {
            System.out.println(this.loadHelpFile("basic.md"));
            System.exit(0);
        }
        if (options.isWantsVersionShort()) {
            System.out.println(new VersionInfo().getVersion());
            System.exit(0);
        }
        if (options.wantsVersionCoords()) {
            System.out.println(new VersionInfo().getArtifactCoordinates());
            System.exit(0);
        }
        if (options.wantsActivityTypes()) {
            ActivityType.FINDER.getAllSelectors(new Pattern[0]).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsWorkloadsList()) {
            NBCLIScenarios.printWorkloads(false, options.wantsIncludes());
            System.exit(0);
        }
        if (options.wantsScenariosList()) {
            NBCLIScenarios.printWorkloads(true, options.wantsIncludes());
            System.exit(0);
        }
        if (options.wantsScriptList()) {
            NBCLIScripts.printScripts(true, options.wantsIncludes());
            System.exit(0);
        }
        if (options.wantsToCopyResource()) {
            Content data;
            Path writeTo;
            String resourceToCopy = options.wantsToCopyResourceNamed();
            logger.debug("user requests to copy out " + resourceToCopy);
            Optional tocopy = NBIO.classpath().prefix(new String[]{"activities"}).prefix(options.wantsIncludes()).name(new String[]{resourceToCopy}).extension(new String[]{"yaml"}).first();
            if (tocopy.isEmpty()) {
                tocopy = NBIO.classpath().prefix(new String[0]).prefix(options.wantsIncludes()).prefix(options.wantsIncludes()).name(new String[]{resourceToCopy}).first();
            }
            if (Files.exists(writeTo = Path.of((data = (Content)tocopy.orElseThrow(() -> new BasicError("Unable to find " + resourceToCopy + " in classpath to copy out"))).asPath().getFileName().toString(), new String[0]), new LinkOption[0])) {
                throw new BasicError("A file named " + writeTo.toString() + " exists. Remove it first.");
            }
            try {
                Files.writeString(writeTo, (CharSequence)data.getCharBuffer(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BasicError("Unable to write to " + writeTo.toString() + ": " + e.getMessage());
            }
            logger.info("Copied internal resource '" + data.asPath() + "' to '" + writeTo.toString() + "'");
            System.exit(0);
        }
        if (options.wantsInputTypes()) {
            InputType.FINDER.getAllSelectors(new Pattern[0]).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsMarkerTypes()) {
            OutputType.FINDER.getAllSelectors(new Pattern[0]).forEach(System.out::println);
            System.exit(0);
        }
        if (options.wantsToDumpCyclelog()) {
            CycleLogDumperUtility.main((String[])options.getCycleLogExporterOptions());
            System.exit(0);
        }
        if (options.wantsToImportCycleLog()) {
            CycleLogImporterUtility.main((String[])options.getCyclelogImportOptions());
            System.exit(0);
        }
        if (options.wantsTopicalHelp()) {
            Optional helpDoc = MarkdownDocInfo.forHelpTopic((String)options.wantsTopicalHelpFor());
            System.out.println((String)helpDoc.orElseThrow(() -> new RuntimeException("No help could be found for " + options.wantsTopicalHelpFor())));
            System.exit(0);
        }
        if (options.wantsMetricsForActivity() != null) {
            String metricsHelp = this.getMetricsHelpFor(options.wantsMetricsForActivity());
            System.out.println("Available metric names for activity:" + options.wantsMetricsForActivity() + ":");
            System.out.println(metricsHelp);
            System.exit(0);
        }
        logger.debug("initializing annotators with config:'" + (String)annotatorsConfig + "'");
        Annotators.init((String)annotatorsConfig);
        Annotators.recordAnnotation((Annotation)Annotation.newBuilder().session(sessionName).now().layer(Layer.CLI).detail("cli", Strings.join((String[])args, (String)"\n")).build());
        if (reportGraphiteTo != null || options.wantsReportCsvTo() != null) {
            MetricReporters reporters = MetricReporters.getInstance();
            reporters.addRegistry("workloads", ActivityMetrics.getMetricRegistry());
            if (reportGraphiteTo != null) {
                reporters.addGraphite((String)reportGraphiteTo, options.wantsMetricsPrefix());
            }
            if (options.wantsReportCsvTo() != null) {
                reporters.addCSVReporter(options.wantsReportCsvTo(), options.wantsMetricsPrefix());
            }
            reporters.start(10, options.getReportInterval());
        }
        if (options.wantsEnableChart()) {
            logger.info("Charting enabled");
            if (options.getHistoLoggerConfigs().size() == 0) {
                logger.info("Adding default histologger configs");
                Iterator<NBCLIOptions.LoggerConfigData> pattern = ".*";
                String file = options.getChartHdrFileName();
                String interval = "1s";
                options.setHistoLoggerConfigs((String)((Object)pattern), file, interval);
            }
        }
        for (NBCLIOptions.LoggerConfigData histoLogger : options.getHistoLoggerConfigs()) {
            ActivityMetrics.addHistoLogger((String)sessionName, (String)histoLogger.pattern, (String)histoLogger.file, (String)histoLogger.interval);
        }
        for (NBCLIOptions.LoggerConfigData statsLogger : options.getStatsLoggerConfigs()) {
            ActivityMetrics.addStatsLogger((String)sessionName, (String)statsLogger.pattern, (String)statsLogger.file, (String)statsLogger.interval);
        }
        for (NBCLIOptions.LoggerConfigData classicConfigs : options.getClassicHistoConfigs()) {
            ActivityMetrics.addClassicHistos((String)sessionName, (String)classicConfigs.pattern, (String)classicConfigs.file, (String)classicConfigs.interval);
        }
        logger.info("console logging level is " + options.getConsoleLogLevel());
        ScenariosExecutor executor = new ScenariosExecutor("executor-" + sessionName, 1);
        Scenario scenario = new Scenario(sessionName, options.getScriptFile(), options.getScriptingEngine(), options.getProgressSpec(), options.wantsGraaljsCompatMode(), options.wantsStackTraces(), options.wantsCompileScript(), options.getReportSummaryTo(), String.join((CharSequence)"\n", args), options.getLogsDirectory());
        ScriptBuffer buffer = new BasicScriptBuffer().add(options.getCommands().toArray(new Cmd[0]));
        String scriptData = buffer.getParsedScript();
        if (options.wantsShowScript()) {
            System.out.println("// Rendered Script");
            System.out.println(scriptData);
            System.exit(0);
        }
        if (options.wantsEnableChart()) {
            logger.info("Charting enabled");
            scenario.enableCharting();
        } else {
            logger.info("Charting disabled");
        }
        if (options.getCommands().size() == 0) {
            logger.info("No commands provided. Exiting before scenario.");
            System.exit(0);
        }
        scenario.addScriptText(scriptData);
        ScriptParams scriptParams = new ScriptParams();
        scriptParams.putAll(buffer.getCombinedParams());
        scenario.addScenarioScriptParams(scriptParams);
        executor.execute(scenario);
        while ((pendingResult = executor.getPendingResult(scenario.getScenarioName())).isEmpty()) {
            LockSupport.parkNanos(100000000L);
        }
        ScenariosResults scenariosResults = executor.awaitAllResults();
        ActivityMetrics.closeMetrics((boolean)options.wantsEnableChart());
        ShutdownManager.shutdown();
        if (scenariosResults.hasError()) {
            Exception exception = (Exception)scenariosResults.getOne().getException().get();
            ScenarioErrorHandler.handle((Throwable)exception, (boolean)options.wantsStackTraces());
            System.err.println(exception.getMessage());
            System.exit(2);
        } else {
            logger.info(scenariosResults.getExecutionSummary());
            System.exit(0);
        }
    }

    private String loadHelpFile(String filename) {
        String basicHelp;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream resourceAsStream = cl.getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new RuntimeException("Unable to find " + filename + " in classpath.");
        }
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(resourceAsStream));){
            basicHelp = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer " + filename + ": " + t);
        }
        basicHelp = basicHelp.replaceAll("PROG", this.commandName);
        return basicHelp;
    }

    private String getMetricsHelpFor(String activityType) {
        String metrics = MetricsMapper.metricsDetail((String)activityType);
        return metrics;
    }

    static {
        loggerConfig = new LoggerConfig();
        LoggerConfig.setConfigurationFactory((ConfigurationFactory)loggerConfig);
    }
}

