/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.nb.api.NBEnvironment;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.internal.Strings;
import org.apache.logging.log4j.Logger;

public class NBCLIArgsFile {
    private Logger logger;
    public static final String ARGS_FILE = "--argsfile";
    public static final String ARGS_FILE_OPTIONAL = "--argsfile-optional";
    public static final String ARGS_FILE_REQUIRED = "--argsfile-required";
    public static final String ARGS_PIN = "--pin";
    public static final String ARGS_UNPIN = "--unpin";
    private Path argsPath;
    private LinkedList<String> preload;
    private final Set<String> stopWords = new HashSet<String>();
    private final LinkedHashSet<String> args = new LinkedHashSet();
    LinkedHashSet<String> argsToPin = new LinkedHashSet();
    LinkedHashSet<String> argsToUnpin = new LinkedHashSet();
    private final Set<String> readPaths = new HashSet<String>();

    public NBCLIArgsFile preload(String ... preload) {
        this.preload = new LinkedList<String>(Arrays.asList(preload));
        return this;
    }

    public NBCLIArgsFile reserved(Collection<String> reservedWords) {
        this.stopWords.addAll(reservedWords);
        return this;
    }

    public NBCLIArgsFile reserved(String ... reservedWords) {
        this.stopWords.addAll(Arrays.asList(reservedWords));
        return this;
    }

    public LinkedList<String> process(String ... args) {
        return this.process(new LinkedList<String>(Arrays.asList(args)));
    }

    public LinkedList<String> process(LinkedList<String> commandline) {
        if (this.preload != null) {
            LinkedList<String> modified = new LinkedList<String>();
            modified.addAll(this.preload);
            modified.addAll(commandline);
            this.preload = null;
            commandline = modified;
        }
        LinkedList<String> composed = new LinkedList<String>();
        block14: while (commandline.peekFirst() != null) {
            String arg;
            switch (arg = commandline.peekFirst()) {
                case "--argsfile": {
                    this.pinAndUnpin();
                    commandline.removeFirst();
                    String argspath = this.readWordOrThrow(commandline, "path to an args file");
                    this.setArgsFile(argspath, Selection.WarnIfMissing);
                    commandline = this.mergeArgs(this.argsPath, Selection.WarnIfMissing, commandline);
                    continue block14;
                }
                case "--argsfile-required": {
                    commandline.removeFirst();
                    String argspathRequired = this.readWordOrThrow(commandline, "path to an args file");
                    this.setArgsFile(argspathRequired, Selection.ErrorIfMissing);
                    commandline = this.mergeArgs(this.argsPath, Selection.ErrorIfMissing, commandline);
                    continue block14;
                }
                case "--argsfile-optional": {
                    commandline.removeFirst();
                    String argspathOptional = this.readWordOrThrow(commandline, "path to an args file");
                    this.setArgsFile(argspathOptional, Selection.IgnoreIfMissing);
                    commandline = this.mergeArgs(this.argsPath, Selection.IgnoreIfMissing, commandline);
                    continue block14;
                }
                case "--pin": {
                    commandline.removeFirst();
                    this.argsToPin.addAll(this.argsToLines(this.readOptionAndArg(commandline, false)));
                    continue block14;
                }
                case "--unpin": {
                    commandline.removeFirst();
                    this.argsToUnpin.addAll(this.argsToLines(this.readOptionAndArg(commandline, true)));
                    continue block14;
                }
            }
            composed.addLast(commandline.removeFirst());
        }
        this.pinAndUnpin();
        return composed;
    }

    private void pinAndUnpin() {
        LinkedHashSet<String> mergedPins;
        if (this.argsToUnpin.size() == 0 && this.argsToPin.size() == 0) {
            return;
        }
        LinkedHashSet<String> extant = this.readArgsFile(this.argsPath, Selection.IgnoreIfMissing);
        if (extant.equals(mergedPins = this.mergePins(this.argsToPin, this.argsToUnpin, extant))) {
            if (this.logger != null) {
                this.logger.info("Pinning resulted in no changes to argsfile '" + this.argsPath.toString() + "'");
            }
        } else {
            if (this.logger != null) {
                this.logger.info("Writing updated argsfile '" + this.argsPath.toString() + "' with " + (this.argsToPin.size() + this.argsToUnpin.size()) + " changes");
            }
            this.writeArgsFile(mergedPins);
        }
        this.argsToPin.clear();
        this.argsToUnpin.clear();
    }

    private LinkedHashSet<String> mergePins(LinkedHashSet<String> toPin, LinkedHashSet<String> toUnpin, LinkedHashSet<String> extant) {
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        merged.addAll(extant);
        for (String arg : toPin) {
            if (!this.argsToUnpin.contains(arg)) continue;
            throw new RuntimeException("You have both --pin and --unpin for '" + arg + ", I don't know which one you want.");
        }
        for (String arg : toUnpin) {
            if (!this.argsToPin.contains(arg)) continue;
            throw new RuntimeException("You have both --pin and --unpin for '" + arg + ", I don't know which one you want.");
        }
        for (String toAdd : toPin) {
            if (merged.contains(toAdd)) {
                if (this.logger == null) continue;
                this.logger.warn("Requested to pin argument again: '" + toAdd + "', ignoring");
                continue;
            }
            if (this.logger != null) {
                this.logger.info("Pinning option '" + toAdd + "' to '" + this.argsPath.toString() + "'");
            }
            merged.add(toAdd);
        }
        for (String toDel : toUnpin) {
            if (merged.contains(toDel)) {
                if (this.logger != null) {
                    this.logger.info("Unpinning '" + toDel + "' from '" + this.argsPath.toString() + "'");
                }
                merged.remove(toDel);
                continue;
            }
            if (this.logger == null) continue;
            this.logger.warn("Requested to unpin argument '" + toDel + "' which was not found in " + this.argsPath.toString());
        }
        return merged;
    }

    LinkedList<String> mergeArgs(Path argspath, Selection mode, LinkedList<String> commandline) {
        this.args.clear();
        if (this.readPaths.contains(this.argsPath.toString())) {
            throw new BasicError("Recursive reading of argsfile is detected for '" + argspath.toString() + "'.\nPlease ensure that you do not have cyclic references in your arguments for argsfiles.");
        }
        LinkedHashSet<String> loaded = this.readArgsFile(argspath, mode);
        this.readPaths.add(this.argsPath.toString());
        List<String> interpolated = loaded.stream().map(p -> {
            String q = NBEnvironment.INSTANCE.interpolate(p).orElse(p);
            if (!q.equals(p) && this.logger != null) {
                this.logger.info("argsfile: '" + this.argsPath.toString() + "': loaded option '" + p + "' as '" + q + "'");
            }
            return q;
        }).collect(Collectors.toList());
        LinkedList<String> inArgvForm = this.linesToArgs(interpolated);
        this.args.addAll(inArgvForm);
        return this.concat(inArgvForm, commandline);
    }

    private LinkedList<String> concat(Collection<String> ... entries) {
        LinkedList<String> composed = new LinkedList<String>();
        for (Collection<String> list : entries) {
            composed.addAll(list);
        }
        return composed;
    }

    private LinkedHashSet<String> readArgsFile(Path argspath, Selection mode) {
        LinkedHashSet<String> args = new LinkedHashSet<String>();
        if (!this.assertArgsFileExists(argspath, mode)) {
            return args;
        }
        List<String> lines = null;
        try {
            lines = Files.readAllLines(argspath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List content = lines.stream().filter(s -> !s.startsWith("#")).filter(s -> !s.startsWith("/")).filter(s -> !s.isBlank()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        StringBuilder splitword = new StringBuilder();
        LinkedHashSet<String> loaded = new LinkedHashSet<String>();
        for (String s2 : content) {
            splitword.append(s2);
            if (!s2.endsWith("\\")) {
                loaded.add(splitword.toString());
                splitword.setLength(0);
                continue;
            }
            splitword.setLength(splitword.length() - 1);
        }
        if (splitword.length() > 0) {
            throw new RuntimeException("unqualified line continuation for '" + splitword.toString() + "'");
        }
        return loaded;
    }

    private void writeArgsFile(LinkedHashSet<String> args) {
        if (this.argsPath == null) {
            throw new RuntimeException("No argsfile has been selected before using the pin option.");
        }
        try {
            Files.createDirectories(this.argsPath.getParent(), PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwx---")));
            Files.write(this.argsPath, args, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new BasicError("unable to write '" + this.argsPath + "': " + e.getMessage());
        }
    }

    private boolean assertArgsFileExists(Path argspath, Selection mode) {
        if (!Files.exists(this.argsPath, new LinkOption[0])) {
            switch (mode) {
                case ErrorIfMissing: {
                    throw new RuntimeException("A required argsfile was specified, but it does not exist: '" + argspath + "'");
                }
                case WarnIfMissing: {
                    if (this.logger == null) break;
                    this.logger.warn("An argsfile was specified, but it does not exist: '" + argspath + "'");
                }
            }
            return false;
        }
        return true;
    }

    private void setArgsFile(String argspath, Selection mode) {
        String[] possibles;
        Path selected = null;
        for (String possible : possibles = argspath.split(":")) {
            Path possiblePath;
            Optional expanded = NBEnvironment.INSTANCE.interpolate(possible);
            if (!expanded.isPresent() || !Files.exists(possiblePath = Path.of((String)expanded.get(), new String[0]), new LinkOption[0])) continue;
            selected = possiblePath;
            break;
        }
        if (selected == null) {
            String defaultFirst = possibles[0];
            defaultFirst = (String)NBEnvironment.INSTANCE.interpolate(defaultFirst).orElseThrow(() -> new RuntimeException("Invalid default argsfile: '" + possibles[0] + "'"));
            selected = Path.of(defaultFirst, new String[0]);
        }
        this.argsPath = selected;
        if (this.logger != null) {
            this.logger.debug("argsfile path is now '" + this.argsPath.toString() + "'");
        }
    }

    LinkedHashSet<String> argsToLines(List<String> args) {
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        Iterator<String> iter = args.iterator();
        ArrayList<String> element = new ArrayList<String>();
        while (iter.hasNext()) {
            String word = iter.next();
            if (word.startsWith("-") && element.size() > 0) {
                lines.add(Strings.join(element, (String)" "));
                element.clear();
            }
            element.add(word);
        }
        lines.add(Strings.join(element, (String)" "));
        return lines;
    }

    LinkedList<String> linesToArgs(Collection<String> lines) {
        LinkedList<String> args = new LinkedList<String>();
        for (String line : lines) {
            if (line.startsWith("-")) {
                String[] words = line.split(" ", 2);
                args.addAll(Arrays.asList(words));
                continue;
            }
            args.add(line);
        }
        return args;
    }

    private LinkedList<String> unpin(LinkedList<String> arglist) {
        if (this.argsPath == null) {
            throw new RuntimeException("No argsfile has been selected before using the pin option.");
        }
        return arglist;
    }

    private LinkedList<String> readOptionAndArg(LinkedList<String> arglist, boolean consume) {
        LinkedList<String> option = new LinkedList<String>();
        ListIterator iter = arglist.listIterator();
        if (!iter.hasNext()) {
            throw new RuntimeException("Arguments must follow the --pin option");
        }
        String opt = (String)iter.next();
        if (!opt.startsWith("-") || this.stopWords.contains(opt)) {
            throw new RuntimeException("Arguments following the --pin option must not be commands like '" + opt + "'");
        }
        option.add(opt);
        if (consume) {
            iter.remove();
        }
        if (iter.hasNext() && !this.stopWords.contains(opt = (String)iter.next()) && !opt.startsWith("-")) {
            option.add(opt);
            if (consume) {
                iter.remove();
            }
        }
        return option;
    }

    private String readWordOrThrow(LinkedList<String> commandline, String description) {
        String found = commandline.peekFirst();
        if (found == null) {
            throw new RuntimeException("Unable to read argument top option for " + description);
        }
        return commandline.removeFirst();
    }

    private static enum Selection {
        IgnoreIfMissing,
        WarnIfMissing,
        ErrorIfMissing;

    }
}

