/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.engine.api.metrics.IndicatorMode;
import io.nosqlbench.engine.api.util.Unit;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.NBCLIArgsFile;
import io.nosqlbench.engine.cli.NBCLICommandParser;
import io.nosqlbench.engine.cli.PathCanonicalizer;
import io.nosqlbench.engine.core.script.Scenario;
import io.nosqlbench.nb.api.NBEnvironment;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.logging.NBLogLevel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NBCLIOptions {
    private static final String NB_STATE_DIR = "--statedir";
    private static final String NB_STATEDIR_PATHS = "$NBSTATEDIR:$PWD/.nosqlbench:$HOME/.nosqlbench";
    public static final String ARGS_FILE_DEFAULT = "$NBSTATEDIR/argsfile";
    private static final String INCLUDE = "--include";
    private static final String userHome = System.getProperty("user.home");
    private static final String METRICS_PREFIX = "--metrics-prefix";
    private static final String ANNOTATE_EVENTS = "--annotate";
    private static final String ANNOTATORS_CONFIG = "--annotators";
    private static final String DEFAULT_ANNOTATORS = "all";
    private static final String DEFAULT_CHART_HDR_LOG_NAME = "hdrdata-for-chart.log";
    private static final String HELP = "--help";
    private static final String LIST_METRICS = "--list-metrics";
    private static final String LIST_DRIVERS = "--list-drivers";
    private static final String LIST_ACTIVITY_TYPES = "--list-activity-types";
    private static final String LIST_SCRIPTS = "--list-scripts";
    private static final String LIST_WORKLOADS = "--list-workloads";
    private static final String LIST_SCENARIOS = "--list-scenarios";
    private static final String LIST_INPUT_TYPES = "--list-input-types";
    private static final String LIST_OUTPUT_TYPES = "--list-output-types";
    private static final String VERSION_COORDS = "--version-coords";
    private static final String VERSION = "--version";
    private static final String SHOW_SCRIPT = "--show-script";
    private static final String COMPILE_SCRIPT = "--compile-script";
    private static final String SCRIPT_FILE = "--script-file";
    private static final String COPY = "--copy";
    private static final String SHOW_STACKTRACES = "--show-stacktraces";
    private static final String EXPORT_CYCLE_LOG = "--export-cycle-log";
    private static final String IMPORT_CYCLE_LOG = "--import-cycle-log";
    private static final String HDR_DIGITS = "--hdr-digits";
    private static final String SESSION_NAME = "--session-name";
    private static final String LOGS_DIR = "--logs-dir";
    private static final String WORKSPACES_DIR = "--workspaces-dir";
    private static final String LOGS_MAX = "--logs-max";
    private static final String LOGS_LEVEL = "--logs-level";
    private static final String DASH_V_INFO = "-v";
    private static final String DASH_VV_DEBUG = "-vv";
    private static final String DASH_VVV_TRACE = "-vvv";
    private static final String REPORT_INTERVAL = "--report-interval";
    private static final String REPORT_GRAPHITE_TO = "--report-graphite-to";
    private static final String REPORT_CSV_TO = "--report-csv-to";
    private static final String REPORT_SUMMARY_TO = "--report-summary-to";
    private static final String REPORT_SUMMARY_TO_DEFAULT = "stdout:60,_LOGS_/_SESSION_.summary";
    private static final String PROGRESS = "--progress";
    private static final String WITH_LOGGING_PATTERN = "--with-logging-pattern";
    private static final String LOG_HISTOGRAMS = "--log-histograms";
    private static final String LOG_HISTOSTATS = "--log-histostats";
    private static final String CLASSIC_HISTOGRAMS = "--classic-histograms";
    private static final String LOG_LEVEL_OVERRIDE = "--log-level-override";
    private static final String ENABLE_CHART = "--enable-chart";
    private static final String DOCKER_METRICS = "--docker-metrics";
    private static final String DOCKER_METRICS_AT = "--docker-metrics-at";
    private static final String DOCKER_GRAFANA_TAG = "--docker-grafana-tag";
    private static final String DOCKER_PROM_TAG = "--docker-prom-tag";
    private static final String DOCKER_PROM_RETENTION_DAYS = "--docker-prom-retention-days";
    private static final String GRAALJS_ENGINE = "--graaljs";
    private static final String NASHORN_ENGINE = "--nashorn";
    private static final String GRAALJS_COMPAT = "--graaljs-compat";
    private static final String DEFAULT_CONSOLE_LOGGING_PATTERN = "%7r %-5level [%t] %-12logger{0} %msg%n%throwable";
    public static final String NBSTATEDIR = "NBSTATEDIR";
    private final LinkedList<Cmd> cmdList = new LinkedList();
    private int logsMax = 0;
    private boolean wantsVersionShort = false;
    private boolean wantsVersionCoords = false;
    private boolean wantsActivityHelp = false;
    private String wantsActivityHelpFor;
    private boolean wantsActivityTypes = false;
    private boolean wantsBasicHelp = false;
    private String reportGraphiteTo = null;
    private String reportCsvTo = null;
    private int reportInterval = 10;
    private String metricsPrefix = "nosqlbench";
    private String wantsMetricsForActivity;
    private String sessionName = "";
    private boolean showScript = false;
    private NBLogLevel consoleLevel = NBLogLevel.WARN;
    private final List<String> histoLoggerConfigs = new ArrayList<String>();
    private final List<String> statsLoggerConfigs = new ArrayList<String>();
    private final List<String> classicHistoConfigs = new ArrayList<String>();
    private String progressSpec = "console:1m";
    private String logsDirectory = "logs";
    private String workspacesDirectory = "workspaces";
    private boolean wantsInputTypes = false;
    private boolean wantsMarkerTypes = false;
    private String[] rleDumpOptions = new String[0];
    private String[] cyclelogImportOptions = new String[0];
    private String consoleLoggingPattern = "%7r %-5level [%t] %-12logger{0} %msg%n%throwable";
    private NBLogLevel logsLevel = NBLogLevel.INFO;
    private Map<String, String> logLevelsOverrides = new HashMap<String, String>();
    private boolean enableChart = false;
    private boolean dockerMetrics = false;
    private boolean wantsScenariosList = false;
    private boolean wantsScriptList = false;
    private String wantsToCopyWorkload = null;
    private boolean wantsWorkloadsList = false;
    private final List<String> wantsToIncludePaths = new ArrayList<String>();
    private Scenario.Engine engine = Scenario.Engine.Graalvm;
    private boolean graaljs_compat = false;
    private int hdr_digits = 3;
    private String docker_grafana_tag = "7.3.4";
    private String docker_prom_tag = "latest";
    private boolean showStackTraces = false;
    private boolean compileScript = false;
    private String scriptFile = null;
    private String[] annotateEvents = new String[]{"ALL"};
    private String dockerMetricsHost;
    private String annotatorsConfig = "";
    private String statedirs = "$NBSTATEDIR:$PWD/.nosqlbench:$HOME/.nosqlbench";
    private Path statepath;
    private final List<String> statePathAccesses = new ArrayList<String>();
    private final String hdrForChartFileName = "hdrdata-for-chart.log";
    private String dockerPromRetentionDays = "183d";
    private String reportSummaryTo = "stdout:60,_LOGS_/_SESSION_.summary";

    public String getAnnotatorsConfig() {
        return this.annotatorsConfig;
    }

    public String getChartHdrFileName() {
        return DEFAULT_CHART_HDR_LOG_NAME;
    }

    public String getDockerPromRetentionDays() {
        return this.dockerPromRetentionDays;
    }

    public String getReportSummaryTo() {
        return this.reportSummaryTo;
    }

    public NBCLIOptions(String[] args) {
        this(args, Mode.ParseAllOptions);
    }

    public NBCLIOptions(String[] args, Mode mode) {
        switch (mode) {
            case ParseGlobalsOnly: {
                this.parseGlobalOptions(args);
                break;
            }
            case ParseAllOptions: {
                this.parseAllOptions(args);
            }
        }
    }

    private LinkedList<String> parseGlobalOptions(final String[] args) {
        LinkedList arglist = new LinkedList<String>(){
            {
                this.addAll(Arrays.asList(args));
            }
        };
        if (arglist.peekFirst() == null) {
            this.wantsBasicHelp = true;
            return arglist;
        }
        LinkedList<String> nonincludes = new LinkedList<String>();
        block60: while (arglist.peekFirst() != null) {
            String word = (String)arglist.peekFirst();
            if (word.startsWith("--") && word.contains("=")) {
                String wordToSplit = (String)arglist.removeFirst();
                String[] split = wordToSplit.split("=", 2);
                arglist.offerFirst(split[1]);
                arglist.offerFirst(split[0]);
                continue;
            }
            switch (word) {
                case "--statedir": {
                    arglist.removeFirst();
                    this.statedirs = this.readWordOrThrow(arglist, "nosqlbench global state directory");
                    continue block60;
                }
                case "--include": {
                    arglist.removeFirst();
                    String include = this.readWordOrThrow(arglist, "path to include");
                    this.wantsToIncludePaths.add(include);
                    continue block60;
                }
            }
            nonincludes.addLast((String)arglist.removeFirst());
        }
        this.statedirs = this.statedirs != null ? this.statedirs : NB_STATEDIR_PATHS;
        this.setStatePath();
        arglist = nonincludes;
        nonincludes = new LinkedList();
        NBCLIArgsFile argsfile = new NBCLIArgsFile();
        argsfile.reserved(NBCLICommandParser.RESERVED_WORDS);
        argsfile.preload("--argsfile-optional", ARGS_FILE_DEFAULT);
        arglist = argsfile.process(arglist);
        block61: while (arglist.peekFirst() != null) {
            String word = (String)arglist.peekFirst();
            if (word.startsWith("--") && word.contains("=")) {
                String wordToSplit = (String)arglist.removeFirst();
                String[] split = wordToSplit.split("=", 2);
                arglist.offerFirst(split[1]);
                arglist.offerFirst(split[0]);
                continue;
            }
            switch (word) {
                case "--argsfile": 
                case "--argsfile-optional": 
                case "--argsfile-required": 
                case "--pin": 
                case "--unpin": {
                    if (this.statepath == null) {
                        this.setStatePath();
                    }
                    arglist = argsfile.process(arglist);
                    continue block61;
                }
                case "-v": {
                    this.consoleLevel = NBLogLevel.INFO;
                    arglist.removeFirst();
                    continue block61;
                }
                case "-vv": {
                    this.consoleLevel = NBLogLevel.DEBUG;
                    arglist.removeFirst();
                    continue block61;
                }
                case "-vvv": {
                    this.consoleLevel = NBLogLevel.TRACE;
                    arglist.removeFirst();
                    continue block61;
                }
                case "--annotate": {
                    arglist.removeFirst();
                    String toAnnotate = this.readWordOrThrow(arglist, "annotated events");
                    this.annotateEvents = toAnnotate.split("\\\\s*,\\\\s*");
                    continue block61;
                }
                case "--annotators": {
                    arglist.removeFirst();
                    this.annotatorsConfig = this.readWordOrThrow(arglist, "annotators config");
                    continue block61;
                }
                case "--report-graphite-to": {
                    arglist.removeFirst();
                    this.reportGraphiteTo = (String)arglist.removeFirst();
                    continue block61;
                }
                case "--metrics-prefix": {
                    arglist.removeFirst();
                    this.metricsPrefix = (String)arglist.removeFirst();
                    continue block61;
                }
                case "--workspaces-dir": {
                    arglist.removeFirst();
                    this.workspacesDirectory = this.readWordOrThrow(arglist, "a workspaces directory");
                    continue block61;
                }
                case "--docker-prom-tag": {
                    arglist.removeFirst();
                    this.docker_prom_tag = this.readWordOrThrow(arglist, "prometheus docker tag");
                    continue block61;
                }
                case "--docker-prom-retention-days": {
                    arglist.removeFirst();
                    this.dockerPromRetentionDays = this.readWordOrThrow(arglist, "prometheus retention (183d by default)");
                    continue block61;
                }
                case "--docker-grafana-tag": {
                    arglist.removeFirst();
                    this.docker_grafana_tag = this.readWordOrThrow(arglist, "grafana docker tag");
                    continue block61;
                }
                case "--version": {
                    arglist.removeFirst();
                    this.wantsVersionShort = true;
                    continue block61;
                }
                case "--version-coords": {
                    arglist.removeFirst();
                    this.wantsVersionCoords = true;
                    continue block61;
                }
                case "--docker-metrics-at": {
                    arglist.removeFirst();
                    this.dockerMetricsHost = this.readWordOrThrow(arglist, "docker metrics host");
                    continue block61;
                }
                case "--docker-metrics": {
                    arglist.removeFirst();
                    this.dockerMetrics = true;
                    continue block61;
                }
                case "--session-name": {
                    arglist.removeFirst();
                    this.sessionName = this.readWordOrThrow(arglist, "a session name");
                    continue block61;
                }
                case "--logs-dir": {
                    arglist.removeFirst();
                    this.logsDirectory = this.readWordOrThrow(arglist, "a log directory");
                    continue block61;
                }
                case "--logs-max": {
                    arglist.removeFirst();
                    this.logsMax = Integer.parseInt(this.readWordOrThrow(arglist, "max logfiles to keep"));
                    continue block61;
                }
                case "--logs-level": {
                    arglist.removeFirst();
                    String loglevel = this.readWordOrThrow(arglist, "a log level");
                    this.logsLevel = NBLogLevel.valueOfName((String)loglevel);
                    continue block61;
                }
                case "--log-level-override": {
                    arglist.removeFirst();
                    this.logLevelsOverrides = this.parseLogLevelOverrides(this.readWordOrThrow(arglist, "log levels in name:LEVEL,... format"));
                    continue block61;
                }
                case "--with-logging-pattern": {
                    arglist.removeFirst();
                    this.consoleLoggingPattern = this.readWordOrThrow(arglist, "logging pattern");
                    continue block61;
                }
            }
            nonincludes.addLast((String)arglist.removeFirst());
        }
        return nonincludes;
    }

    private Path setStatePath() {
        if (this.statePathAccesses.size() > 0) {
            throw new BasicError("The statedir must be set before it is used by other\n options. If you want to change the statedir, be sure you do it before\n dependent options. These parameters were called before this --statedir:\n" + this.statePathAccesses.stream().map(s -> "> " + s).collect(Collectors.joining("\n")));
        }
        if (this.statepath != null) {
            return this.statepath;
        }
        List paths = NBEnvironment.INSTANCE.interpolate((CharSequence)":", this.statedirs);
        Path selected = null;
        for (String pathName : paths) {
            Path path = Path.of(pathName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            if (Files.isDirectory(path, new LinkOption[0])) {
                selected = path;
                break;
            }
            System.err.println("ERROR: possible state dir path is not a directory: '" + path.toString() + "'");
        }
        if (selected == null) {
            selected = Path.of((String)paths.get(0), new String[0]);
        }
        if (!Files.exists(selected, new LinkOption[0])) {
            try {
                Files.createDirectories(selected, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwx---")));
            }
            catch (IOException e) {
                throw new BasicError("Could not create state directory at '" + selected.toString() + "': " + e.getMessage());
            }
        }
        NBEnvironment.INSTANCE.put(NBSTATEDIR, selected.toString());
        return selected;
    }

    private void parseAllOptions(String[] args) {
        LinkedList<String> arglist = this.parseGlobalOptions(args);
        PathCanonicalizer canonicalizer = new PathCanonicalizer(this.wantsIncludes());
        LinkedList<String> nonincludes = new LinkedList<String>();
        block61: while (arglist.peekFirst() != null) {
            String word;
            switch (word = arglist.peekFirst()) {
                case "--graaljs-compat": {
                    this.graaljs_compat = true;
                    arglist.removeFirst();
                    continue block61;
                }
                case "--graaljs": {
                    this.engine = Scenario.Engine.Graalvm;
                    arglist.removeFirst();
                    continue block61;
                }
                case "--nashorn": {
                    throw new RuntimeException("The nashorn engine has been deprecated in this major version of NoSQLBench");
                }
                case "--compile-script": {
                    arglist.removeFirst();
                    this.compileScript = true;
                    continue block61;
                }
                case "--show-script": {
                    arglist.removeFirst();
                    this.showScript = true;
                    continue block61;
                }
                case "--show-stacktraces": {
                    arglist.removeFirst();
                    this.showStackTraces = true;
                    continue block61;
                }
                case "--list-metrics": {
                    arglist.removeFirst();
                    arglist.addFirst("start");
                    Cmd cmd = Cmd.parseArg(arglist, canonicalizer);
                    this.wantsMetricsForActivity = cmd.getArg("driver");
                    continue block61;
                }
                case "--hdr-digits": {
                    arglist.removeFirst();
                    this.hdr_digits = Integer.parseInt(this.readWordOrThrow(arglist, "significant digits"));
                    continue block61;
                }
                case "--progress": {
                    arglist.removeFirst();
                    this.progressSpec = this.readWordOrThrow(arglist, "a progress indicator, like 'log:1m' or 'screen:10s', or just 'log' or 'screen'");
                    continue block61;
                }
                case "--enable-chart": {
                    arglist.removeFirst();
                    this.enableChart = true;
                    continue block61;
                }
                case "--help": 
                case "-h": 
                case "help": {
                    arglist.removeFirst();
                    if (arglist.peekFirst() == null) {
                        this.wantsBasicHelp = true;
                        continue block61;
                    }
                    this.wantsActivityHelp = true;
                    this.wantsActivityHelpFor = this.readWordOrThrow(arglist, "topic");
                    continue block61;
                }
                case "--export-cycle-log": {
                    arglist.removeFirst();
                    this.rleDumpOptions = this.readAllWords(arglist);
                    continue block61;
                }
                case "--import-cycle-log": {
                    arglist.removeFirst();
                    this.cyclelogImportOptions = this.readAllWords(arglist);
                    continue block61;
                }
                case "--log-histograms": {
                    arglist.removeFirst();
                    String logto = arglist.removeFirst();
                    this.histoLoggerConfigs.add(logto);
                    continue block61;
                }
                case "--log-histostats": {
                    arglist.removeFirst();
                    String logStatsTo = arglist.removeFirst();
                    this.statsLoggerConfigs.add(logStatsTo);
                    continue block61;
                }
                case "--classic-histograms": {
                    arglist.removeFirst();
                    String classicHistos = arglist.removeFirst();
                    this.classicHistoConfigs.add(classicHistos);
                    continue block61;
                }
                case "--report-interval": {
                    arglist.removeFirst();
                    this.reportInterval = Integer.parseInt(this.readWordOrThrow(arglist, "report interval"));
                    continue block61;
                }
                case "--report-csv-to": {
                    arglist.removeFirst();
                    this.reportCsvTo = arglist.removeFirst();
                    continue block61;
                }
                case "--report-summary-to": {
                    arglist.removeFirst();
                    this.reportSummaryTo = this.readWordOrThrow(arglist, "report summary file");
                    continue block61;
                }
                case "--list-drivers": 
                case "--list-activity-types": {
                    arglist.removeFirst();
                    this.wantsActivityTypes = true;
                    continue block61;
                }
                case "--list-input-types": {
                    arglist.removeFirst();
                    this.wantsInputTypes = true;
                    continue block61;
                }
                case "--list-output-types": {
                    arglist.removeFirst();
                    this.wantsMarkerTypes = true;
                    continue block61;
                }
                case "--list-scenarios": {
                    arglist.removeFirst();
                    this.wantsScenariosList = true;
                    continue block61;
                }
                case "--list-scripts": {
                    arglist.removeFirst();
                    this.wantsScriptList = true;
                    continue block61;
                }
                case "--list-workloads": {
                    arglist.removeFirst();
                    this.wantsWorkloadsList = true;
                    continue block61;
                }
                case "--script-file": {
                    arglist.removeFirst();
                    this.scriptFile = this.readWordOrThrow(arglist, "script file");
                    continue block61;
                }
                case "--copy": {
                    arglist.removeFirst();
                    this.wantsToCopyWorkload = this.readWordOrThrow(arglist, "workload to copy");
                    continue block61;
                }
            }
            nonincludes.addLast(arglist.removeFirst());
        }
        arglist = nonincludes;
        NBCLICommandParser.parse(arglist, this.cmdList, new String[0]);
    }

    public String[] wantsIncludes() {
        return this.wantsToIncludePaths.toArray(new String[0]);
    }

    private Map<String, String> parseLogLevelOverrides(String levelsSpec) {
        HashMap<String, String> levels = new HashMap<String, String>();
        Arrays.stream(levelsSpec.split("[,;]")).forEach(kp -> {
            String[] ll = kp.split(":");
            if (ll.length != 2) {
                throw new RuntimeException("Log level must have name:level format");
            }
            levels.put(ll[0], ll[1]);
        });
        return levels;
    }

    public Scenario.Engine getScriptingEngine() {
        return this.engine;
    }

    public boolean wantsGraaljsCompatMode() {
        return this.graaljs_compat;
    }

    public List<LoggerConfigData> getHistoLoggerConfigs() {
        List<LoggerConfigData> configs = this.histoLoggerConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_HISTOGRAMS);
        return configs;
    }

    public List<LoggerConfigData> getStatsLoggerConfigs() {
        List<LoggerConfigData> configs = this.statsLoggerConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_HISTOSTATS);
        return configs;
    }

    public List<LoggerConfigData> getClassicHistoConfigs() {
        List<LoggerConfigData> configs = this.classicHistoConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, CLASSIC_HISTOGRAMS);
        return configs;
    }

    public List<Cmd> getCommands() {
        return this.cmdList;
    }

    public boolean wantsShowScript() {
        return this.showScript;
    }

    public boolean wantsCompileScript() {
        return this.compileScript;
    }

    public boolean wantsVersionCoords() {
        return this.wantsVersionCoords;
    }

    public boolean isWantsVersionShort() {
        return this.wantsVersionShort;
    }

    public boolean wantsActivityTypes() {
        return this.wantsActivityTypes;
    }

    public boolean wantsTopicalHelp() {
        return this.wantsActivityHelp;
    }

    public boolean wantsStackTraces() {
        return this.showStackTraces;
    }

    public String wantsTopicalHelpFor() {
        return this.wantsActivityHelpFor;
    }

    public boolean wantsBasicHelp() {
        return this.wantsBasicHelp;
    }

    public boolean wantsEnableChart() {
        return this.enableChart;
    }

    public boolean wantsDockerMetrics() {
        return this.dockerMetrics;
    }

    public String wantsDockerMetricsAt() {
        return this.dockerMetricsHost;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public String wantsReportGraphiteTo() {
        return this.reportGraphiteTo;
    }

    public String wantsMetricsPrefix() {
        return this.metricsPrefix;
    }

    public String wantsMetricsForActivity() {
        return this.wantsMetricsForActivity;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public NBLogLevel getConsoleLogLevel() {
        return this.consoleLevel;
    }

    private String readWordOrThrow(LinkedList<String> arglist, String required) {
        if (arglist.peekFirst() == null) {
            throw new InvalidParameterException(required + " is required after this option");
        }
        return arglist.removeFirst();
    }

    private String[] readAllWords(LinkedList<String> arglist) {
        String[] args = arglist.toArray(new String[0]);
        arglist.clear();
        return args;
    }

    public int getHdrDigits() {
        return this.hdr_digits;
    }

    public String getProgressSpec() {
        ProgressSpec spec = this.parseProgressSpec(this.progressSpec);
        if (spec.indicatorMode == IndicatorMode.console) {
            if (NBLogLevel.INFO.isGreaterOrEqualTo(this.getConsoleLogLevel())) {
                spec.indicatorMode = IndicatorMode.logonly;
            } else if (this.getCommands().stream().anyMatch(cmd -> cmd.getCmdType().equals((Object)Cmd.CmdType.script))) {
                spec.indicatorMode = IndicatorMode.logonly;
            }
        }
        return spec.toString();
    }

    private void checkLoggerConfigs(List<LoggerConfigData> configs, String configName) {
        HashSet files = new HashSet();
        configs.stream().map(LoggerConfigData::getFilename).forEach(s -> {
            if (files.contains(s)) {
                System.err.println(s + " is included in " + configName + " more than once. It will only be included in the first matching config. Reorder your options if you need to control this.");
            }
            files.add(s);
        });
    }

    public String wantsReportCsvTo() {
        return this.reportCsvTo;
    }

    public Path getLogsDirectory() {
        return Path.of(this.logsDirectory, new String[0]);
    }

    public int getLogsMax() {
        return this.logsMax;
    }

    public NBLogLevel getScenarioLogLevel() {
        return this.logsLevel;
    }

    public boolean wantsInputTypes() {
        return this.wantsInputTypes;
    }

    public String getScriptFile() {
        if (this.scriptFile == null) {
            return this.logsDirectory + File.separator + "_SESSION_.js";
        }
        Object expanded = this.scriptFile;
        if (!((String)expanded).startsWith(File.separator)) {
            expanded = this.getLogsDirectory() + File.separator + (String)expanded;
        }
        return expanded;
    }

    public boolean wantsMarkerTypes() {
        return this.wantsMarkerTypes;
    }

    public boolean wantsToDumpCyclelog() {
        return this.rleDumpOptions.length > 0;
    }

    public boolean wantsToImportCycleLog() {
        return this.cyclelogImportOptions.length > 0;
    }

    public String[] getCyclelogImportOptions() {
        return this.cyclelogImportOptions;
    }

    public String[] getCycleLogExporterOptions() {
        return this.rleDumpOptions;
    }

    public String getConsoleLoggingPattern() {
        return this.consoleLoggingPattern;
    }

    public Map<String, String> getLogLevelOverrides() {
        return this.logLevelsOverrides;
    }

    public void setHistoLoggerConfigs(String pattern, String file, String interval) {
        this.histoLoggerConfigs.add(String.format("%s:%s:%s", file, pattern, interval));
    }

    public boolean wantsScenariosList() {
        return this.wantsScenariosList;
    }

    public boolean wantsScriptList() {
        return this.wantsScriptList;
    }

    public boolean wantsToCopyResource() {
        return this.wantsToCopyWorkload != null;
    }

    public String wantsToCopyResourceNamed() {
        return this.wantsToCopyWorkload;
    }

    public boolean wantsWorkloadsList() {
        return this.wantsWorkloadsList;
    }

    public String getDockerGrafanaTag() {
        return this.docker_grafana_tag;
    }

    public String getDockerPromTag() {
        return this.docker_prom_tag;
    }

    private ProgressSpec parseProgressSpec(String interval) {
        ProgressSpec progressSpec = new ProgressSpec();
        String[] parts = interval.split(":");
        switch (parts.length) {
            case 2: {
                Unit.msFor((String)parts[1]).orElseThrow(() -> new RuntimeException("Unable to parse progress indicator indicatorSpec '" + parts[1] + "'"));
                progressSpec.intervalSpec = parts[1];
            }
            case 1: {
                progressSpec.indicatorMode = IndicatorMode.valueOf((String)parts[0]);
                break;
            }
            default: {
                throw new RuntimeException("This should never happen.");
            }
        }
        return progressSpec;
    }

    public static enum Mode {
        ParseGlobalsOnly,
        ParseAllOptions;

    }

    private static class ProgressSpec {
        public String intervalSpec;
        public IndicatorMode indicatorMode;

        private ProgressSpec() {
        }

        public String toString() {
            return this.indicatorMode.toString() + ":" + this.intervalSpec;
        }
    }

    public static class LoggerConfigData {
        public String file;
        public String pattern = ".*";
        public String interval = "30 seconds";

        public LoggerConfigData(String histoLoggerSpec) {
            String[] words = histoLoggerSpec.split(":");
            switch (words.length) {
                case 3: {
                    this.interval = words[2].isEmpty() ? this.interval : words[2];
                }
                case 2: {
                    this.pattern = words[1].isEmpty() ? this.pattern : words[1];
                }
                case 1: {
                    this.file = words[0];
                    if (!this.file.isEmpty()) break;
                    throw new RuntimeException("You must not specify an empty file here for logging data.");
                }
                default: {
                    throw new RuntimeException("--log-histograms options must be in either 'regex:filename:interval' or 'regex:filename' or 'filename' format");
                }
            }
        }

        public String getFilename() {
            return this.file;
        }
    }
}

