/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import java.nio.file.FileSystems;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathCanonicalizer {
    private static final Logger logger = LogManager.getLogger(Cmd.class);
    private final String[] includes;

    public PathCanonicalizer(String ... includes) {
        this.includes = includes;
    }

    public String canonicalizePath(String path) {
        Optional found = NBIO.local().prefix(new String[]{"activities"}).prefix(this.includes).name(new String[]{path}).first();
        if (found.isPresent()) {
            String separator;
            String rewriteTo = ((Content)found.get()).asPath().toString();
            String string = rewriteTo = rewriteTo.startsWith(separator = FileSystems.getDefault().getSeparator()) ? rewriteTo.substring(1) : rewriteTo;
            if (!rewriteTo.equals(path)) {
                if (NBIO.local().prefix(new String[]{"activities"}).prefix(this.includes).name(new String[]{rewriteTo}).first().isPresent()) {
                    logger.info("rewrote path for " + path + " as " + rewriteTo);
                    return rewriteTo;
                }
                logger.trace("kept path for " + path + " as " + ((Content)found.get()).asPath().toString());
                return path;
            }
            logger.trace("kept path for " + path + " as " + ((Content)found.get()).asPath().toString());
        } else {
            logger.trace("unable to find " + path + " for path qualification, either it is remote or missing.");
        }
        return path;
    }
}

