/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.NBIO;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.NBCLIOptions;
import io.nosqlbench.engine.cli.ScriptBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicScriptBuffer
implements ScriptBuffer {
    private static final Logger logger = LogManager.getLogger(Cmd.class);
    private final List<Cmd> commands = new ArrayList<Cmd>();
    private final StringBuilder sb = new StringBuilder();
    private final Map<String, String> scriptParams = new HashMap<String, String>();

    @Override
    public List<Cmd> getCommands() {
        return this.commands;
    }

    public ScriptBuffer add(Cmd cmd) {
        this.commands.add(cmd);
        Map<String, String> params = cmd.getParams();
        switch (cmd.getCmdType()) {
            case script: {
                this.combineGlobalParams(this.scriptParams, cmd);
                String scriptData = BasicScriptBuffer.loadScript(cmd);
                this.sb.append(scriptData);
                break;
            }
            case fragment: {
                this.combineGlobalParams(this.scriptParams, cmd);
                this.sb.append(cmd.getArg("script_fragment"));
                if (!cmd.getArg("script_fragment").endsWith(";")) break;
                this.sb.append("\n");
                break;
            }
            case start: 
            case run: 
            case await: 
            case stop: 
            case forceStop: 
            case waitMillis: {
                this.sb.append("scenario.").append(cmd).append("\n");
            }
        }
        return this;
    }

    private void combineGlobalParams(Map<String, String> scriptParams, Cmd cmd) {
        for (String newkey : cmd.getParams().keySet()) {
            String newvalue = cmd.getParams().get(newkey);
            if (scriptParams.containsKey(newkey)) {
                logger.warn("command '" + cmd.getCmdType() + "' overwrote param '" + newkey + " as " + newvalue);
            }
            scriptParams.put(newkey, newvalue);
        }
    }

    @Override
    public ScriptBuffer add(Cmd ... cmds) {
        for (Cmd cmd : cmds) {
            this.add(cmd);
        }
        return this;
    }

    @Override
    public String getParsedScript() {
        String scripttext = this.sb.toString();
        return scripttext;
    }

    @Override
    public Map<String, String> getCombinedParams() {
        return this.scriptParams;
    }

    public static String assemble(NBCLIOptions options) {
        BasicScriptBuffer script = new BasicScriptBuffer();
        for (Cmd command : options.getCommands()) {
            script.add(new Cmd[]{command});
        }
        return script.getParsedScript();
    }

    public static String loadScript(Cmd cmd) {
        String script_path = cmd.getArg("script_path");
        logger.debug(() -> "Looking for " + script_path);
        Content one = NBIO.all().prefix(new String[]{"scripts"}).name(new String[]{script_path}).extension(new String[]{"js"}).one();
        String scriptData = one.asString();
        StrInterpolator interpolator = new StrInterpolator(cmd.getParams());
        scriptData = interpolator.apply(scriptData);
        return scriptData;
    }
}

