/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.engine.cli.NBCLICommandParser;
import io.nosqlbench.engine.cli.PathCanonicalizer;
import java.lang.invoke.CallSite;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Cmd {
    private static final Logger logger = LogManager.getLogger(Cmd.class);
    private final Map<String, String> cmdArgs;
    private final CmdType cmdType;

    public String getArg(String paramName) {
        return this.cmdArgs.get(paramName);
    }

    public Cmd(CmdType cmdType, Map<String, String> cmdArgs) {
        this.cmdArgs = cmdArgs;
        this.cmdType = cmdType;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public Map<String, String> getParams() {
        return this.cmdArgs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cmdType.toString());
        sb.append("(");
        if (this.getParams().size() > this.cmdType.positional.length) {
            sb.append(Cmd.toJSONBlock(this.getParams(), false));
        } else {
            for (String value : this.getParams().values()) {
                String trimmed = value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
                sb.append("'").append(trimmed).append("'").append(",");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(");");
        return sb.toString();
    }

    public static Cmd parseArg(LinkedList<String> arglist, PathCanonicalizer fixer) {
        String cmdName = arglist.removeFirst();
        CmdType cmdType = CmdType.valueOfAnyCase(cmdName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Arg<?> arg : cmdType.getPositionalArgs()) {
            String nextarg = arglist.peekFirst();
            if (nextarg == null) {
                throw new InvalidParameterException("command '" + cmdName + " requires a value for " + arg.name + ", but there were no remaining arguments after it.");
            }
            if (arg.freeform) {
                logger.debug(() -> "freeform parameter:" + nextarg);
            } else {
                if (nextarg.contains("=")) {
                    throw new InvalidParameterException("command '" + cmdName + "' requires a value for " + arg.name + ", but a named parameter was found instead: " + nextarg);
                }
                if (NBCLICommandParser.RESERVED_WORDS.contains(nextarg)) {
                    throw new InvalidParameterException("command '" + cmdName + "' requires a value for " + arg.name + ", but a reserved word was found instead: " + nextarg);
                }
            }
            logger.debug(() -> "cmd name:" + cmdName + ", positional " + arg.name + ": " + nextarg);
            params.put(arg.name, arg.converter.apply(arglist.removeFirst()).toString());
        }
        while (arglist.size() > 0 && !NBCLICommandParser.RESERVED_WORDS.contains(arglist.peekFirst()) && arglist.peekFirst().contains("=")) {
            String arg = arglist.removeFirst();
            String[] assigned = arg.split("=", 2);
            String pname = assigned[0];
            String pval = assigned[1];
            if (pname.equals("yaml") || pname.equals("workload")) {
                pval = fixer.canonicalizePath(pval);
            }
            if (params.containsKey(pname)) {
                throw new InvalidParameterException("parameter '" + pname + "' is already set for '" + cmdType + "' command. For each command, a named parameter may only be set once. Multiple occurrences are disallowed to avoid errors or ambiguity.");
            }
            params.put(pname, pval);
        }
        return new Cmd(cmdType, params);
    }

    public static String toJSONBlock(Map<String, String> map, boolean oneline) {
        int klen = map.keySet().stream().mapToInt(String::length).max().orElse(1);
        StringBuilder sb = new StringBuilder();
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entries : map.entrySet()) {
            String key = entries.getKey();
            String value = Cmd.sanitizeQuotes(entries.getValue());
            if (oneline) {
                l.add((CallSite)((Object)("'" + key + "':'" + value + "'")));
                continue;
            }
            l.add((CallSite)((Object)("    '" + key + "': " + " ".repeat(klen - key.length()) + "'" + value + "'")));
        }
        return "{" + (oneline ? "" : "\n") + String.join((CharSequence)",\n", l) + (oneline ? "}" : "\n}");
    }

    private static String sanitizeQuotes(String value) {
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static String toJSONParams(String varname, Map<String, String> map, boolean oneline) {
        return "// params.size==" + map.size() + "\n" + varname + "=" + Cmd.toJSONBlock(map, oneline);
    }

    public static enum CmdType {
        run(new Arg[0]),
        start(new Arg[0]),
        stop(Arg.of("alias_name")),
        forceStop(Arg.of("alias_name")),
        script(Arg.of("script_path", s -> s)),
        await(Arg.of("alias_name")),
        waitMillis(Arg.of("millis_to_wait", Long::parseLong)),
        fragment(Arg.ofFreeform("script_fragment"));

        private final Arg<?>[] positional;

        private CmdType(Arg<?> ... positional) {
            this.positional = positional;
        }

        public String[] getPositionalArgNames() {
            String[] names = new String[this.positional.length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.positional[i].name;
            }
            return names;
        }

        public static CmdType valueOfAnyCase(String cmdname) {
            for (CmdType value : CmdType.values()) {
                if (!cmdname.equals(value.toString()) && !cmdname.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CmdType.valueOf(cmdname);
        }

        public Arg<?>[] getPositionalArgs() {
            return this.positional;
        }
    }

    private static final class Arg<T> {
        public final String name;
        public final Function<String, T> converter;
        public final boolean freeform;

        public Arg(String name, Function<String, T> converter, boolean freeform) {
            this.name = name;
            this.converter = converter;
            this.freeform = freeform;
        }

        public static <T> Arg<T> of(String name, Function<String, T> converter) {
            return new Arg<T>(name, converter, false);
        }

        public static Arg<String> of(String name) {
            return new Arg<String>(name, s -> s, false);
        }

        public static Arg<String> ofFreeform(String name) {
            return new Arg<String>(name, s -> s, true);
        }
    }
}

