/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.api.annotations.Annotation;
import io.nosqlbench.api.annotations.Layer;
import io.nosqlbench.api.apps.BundledApp;
import io.nosqlbench.api.content.Content;
import io.nosqlbench.api.content.NBIO;
import io.nosqlbench.api.engine.metrics.ActivityMetrics;
import io.nosqlbench.api.errors.BasicError;
import io.nosqlbench.api.logging.NBLogLevel;
import io.nosqlbench.api.metadata.SessionNamer;
import io.nosqlbench.api.metadata.SystemId;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogDumperUtility;
import io.nosqlbench.engine.api.activityapi.cyclelog.outputs.cyclelog.CycleLogImporterUtility;
import io.nosqlbench.engine.api.activityapi.input.InputType;
import io.nosqlbench.engine.api.activityapi.output.OutputType;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsLoader;
import io.nosqlbench.engine.cli.BasicScriptBuffer;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.NBCLICommandParser;
import io.nosqlbench.engine.cli.NBCLIOptions;
import io.nosqlbench.engine.cli.NBCLIScenarios;
import io.nosqlbench.engine.cli.NBCLIScripts;
import io.nosqlbench.engine.cli.ScriptBuffer;
import io.nosqlbench.engine.cli.VersionInfo;
import io.nosqlbench.engine.core.annotation.Annotators;
import io.nosqlbench.engine.core.lifecycle.activity.ActivityTypeLoader;
import io.nosqlbench.engine.core.lifecycle.process.NBCLIErrorHandler;
import io.nosqlbench.engine.core.lifecycle.process.ShutdownManager;
import io.nosqlbench.engine.core.lifecycle.scenario.Scenario;
import io.nosqlbench.engine.core.lifecycle.scenario.ScenariosExecutor;
import io.nosqlbench.engine.core.lifecycle.scenario.ScenariosResults;
import io.nosqlbench.engine.core.lifecycle.scenario.script.MetricsMapper;
import io.nosqlbench.engine.core.lifecycle.scenario.script.ScriptParams;
import io.nosqlbench.engine.core.logging.LoggerConfig;
import io.nosqlbench.engine.core.metadata.MarkdownFinder;
import io.nosqlbench.engine.core.metrics.MetricReporters;
import io.nosqlbench.engine.docker.DockerMetricsManager;
import io.nosqlbench.nb.annotations.Maturity;
import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.nb.annotations.ServiceSelector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationFactory;

public class NBCLI
implements Function<String[], Integer> {
    private static Logger logger;
    private static final LoggerConfig loggerConfig;
    private static final int EXIT_OK = 0;
    private static final int EXIT_WARNING = 1;
    private static final int EXIT_ERROR = 2;
    private final String commandName;

    public NBCLI(String commandName) {
        this.commandName = commandName;
    }

    public static void main(String[] args) {
        try {
            NBCLI cli = new NBCLI("nb");
            int statusCode = cli.apply(args);
            System.exit(statusCode);
        }
        catch (Exception e) {
            System.out.println("Not expected issue in main: " + e.getMessage());
        }
    }

    @Override
    public Integer apply(String[] args) {
        try {
            NBCLI cli = new NBCLI("nb");
            int result = cli.applyDirect(args);
            return result;
        }
        catch (Exception e) {
            String error;
            boolean showStackTraces = false;
            for (String arg : args) {
                if (!arg.toLowerCase(Locale.ROOT).startsWith("-v") && !arg.toLowerCase(Locale.ROOT).equals("--show-stacktraces")) continue;
                showStackTraces = true;
                break;
            }
            if ((error = NBCLIErrorHandler.handle((Throwable)e, (boolean)showStackTraces)) != null) {
                System.err.println("Scenario stopped due to error. See logs for details.");
            }
            System.err.flush();
            System.out.flush();
            return 2;
        }
    }

    public Integer applyDirect(String[] args) {
        ServiceSelector apploader;
        BundledApp app;
        loggerConfig.setConsoleLevel(NBLogLevel.ERROR);
        NBCLIOptions globalOptions = new NBCLIOptions(args, NBCLIOptions.Mode.ParseGlobalsOnly);
        String sessionName = SessionNamer.format((String)globalOptions.getSessionName());
        loggerConfig.setSessionName(sessionName).setConsoleLevel(globalOptions.getConsoleLogLevel()).setConsolePattern(globalOptions.getConsoleLoggingPattern()).setLogfileLevel(globalOptions.getScenarioLogLevel()).setLogfilePattern(globalOptions.getLogfileLoggingPattern()).setLoggerLevelOverrides(globalOptions.getLogLevelOverrides()).setMaxLogs(globalOptions.getLogsMax()).setLogsDirectory(globalOptions.getLogsDirectory()).setAnsiEnabled(globalOptions.isEnableAnsi()).activate();
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)loggerConfig);
        logger = LogManager.getLogger((String)"NBCLI");
        loggerConfig.purgeOldFiles(LogManager.getLogger((String)"SCENARIO"));
        logger.info(() -> "Configured scenario log at " + loggerConfig.getLogfileLocation());
        logger.debug("Scenario log started");
        if (args.length == 0) {
            System.out.println(this.loadHelpFile("commandline.md"));
            return 0;
        }
        logger.info(() -> "Running NoSQLBench Version " + new VersionInfo().getVersion());
        logger.info(() -> "command-line: " + Arrays.stream(args).collect(Collectors.joining(" ")));
        logger.info(() -> "client-hardware: " + SystemId.getHostSummary());
        if (args.length > 0 && args[0].matches("\\w[\\w\\d-_.]+") && (app = (BundledApp)(apploader = ServiceSelector.of((String)args[0], ServiceLoader.load(BundledApp.class))).get().orElse(null)) != null) {
            String[] appargs = Arrays.copyOfRange(args, 1, args.length);
            logger.info(() -> "invoking bundled app '" + args[0] + "' (" + app.getClass().getSimpleName() + ").");
            globalOptions.setWantsStackTraces(true);
            int result = app.applyAsInt(appargs);
            return result;
        }
        boolean dockerMetrics = globalOptions.wantsDockerMetrics();
        String dockerMetricsAt = globalOptions.wantsDockerMetricsAt();
        Object reportGraphiteTo = globalOptions.wantsReportGraphiteTo();
        Object annotatorsConfig = globalOptions.getAnnotatorsConfig();
        int mOpts = (dockerMetrics ? 1 : 0) + (dockerMetricsAt != null ? 1 : 0) + (reportGraphiteTo != null ? 1 : 0);
        if (mOpts > 1 && (reportGraphiteTo == null || annotatorsConfig == null)) {
            throw new BasicError("You have multiple conflicting options which attempt to set\n the destination for metrics and annotations. Please select only one of\n --docker-metrics, --docker-metrics-at <addr>, or other options like \n --report-graphite-to <addr> and --annotators <config>\n For more details, see run 'nb help docker-metrics'");
        }
        String metricsAddr = null;
        if (dockerMetrics) {
            logger.info("Docker metrics is enabled. Docker must be installed for this to work");
            DockerMetricsManager dmh = new DockerMetricsManager();
            Map<String, String> dashboardOptions = Map.of("grafana_tag", globalOptions.getDockerGrafanaTag(), "prom_tag", globalOptions.getDockerPromTag(), "tsdb_days", String.valueOf(globalOptions.getDockerPromRetentionDays()), "graphite_sample_expiry", "10m", "graphite_cache_size", "5000", "graphite_log_level", globalOptions.getGraphiteLogLevel(), "graphite_log_format", "logfmt");
            dmh.startMetrics(dashboardOptions);
            String warn = "Docker Containers are started, for grafana and prometheus, hit these urls in your browser: http://<host>:3000 and http://<host>:9090";
            logger.warn(warn);
            metricsAddr = "localhost";
        } else if (dockerMetricsAt != null) {
            metricsAddr = dockerMetricsAt;
        }
        if (metricsAddr != null) {
            reportGraphiteTo = metricsAddr + ":9109";
            annotatorsConfig = "[{type:'log',level:'info'},{type:'grafana',baseurl:'http://" + metricsAddr + ":3000/',tags:'appname:nosqlbench',timeoutms:5000,onerror:'warn'}]";
        } else {
            annotatorsConfig = "[{type:'log',level:'info'}]";
        }
        NBCLIOptions options = new NBCLIOptions(args);
        logger = LogManager.getLogger((String)"NBCLI");
        NBIO.addGlobalIncludes((String[])options.wantsIncludes());
        ActivityMetrics.setHdrDigits((int)options.getHdrDigits());
        if (options.wantsBasicHelp()) {
            System.out.println(this.loadHelpFile("basic.md"));
            return 0;
        }
        if (options.isWantsVersionShort()) {
            System.out.println(new VersionInfo().getVersion());
            return 0;
        }
        if (options.wantsVersionCoords()) {
            System.out.println(new VersionInfo().getArtifactCoordinates());
            return 0;
        }
        if (options.isWantsListApps()) {
            ServiceLoader<BundledApp> loader = ServiceLoader.load(BundledApp.class);
            for (ServiceLoader.Provider provider : loader.stream().toList()) {
                Class appType = provider.type();
                String name = appType.getAnnotation(Service.class).selector();
                System.out.printf("%-40s %s%n", name, appType.getCanonicalName());
            }
            return 0;
        }
        if (options.getWantsListCommands()) {
            NBCLICommandParser.RESERVED_WORDS.forEach(System.out::println);
            return 0;
        }
        if (options.wantsActivityTypes()) {
            new ActivityTypeLoader().getAllSelectors().forEach(System.out::println);
            return 0;
        }
        if (options.wantsWorkloadsList()) {
            NBCLIScenarios.printWorkloads(false, options.wantsIncludes());
            return 0;
        }
        if (options.wantsScenariosList()) {
            NBCLIScenarios.printWorkloads(true, options.wantsIncludes());
            return 0;
        }
        if (options.wantsListScripts()) {
            NBCLIScripts.printScripts(true, options.wantsIncludes());
            return 0;
        }
        if (options.wantsToCopyResource()) {
            Content content;
            Path writeTo;
            String resourceToCopy = options.wantsToCopyResourceNamed();
            logger.debug(() -> "user requests to copy out " + resourceToCopy);
            Optional tocopy = NBIO.classpath().prefix(new String[]{"activities"}).prefix(options.wantsIncludes()).name(new String[]{resourceToCopy}).extension(RawStmtsLoader.YAML_EXTENSIONS).first();
            if (tocopy.isEmpty()) {
                tocopy = NBIO.classpath().prefix(new String[0]).prefix(options.wantsIncludes()).prefix(options.wantsIncludes()).name(new String[]{resourceToCopy}).first();
            }
            if (Files.exists(writeTo = Path.of((content = (Content)tocopy.orElseThrow(() -> new BasicError("Unable to find " + resourceToCopy + " in classpath to copy out"))).asPath().getFileName().toString(), new String[0]), new LinkOption[0])) {
                throw new BasicError("A file named " + writeTo + " exists. Remove it first.");
            }
            try {
                Files.writeString(writeTo, (CharSequence)content.getCharBuffer(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new BasicError("Unable to write to " + writeTo + ": " + e.getMessage());
            }
            logger.info(() -> "Copied internal resource '" + data.asPath() + "' to '" + writeTo + "'");
            return 0;
        }
        if (options.wantsInputTypes()) {
            InputType.FINDER.getAllSelectors(new String[0]).forEach((k, v) -> System.out.println(k + " (" + v.name() + ")"));
            return 0;
        }
        if (options.wantsMarkerTypes()) {
            OutputType.FINDER.getAllSelectors(new String[0]).forEach((k, v) -> System.out.println(k + " (" + v.name() + ")"));
            return 0;
        }
        if (options.wantsToDumpCyclelog()) {
            CycleLogDumperUtility.main((String[])options.getCycleLogExporterOptions());
            return 0;
        }
        if (options.wantsToImportCycleLog()) {
            CycleLogImporterUtility.main((String[])options.getCyclelogImportOptions());
            return 0;
        }
        if (options.wantsTopicalHelp()) {
            Optional helpDoc = MarkdownFinder.forHelpTopic((String)options.wantsTopicalHelpFor());
            System.out.println((String)helpDoc.orElseThrow(() -> new RuntimeException("No help could be found for " + options.wantsTopicalHelpFor())));
            return 0;
        }
        if (options.wantsMetricsForActivity() != null) {
            String metricsHelp = this.getMetricsHelpFor(options.wantsMetricsForActivity());
            System.out.println("Available metric names for activity:" + options.wantsMetricsForActivity() + ":");
            System.out.println(metricsHelp);
            return 0;
        }
        logger.debug("initializing annotators with config:'" + (String)annotatorsConfig + "'");
        Annotators.init((String)annotatorsConfig);
        Annotators.recordAnnotation((Annotation)Annotation.newBuilder().session(sessionName).now().layer(Layer.CLI).detail("cli", String.join((CharSequence)"\n", args)).build());
        if (reportGraphiteTo != null || options.wantsReportCsvTo() != null) {
            MetricReporters reporters = MetricReporters.getInstance();
            reporters.addRegistry("workloads", ActivityMetrics.getMetricRegistry());
            if (reportGraphiteTo != null) {
                reporters.addGraphite((String)reportGraphiteTo, options.wantsMetricsPrefix());
            }
            if (options.wantsReportCsvTo() != null) {
                reporters.addCSVReporter(options.wantsReportCsvTo(), options.wantsMetricsPrefix());
            }
            reporters.start(10, options.getReportInterval());
        }
        if (options.wantsEnableChart()) {
            logger.info("Charting enabled");
            if (options.getHistoLoggerConfigs().size() == 0) {
                logger.info("Adding default histologger configs");
                Iterator<NBCLIOptions.LoggerConfigData> pattern = ".*";
                String file = options.getChartHdrFileName();
                String string = "1s";
                options.setHistoLoggerConfigs((String)((Object)pattern), file, string);
            }
        }
        for (NBCLIOptions.LoggerConfigData histoLogger : options.getHistoLoggerConfigs()) {
            ActivityMetrics.addHistoLogger((String)sessionName, (String)histoLogger.pattern, (String)histoLogger.file, (String)histoLogger.interval);
        }
        for (NBCLIOptions.LoggerConfigData statsLogger : options.getStatsLoggerConfigs()) {
            ActivityMetrics.addStatsLogger((String)sessionName, (String)statsLogger.pattern, (String)statsLogger.file, (String)statsLogger.interval);
        }
        for (NBCLIOptions.LoggerConfigData classicConfigs : options.getClassicHistoConfigs()) {
            ActivityMetrics.addClassicHistos((String)sessionName, (String)classicConfigs.pattern, (String)classicConfigs.file, (String)classicConfigs.interval);
        }
        logger.info(() -> "console logging level is " + options.getConsoleLogLevel());
        ScenariosExecutor scenariosExecutor = new ScenariosExecutor("executor-" + sessionName, 1);
        if (options.getConsoleLogLevel().isGreaterOrEqualTo(NBLogLevel.WARN)) {
            options.setWantsStackTraces(true);
            logger.debug(() -> "enabling stack traces since log level is " + options.getConsoleLogLevel());
        }
        Scenario scenario = new Scenario(sessionName, options.getScriptFile(), options.getScriptingEngine(), options.getProgressSpec(), options.wantsStackTraces(), options.wantsCompileScript(), options.getReportSummaryTo(), String.join((CharSequence)"\n", args), options.getLogsDirectory(), Maturity.Unspecified);
        ScriptBuffer scriptBuffer = new BasicScriptBuffer().add(options.getCommands().toArray(new Cmd[0]));
        String scriptData = scriptBuffer.getParsedScript();
        if (options.wantsShowScript()) {
            System.out.println("// Rendered Script");
            System.out.println(scriptData);
            return 0;
        }
        if (options.wantsEnableChart()) {
            logger.info("Charting enabled");
            scenario.enableCharting();
        } else {
            logger.info("Charting disabled");
        }
        if (options.getCommands().size() == 0) {
            logger.info("No commands provided. Exiting before scenario.");
            return 0;
        }
        scenario.addScriptText(scriptData);
        ScriptParams scriptParams = new ScriptParams();
        scriptParams.putAll(scriptBuffer.getCombinedParams());
        scenario.addScenarioScriptParams(scriptParams);
        scenariosExecutor.execute(scenario);
        ScenariosResults scenariosResults = scenariosExecutor.awaitAllResults();
        logger.debug(() -> "Total of " + scenariosResults.getSize() + " result object returned from ScenariosExecutor");
        ActivityMetrics.closeMetrics((boolean)options.wantsEnableChart());
        scenariosResults.reportToLog();
        ShutdownManager.shutdown();
        logger.info(scenariosResults.getExecutionSummary());
        if (scenariosResults.hasError()) {
            Exception exception = scenariosResults.getOne().getException();
            logger.warn(scenariosResults.getExecutionSummary());
            NBCLIErrorHandler.handle((Throwable)exception, (boolean)options.wantsStackTraces());
            System.err.println(exception.getMessage());
            return 2;
        }
        logger.info(scenariosResults.getExecutionSummary());
        return 0;
    }

    private String loadHelpFile(String filename) {
        String basicHelp;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream resourceAsStream = cl.getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new RuntimeException("Unable to find " + filename + " in classpath.");
        }
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(resourceAsStream));){
            basicHelp = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer " + filename + ": " + t);
        }
        basicHelp = basicHelp.replaceAll("PROG", this.commandName);
        return basicHelp;
    }

    private String getMetricsHelpFor(String activityType) {
        String metrics = MetricsMapper.metricsDetail((String)activityType);
        return metrics;
    }

    static {
        loggerConfig = new LoggerConfig();
        LoggerConfig.setConfigurationFactory((ConfigurationFactory)loggerConfig);
    }
}

