/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.api.content.NBIO;
import io.nosqlbench.engine.api.scenarios.NBCLIScenarioParser;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.PathCanonicalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class NBCLICommandParser {
    private static final String FRAGMENT = "fragment";
    private static final String SCRIPT = "script";
    private static final String START = "start";
    private static final String RUN = "run";
    private static final String AWAIT = "await";
    private static final String STOP = "stop";
    private static final String FORCE_STOP = "forceStop";
    private static final String ACTIVITY = "activity";
    private static final String SCENARIO = "scenario";
    private static final String WAIT_MILLIS = "waitmillis";
    public static final Set<String> RESERVED_WORDS = new HashSet<String>(){
        {
            this.addAll(Arrays.asList(NBCLICommandParser.FRAGMENT, NBCLICommandParser.SCRIPT, NBCLICommandParser.START, NBCLICommandParser.RUN, NBCLICommandParser.AWAIT, NBCLICommandParser.STOP, NBCLICommandParser.FORCE_STOP, NBCLICommandParser.ACTIVITY, NBCLICommandParser.SCENARIO, NBCLICommandParser.WAIT_MILLIS));
        }
    };

    public static Optional<List<Cmd>> parse(LinkedList<String> arglist, String ... includes) {
        LinkedList<Cmd> cmdList = new LinkedList<Cmd>();
        PathCanonicalizer canonicalizer = new PathCanonicalizer(includes);
        block13: while (arglist.peekFirst() != null) {
            Cmd cmd;
            String word;
            switch (word = arglist.peekFirst()) {
                case "fragment": 
                case "script": 
                case "start": 
                case "run": 
                case "await": 
                case "stop": 
                case "forceStop": 
                case "waitmillis": {
                    cmd = Cmd.parseArg(arglist, canonicalizer);
                    cmdList.add(cmd);
                    continue block13;
                }
            }
            Optional scriptfile = NBIO.local().prefix(new String[]{"scripts/auto"}).name(new String[]{word}).extension(new String[]{"js"}).first();
            if (scriptfile.isPresent()) {
                arglist.removeFirst();
                arglist.addFirst("scripts/auto/" + word);
                arglist.addFirst(SCRIPT);
                cmd = Cmd.parseArg(arglist, canonicalizer);
                cmdList.add(cmd);
                continue;
            }
            if (NBCLIScenarioParser.isFoundWorkload((String)word, (String[])includes)) {
                NBCLIScenarioParser.parseScenarioCommand(arglist, RESERVED_WORDS, (String[])includes);
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(cmdList);
    }
}

