/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.cli;

import io.nosqlbench.api.engine.util.Unit;
import io.nosqlbench.api.errors.BasicError;
import io.nosqlbench.api.logging.NBLogLevel;
import io.nosqlbench.api.system.NBEnvironment;
import io.nosqlbench.engine.api.metrics.IndicatorMode;
import io.nosqlbench.engine.cli.Cmd;
import io.nosqlbench.engine.cli.NBCLIArgsFile;
import io.nosqlbench.engine.cli.NBCLICommandParser;
import io.nosqlbench.engine.cli.PathCanonicalizer;
import io.nosqlbench.engine.core.lifecycle.scenario.Scenario;
import io.nosqlbench.nb.annotations.Maturity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class NBCLIOptions {
    private static final String NB_STATE_DIR = "--statedir";
    private static final String NB_STATEDIR_PATHS = "$NBSTATEDIR:$PWD/.nosqlbench:$HOME/.nosqlbench";
    public static final String ARGS_FILE_DEFAULT = "$NBSTATEDIR/argsfile";
    private static final String INCLUDE = "--include";
    private static final String userHome = System.getProperty("user.home");
    private static final String METRICS_PREFIX = "--metrics-prefix";
    private static final String ANNOTATE_EVENTS = "--annotate";
    private static final String ANNOTATORS_CONFIG = "--annotators";
    private static final String ANSI = "--ansi";
    private static final String DEFAULT_CHART_HDR_LOG_NAME = "hdrdata-for-chart.log";
    private static final String HELP = "--help";
    private static final String LIST_COMMANDS = "--list-commands";
    private static final String LIST_METRICS = "--list-metrics";
    private static final String LIST_DRIVERS = "--list-drivers";
    private static final String LIST_ACTIVITY_TYPES = "--list-activity-types";
    private static final String LIST_SCRIPTS = "--list-scripts";
    private static final String LIST_WORKLOADS = "--list-workloads";
    private static final String LIST_SCENARIOS = "--list-scenarios";
    private static final String LIST_INPUT_TYPES = "--list-input-types";
    private static final String LIST_OUTPUT_TYPES = "--list-output-types";
    private static final String LIST_APPS = "--list-apps";
    private static final String VERSION_COORDS = "--version-coords";
    private static final String VERSION = "--version";
    private static final String SHOW_SCRIPT = "--show-script";
    private static final String COMPILE_SCRIPT = "--compile-script";
    private static final String SCRIPT_FILE = "--script-file";
    private static final String COPY = "--copy";
    private static final String SHOW_STACKTRACES = "--show-stacktraces";
    private static final String EXPERIMENTAL = "--experimental";
    private static final String MATURITY = "--maturity";
    private static final String EXPORT_CYCLE_LOG = "--export-cycle-log";
    private static final String IMPORT_CYCLE_LOG = "--import-cycle-log";
    private static final String HDR_DIGITS = "--hdr-digits";
    private static final String SESSION_NAME = "--session-name";
    private static final String LOGS_DIR = "--logs-dir";
    private static final String WORKSPACES_DIR = "--workspaces-dir";
    private static final String LOGS_MAX = "--logs-max";
    private static final String LOGS_LEVEL = "--logs-level";
    private static final String DASH_V_INFO = "-v";
    private static final String DASH_VV_DEBUG = "-vv";
    private static final String DASH_VVV_TRACE = "-vvv";
    private static final String REPORT_INTERVAL = "--report-interval";
    private static final String REPORT_GRAPHITE_TO = "--report-graphite-to";
    private static final String GRAPHITE_LOG_LEVEL = "--graphite-log-level";
    private static final String REPORT_CSV_TO = "--report-csv-to";
    private static final String REPORT_SUMMARY_TO = "--report-summary-to";
    private static final String REPORT_SUMMARY_TO_DEFAULT = "stdout:60,_LOGS_/_SESSION_.summary";
    private static final String PROGRESS = "--progress";
    private static final String WITH_LOGGING_PATTERN = "--with-logging-pattern";
    private static final String LOGGING_PATTERN = "--logging-pattern";
    private static final String CONSOLE_PATTERN = "--console-pattern";
    private static final String LOGFILE_PATTERN = "--logfile-pattern";
    private static final String LOG_HISTOGRAMS = "--log-histograms";
    private static final String LOG_HISTOSTATS = "--log-histostats";
    private static final String CLASSIC_HISTOGRAMS = "--classic-histograms";
    private static final String LOG_LEVEL_OVERRIDE = "--log-level-override";
    private static final String ENABLE_CHART = "--enable-chart";
    private static final String DOCKER_METRICS = "--docker-metrics";
    private static final String DOCKER_METRICS_AT = "--docker-metrics-at";
    private static final String DOCKER_GRAFANA_TAG = "--docker-grafana-tag";
    private static final String DOCKER_PROM_TAG = "--docker-prom-tag";
    private static final String DOCKER_PROM_RETENTION_DAYS = "--docker-prom-retention-days";
    private static final String GRAALJS_ENGINE = "--graaljs";
    private static final String DEFAULT_CONSOLE_PATTERN = "TERSE";
    private static final String DEFAULT_LOGFILE_PATTERN = "VERBOSE";
    private final List<Cmd> cmdList = new ArrayList<Cmd>();
    private int logsMax = 0;
    private boolean wantsVersionShort = false;
    private boolean wantsVersionCoords = false;
    private boolean wantsActivityHelp = false;
    private String wantsActivityHelpFor;
    private boolean wantsActivityTypes = false;
    private boolean wantsBasicHelp = false;
    private String reportGraphiteTo = null;
    private String reportCsvTo = null;
    private int reportInterval = 10;
    private String metricsPrefix = "nosqlbench";
    private String wantsMetricsForActivity;
    private String sessionName = "";
    private boolean showScript = false;
    private NBLogLevel consoleLevel = NBLogLevel.WARN;
    private final List<String> histoLoggerConfigs = new ArrayList<String>();
    private final List<String> statsLoggerConfigs = new ArrayList<String>();
    private final List<String> classicHistoConfigs = new ArrayList<String>();
    private String progressSpec = "console:1m";
    private String logsDirectory = "logs";
    private String workspacesDirectory = "workspaces";
    private boolean wantsInputTypes = false;
    private boolean wantsMarkerTypes = false;
    private String[] rleDumpOptions = new String[0];
    private String[] cyclelogImportOptions = new String[0];
    private String consoleLoggingPattern = "TERSE";
    private String logfileLoggingPattern = "VERBOSE";
    private NBLogLevel logsLevel = NBLogLevel.INFO;
    private Map<String, String> logLevelsOverrides = new HashMap<String, String>();
    private boolean enableChart = false;
    private boolean dockerMetrics = false;
    private boolean wantsListScenarios = false;
    private boolean wantsListScripts = false;
    private String wantsToCopyWorkload = null;
    private boolean wantsWorkloadsList = false;
    private final List<String> wantsToIncludePaths = new ArrayList<String>();
    private Scenario.Engine engine = Scenario.Engine.Graalvm;
    private int hdr_digits = 3;
    private String docker_grafana_tag = "7.3.4";
    private String docker_prom_tag = "latest";
    private boolean showStackTraces = false;
    private boolean compileScript = false;
    private String scriptFile = null;
    private String[] annotateEvents = new String[]{"ALL"};
    private String dockerMetricsHost;
    private String annotatorsConfig = "";
    private String statedirs = "$NBSTATEDIR:$PWD/.nosqlbench:$HOME/.nosqlbench";
    private Path statepath;
    private final List<String> statePathAccesses = new ArrayList<String>();
    private final String hdrForChartFileName = "hdrdata-for-chart.log";
    private String dockerPromRetentionDays = "3650d";
    private String reportSummaryTo = "stdout:60,_LOGS_/_SESSION_.summary";
    private boolean enableAnsi = System.getenv("TERM") != null && !System.getenv("TERM").isEmpty();
    private Maturity minMaturity = Maturity.Unspecified;
    private String graphitelogLevel = "info";
    private boolean wantsListCommands = false;
    private boolean wantsListApps = false;

    public boolean isWantsListApps() {
        return this.wantsListApps;
    }

    public boolean getWantsListCommands() {
        return this.wantsListCommands;
    }

    public String getAnnotatorsConfig() {
        return this.annotatorsConfig;
    }

    public String getChartHdrFileName() {
        return DEFAULT_CHART_HDR_LOG_NAME;
    }

    public String getDockerPromRetentionDays() {
        return this.dockerPromRetentionDays;
    }

    public String getReportSummaryTo() {
        return this.reportSummaryTo;
    }

    public void setWantsStackTraces(boolean wantsStackTraces) {
        this.showStackTraces = wantsStackTraces;
    }

    public boolean isEnableAnsi() {
        return this.enableAnsi;
    }

    public String getLogfileLoggingPattern() {
        return this.logfileLoggingPattern;
    }

    public String getGraphiteLogLevel() {
        return this.graphitelogLevel;
    }

    public NBCLIOptions(String[] args) {
        this(args, Mode.ParseAllOptions);
    }

    public NBCLIOptions(String[] args, Mode mode) {
        switch (mode) {
            case ParseGlobalsOnly: {
                this.parseGlobalOptions(args);
                break;
            }
            case ParseAllOptions: {
                this.parseAllOptions(args);
            }
        }
    }

    private LinkedList<String> parseGlobalOptions(final String[] args) {
        LinkedList arglist = new LinkedList<String>(){
            {
                this.addAll(Arrays.asList(args));
            }
        };
        if (arglist.peekFirst() == null) {
            this.wantsBasicHelp = true;
            return arglist;
        }
        LinkedList<String> nonincludes = new LinkedList<String>();
        block75: while (arglist.peekFirst() != null) {
            String word = (String)arglist.peekFirst();
            if (word.startsWith("--") && word.contains("=")) {
                String wordToSplit = (String)arglist.removeFirst();
                String[] split = wordToSplit.split("=", 2);
                arglist.offerFirst(split[1]);
                arglist.offerFirst(split[0]);
                continue;
            }
            switch (word) {
                case "--statedir": {
                    arglist.removeFirst();
                    this.statedirs = this.readWordOrThrow(arglist, "nosqlbench global state directory");
                    continue block75;
                }
                case "--include": {
                    arglist.removeFirst();
                    String include = this.readWordOrThrow(arglist, "path to include");
                    this.wantsToIncludePaths.add(include);
                    continue block75;
                }
            }
            nonincludes.addLast((String)arglist.removeFirst());
        }
        this.statedirs = this.statedirs != null ? this.statedirs : NB_STATEDIR_PATHS;
        this.setStatePath();
        arglist = nonincludes;
        nonincludes = new LinkedList();
        NBCLIArgsFile argsfile = new NBCLIArgsFile();
        argsfile.reserved(NBCLICommandParser.RESERVED_WORDS);
        argsfile.preload("--argsfile-optional", ARGS_FILE_DEFAULT);
        arglist = argsfile.process(arglist);
        block76: while (arglist.peekFirst() != null) {
            String word = (String)arglist.peekFirst();
            if (word.startsWith("--") && word.contains("=")) {
                String wordToSplit = (String)arglist.removeFirst();
                String[] split = wordToSplit.split("=", 2);
                arglist.offerFirst(split[1]);
                arglist.offerFirst(split[0]);
                continue;
            }
            switch (word) {
                case "--argsfile": 
                case "--argsfile-optional": 
                case "--argsfile-required": 
                case "--pin": 
                case "--unpin": {
                    if (this.statepath == null) {
                        this.setStatePath();
                    }
                    arglist = argsfile.process(arglist);
                    continue block76;
                }
                case "--ansi": {
                    arglist.removeFirst();
                    String doEnableAnsi = this.readWordOrThrow(arglist, "enable/disable ansi codes");
                    this.enableAnsi = doEnableAnsi.toLowerCase(Locale.ROOT).matches("enabled|enable|true");
                    continue block76;
                }
                case "-v": {
                    this.consoleLevel = NBLogLevel.INFO;
                    arglist.removeFirst();
                    continue block76;
                }
                case "-vv": {
                    this.consoleLevel = NBLogLevel.DEBUG;
                    this.setWantsStackTraces(true);
                    arglist.removeFirst();
                    continue block76;
                }
                case "-vvv": {
                    this.consoleLevel = NBLogLevel.TRACE;
                    this.setWantsStackTraces(true);
                    arglist.removeFirst();
                    continue block76;
                }
                case "--annotate": {
                    arglist.removeFirst();
                    String toAnnotate = this.readWordOrThrow(arglist, "annotated events");
                    this.annotateEvents = toAnnotate.split("\\\\s*,\\\\s*");
                    continue block76;
                }
                case "--annotators": {
                    arglist.removeFirst();
                    this.annotatorsConfig = this.readWordOrThrow(arglist, "annotators config");
                    continue block76;
                }
                case "--report-graphite-to": {
                    arglist.removeFirst();
                    this.reportGraphiteTo = (String)arglist.removeFirst();
                    continue block76;
                }
                case "--graphite-log-level": {
                    arglist.removeFirst();
                    this.graphitelogLevel = (String)arglist.removeFirst();
                    continue block76;
                }
                case "--metrics-prefix": {
                    arglist.removeFirst();
                    this.metricsPrefix = (String)arglist.removeFirst();
                    continue block76;
                }
                case "--workspaces-dir": {
                    arglist.removeFirst();
                    this.workspacesDirectory = this.readWordOrThrow(arglist, "a workspaces directory");
                    continue block76;
                }
                case "--docker-prom-tag": {
                    arglist.removeFirst();
                    this.docker_prom_tag = this.readWordOrThrow(arglist, "prometheus docker tag");
                    continue block76;
                }
                case "--docker-prom-retention-days": {
                    arglist.removeFirst();
                    this.dockerPromRetentionDays = this.readWordOrThrow(arglist, "prometheus retention (3650d by default)");
                    continue block76;
                }
                case "--docker-grafana-tag": {
                    arglist.removeFirst();
                    this.docker_grafana_tag = this.readWordOrThrow(arglist, "grafana docker tag");
                    continue block76;
                }
                case "--version": {
                    arglist.removeFirst();
                    this.wantsVersionShort = true;
                    continue block76;
                }
                case "--version-coords": {
                    arglist.removeFirst();
                    this.wantsVersionCoords = true;
                    continue block76;
                }
                case "--docker-metrics-at": {
                    arglist.removeFirst();
                    this.dockerMetricsHost = this.readWordOrThrow(arglist, "docker metrics host");
                    continue block76;
                }
                case "--docker-metrics": {
                    arglist.removeFirst();
                    this.dockerMetrics = true;
                    continue block76;
                }
                case "--session-name": {
                    arglist.removeFirst();
                    this.sessionName = this.readWordOrThrow(arglist, "a session name");
                    continue block76;
                }
                case "--logs-dir": {
                    arglist.removeFirst();
                    this.logsDirectory = this.readWordOrThrow(arglist, "a log directory");
                    continue block76;
                }
                case "--logs-max": {
                    arglist.removeFirst();
                    this.logsMax = Integer.parseInt(this.readWordOrThrow(arglist, "max logfiles to keep"));
                    continue block76;
                }
                case "--logs-level": {
                    arglist.removeFirst();
                    String loglevel = this.readWordOrThrow(arglist, "a log level");
                    this.logsLevel = NBLogLevel.valueOfName((String)loglevel);
                    continue block76;
                }
                case "--log-level-override": {
                    arglist.removeFirst();
                    this.logLevelsOverrides = this.parseLogLevelOverrides(this.readWordOrThrow(arglist, "log levels in name:LEVEL,... format"));
                    continue block76;
                }
                case "--console-pattern": {
                    arglist.removeFirst();
                    this.consoleLoggingPattern = this.readWordOrThrow(arglist, "console pattern");
                    continue block76;
                }
                case "--logfile-pattern": {
                    arglist.removeFirst();
                    this.logfileLoggingPattern = this.readWordOrThrow(arglist, "logfile pattern");
                    continue block76;
                }
                case "--with-logging-pattern": 
                case "--logging-pattern": {
                    String pattern;
                    arglist.removeFirst();
                    this.consoleLoggingPattern = pattern = this.readWordOrThrow(arglist, "console and logfile pattern");
                    this.logfileLoggingPattern = pattern;
                    continue block76;
                }
                case "--show-stacktraces": {
                    arglist.removeFirst();
                    this.showStackTraces = true;
                    continue block76;
                }
                case "--experimental": {
                    arglist.removeFirst();
                    arglist.addFirst("experimental");
                    arglist.addFirst(MATURITY);
                    continue block76;
                }
                case "--maturity": {
                    arglist.removeFirst();
                    String maturity = this.readWordOrThrow(arglist, "maturity of components to allow");
                    this.minMaturity = Maturity.valueOf((String)maturity.toLowerCase(Locale.ROOT));
                }
            }
            nonincludes.addLast((String)arglist.removeFirst());
        }
        return nonincludes;
    }

    private Path setStatePath() {
        if (this.statePathAccesses.size() > 0) {
            throw new BasicError("The state dir must be set before it is used by other\n options. If you want to change the statedir, be sure you do it before\n dependent options. These parameters were called before this --statedir:\n" + this.statePathAccesses.stream().map(s -> "> " + s).collect(Collectors.joining("\n")));
        }
        if (this.statepath != null) {
            return this.statepath;
        }
        List paths = NBEnvironment.INSTANCE.interpolateEach((CharSequence)":", this.statedirs);
        Path selected = null;
        for (String pathName : paths) {
            Path path = Path.of(pathName, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) continue;
            if (Files.isDirectory(path, new LinkOption[0])) {
                selected = path;
                break;
            }
            System.err.println("ERROR: possible state dir path is not a directory: '" + path + "'");
        }
        if (selected == null) {
            selected = Path.of((String)paths.get(paths.size() - 1), new String[0]);
        }
        if (!Files.exists(selected, new LinkOption[0])) {
            try {
                Files.createDirectories(selected, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwx---")));
            }
            catch (IOException e) {
                throw new BasicError("Could not create state directory at '" + selected + "': " + e.getMessage());
            }
        }
        NBEnvironment.INSTANCE.put("NBSTATEDIR", selected.toString());
        return selected;
    }

    private void parseAllOptions(String[] args) {
        LinkedList<String> arglist = this.parseGlobalOptions(args);
        PathCanonicalizer canonicalizer = new PathCanonicalizer(this.wantsIncludes());
        LinkedList<String> nonincludes = new LinkedList<String>();
        block59: while (arglist.peekFirst() != null) {
            String word;
            switch (word = arglist.peekFirst()) {
                case "--graaljs": {
                    this.engine = Scenario.Engine.Graalvm;
                    arglist.removeFirst();
                    continue block59;
                }
                case "--compile-script": {
                    arglist.removeFirst();
                    this.compileScript = true;
                    continue block59;
                }
                case "--show-script": {
                    arglist.removeFirst();
                    this.showScript = true;
                    continue block59;
                }
                case "--list-commands": {
                    arglist.removeFirst();
                    this.wantsListCommands = true;
                    continue block59;
                }
                case "--list-metrics": {
                    arglist.removeFirst();
                    arglist.addFirst("start");
                    Cmd cmd = Cmd.parseArg(arglist, canonicalizer);
                    this.wantsMetricsForActivity = cmd.getArg("driver");
                    continue block59;
                }
                case "--hdr-digits": {
                    arglist.removeFirst();
                    this.hdr_digits = Integer.parseInt(this.readWordOrThrow(arglist, "significant digits"));
                    continue block59;
                }
                case "--progress": {
                    arglist.removeFirst();
                    this.progressSpec = this.readWordOrThrow(arglist, "a progress indicator, like 'log:1m' or 'screen:10s', or just 'log' or 'screen'");
                    continue block59;
                }
                case "--enable-chart": {
                    arglist.removeFirst();
                    this.enableChart = true;
                    continue block59;
                }
                case "--help": 
                case "-h": 
                case "help": {
                    arglist.removeFirst();
                    if (arglist.peekFirst() == null) {
                        this.wantsBasicHelp = true;
                        continue block59;
                    }
                    this.wantsActivityHelp = true;
                    this.wantsActivityHelpFor = this.readWordOrThrow(arglist, "topic");
                    continue block59;
                }
                case "--export-cycle-log": {
                    arglist.removeFirst();
                    this.rleDumpOptions = this.readAllWords(arglist);
                    continue block59;
                }
                case "--import-cycle-log": {
                    arglist.removeFirst();
                    this.cyclelogImportOptions = this.readAllWords(arglist);
                    continue block59;
                }
                case "--log-histograms": {
                    arglist.removeFirst();
                    String logto = arglist.removeFirst();
                    this.histoLoggerConfigs.add(logto);
                    continue block59;
                }
                case "--log-histostats": {
                    arglist.removeFirst();
                    String logStatsTo = arglist.removeFirst();
                    this.statsLoggerConfigs.add(logStatsTo);
                    continue block59;
                }
                case "--classic-histograms": {
                    arglist.removeFirst();
                    String classicHistos = arglist.removeFirst();
                    this.classicHistoConfigs.add(classicHistos);
                    continue block59;
                }
                case "--report-interval": {
                    arglist.removeFirst();
                    this.reportInterval = Integer.parseInt(this.readWordOrThrow(arglist, "report interval"));
                    continue block59;
                }
                case "--report-csv-to": {
                    arglist.removeFirst();
                    this.reportCsvTo = arglist.removeFirst();
                    continue block59;
                }
                case "--report-summary-to": {
                    arglist.removeFirst();
                    this.reportSummaryTo = this.readWordOrThrow(arglist, "report summary file");
                    continue block59;
                }
                case "--list-drivers": 
                case "--list-activity-types": {
                    arglist.removeFirst();
                    this.wantsActivityTypes = true;
                    continue block59;
                }
                case "--list-input-types": {
                    arglist.removeFirst();
                    this.wantsInputTypes = true;
                    continue block59;
                }
                case "--list-output-types": {
                    arglist.removeFirst();
                    this.wantsMarkerTypes = true;
                    continue block59;
                }
                case "--list-scenarios": {
                    arglist.removeFirst();
                    this.wantsListScenarios = true;
                    continue block59;
                }
                case "--list-scripts": {
                    arglist.removeFirst();
                    this.wantsListScripts = true;
                    continue block59;
                }
                case "--list-workloads": {
                    arglist.removeFirst();
                    this.wantsWorkloadsList = true;
                    continue block59;
                }
                case "--list-apps": {
                    arglist.removeFirst();
                    this.wantsListApps = true;
                    continue block59;
                }
                case "--script-file": {
                    arglist.removeFirst();
                    this.scriptFile = this.readWordOrThrow(arglist, "script file");
                    continue block59;
                }
                case "--copy": {
                    arglist.removeFirst();
                    this.wantsToCopyWorkload = this.readWordOrThrow(arglist, "workload to copy");
                    continue block59;
                }
            }
            nonincludes.addLast(arglist.removeFirst());
        }
        arglist = nonincludes;
        Optional<List<Cmd>> commands = NBCLICommandParser.parse(arglist, new String[0]);
        if (!commands.isPresent()) {
            String arg = arglist.peekFirst();
            Objects.requireNonNull(arg);
            String helpmsg = "Could not recognize command 'ARG'.\nThis means that all of the following searches for a compatible command failed:\n1. commands: no scenario command named 'ARG' is known. (start, run, await, ...)\n2. scripts: no auto script named './scripts/auto/ARG.js' in the local filesystem.\n3. scripts: no auto script named 'scripts/auto/ARG.js' was found in the PROG binary.\n4. workloads: no workload file named ARG[.yaml] was found in the local filesystem, even in include paths INCLUDES.\n5. workloads: no workload file named ARG[.yaml] was bundled in PROG binary, even in include paths INCLUDES.\n6. apps: no application named ARG was bundled in PROG.\n\nYou can discover available ways to invoke PROG by using the various --list-* commands:\n[ --list-commands, --list-scripts, --list-workloads (and --list-scenarios), --list-apps ]\n".replaceAll("ARG", arg).replaceAll("PROG", "nb5").replaceAll("INCLUDES", String.join((CharSequence)",", this.wantsIncludes()));
            throw new BasicError(helpmsg);
        }
        this.cmdList.addAll((Collection<Cmd>)commands.get());
    }

    public String[] wantsIncludes() {
        return this.wantsToIncludePaths.toArray(new String[0]);
    }

    private Map<String, String> parseLogLevelOverrides(String levelsSpec) {
        HashMap<String, String> levels = new HashMap<String, String>();
        Arrays.stream(levelsSpec.split("[,;]")).forEach(kp -> {
            String[] ll = kp.split(":");
            if (ll.length != 2) {
                throw new RuntimeException("Log level must have name:level format");
            }
            levels.put(ll[0], ll[1]);
        });
        return levels;
    }

    public Scenario.Engine getScriptingEngine() {
        return this.engine;
    }

    public List<LoggerConfigData> getHistoLoggerConfigs() {
        List<LoggerConfigData> configs = this.histoLoggerConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_HISTOGRAMS);
        return configs;
    }

    public List<LoggerConfigData> getStatsLoggerConfigs() {
        List<LoggerConfigData> configs = this.statsLoggerConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, LOG_HISTOSTATS);
        return configs;
    }

    public List<LoggerConfigData> getClassicHistoConfigs() {
        List<LoggerConfigData> configs = this.classicHistoConfigs.stream().map(LoggerConfigData::new).collect(Collectors.toList());
        this.checkLoggerConfigs(configs, CLASSIC_HISTOGRAMS);
        return configs;
    }

    public Maturity allowMinMaturity() {
        return this.minMaturity;
    }

    public List<Cmd> getCommands() {
        return this.cmdList;
    }

    public boolean wantsShowScript() {
        return this.showScript;
    }

    public boolean wantsCompileScript() {
        return this.compileScript;
    }

    public boolean wantsVersionCoords() {
        return this.wantsVersionCoords;
    }

    public boolean isWantsVersionShort() {
        return this.wantsVersionShort;
    }

    public boolean wantsActivityTypes() {
        return this.wantsActivityTypes;
    }

    public boolean wantsTopicalHelp() {
        return this.wantsActivityHelp;
    }

    public boolean wantsStackTraces() {
        return this.showStackTraces;
    }

    public String wantsTopicalHelpFor() {
        return this.wantsActivityHelpFor;
    }

    public boolean wantsBasicHelp() {
        return this.wantsBasicHelp;
    }

    public boolean wantsEnableChart() {
        return this.enableChart;
    }

    public boolean wantsDockerMetrics() {
        return this.dockerMetrics;
    }

    public String wantsDockerMetricsAt() {
        return this.dockerMetricsHost;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public String wantsReportGraphiteTo() {
        return this.reportGraphiteTo;
    }

    public String wantsMetricsPrefix() {
        return this.metricsPrefix;
    }

    public String wantsMetricsForActivity() {
        return this.wantsMetricsForActivity;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public NBLogLevel getConsoleLogLevel() {
        return this.consoleLevel;
    }

    private String readWordOrThrow(LinkedList<String> arglist, String required) {
        if (arglist.peekFirst() == null) {
            throw new InvalidParameterException(required + " is required after this option");
        }
        return arglist.removeFirst();
    }

    private String[] readAllWords(LinkedList<String> arglist) {
        String[] args = arglist.toArray(new String[0]);
        arglist.clear();
        return args;
    }

    public int getHdrDigits() {
        return this.hdr_digits;
    }

    public String getProgressSpec() {
        ProgressSpec spec = this.parseProgressSpec(this.progressSpec);
        if (spec.indicatorMode == IndicatorMode.console) {
            if (this.getConsoleLogLevel().isGreaterOrEqualTo(NBLogLevel.INFO)) {
                spec.indicatorMode = IndicatorMode.logonly;
            } else if (this.getCommands().stream().anyMatch(cmd -> cmd.getCmdType().equals((Object)Cmd.CmdType.script))) {
                spec.indicatorMode = IndicatorMode.logonly;
            }
        }
        return spec.toString();
    }

    private void checkLoggerConfigs(List<LoggerConfigData> configs, String configName) {
        HashSet files = new HashSet();
        configs.stream().map(LoggerConfigData::getFilename).forEach(s -> {
            if (files.contains(s)) {
                System.err.println(s + " is included in " + configName + " more than once. It will only be included in the first matching config. Reorder your options if you need to control this.");
            }
            files.add(s);
        });
    }

    public String wantsReportCsvTo() {
        return this.reportCsvTo;
    }

    public Path getLogsDirectory() {
        return Path.of(this.logsDirectory, new String[0]);
    }

    public int getLogsMax() {
        return this.logsMax;
    }

    public NBLogLevel getScenarioLogLevel() {
        return this.logsLevel;
    }

    public boolean wantsInputTypes() {
        return this.wantsInputTypes;
    }

    public String getScriptFile() {
        if (this.scriptFile == null) {
            return this.logsDirectory + File.separator + "_SESSION_.js";
        }
        Object expanded = this.scriptFile;
        if (!((String)expanded).startsWith(File.separator)) {
            expanded = this.getLogsDirectory() + File.separator + (String)expanded;
        }
        return expanded;
    }

    public boolean wantsMarkerTypes() {
        return this.wantsMarkerTypes;
    }

    public boolean wantsToDumpCyclelog() {
        return this.rleDumpOptions.length > 0;
    }

    public boolean wantsToImportCycleLog() {
        return this.cyclelogImportOptions.length > 0;
    }

    public String[] getCyclelogImportOptions() {
        return this.cyclelogImportOptions;
    }

    public String[] getCycleLogExporterOptions() {
        return this.rleDumpOptions;
    }

    public String getConsoleLoggingPattern() {
        return this.consoleLoggingPattern;
    }

    public Map<String, String> getLogLevelOverrides() {
        return this.logLevelsOverrides;
    }

    public void setHistoLoggerConfigs(String pattern, String file, String interval) {
        this.histoLoggerConfigs.add(String.format("%s:%s:%s", file, pattern, interval));
    }

    public boolean wantsScenariosList() {
        return this.wantsListScenarios;
    }

    public boolean wantsListScripts() {
        return this.wantsListScripts;
    }

    public boolean wantsToCopyResource() {
        return this.wantsToCopyWorkload != null;
    }

    public String wantsToCopyResourceNamed() {
        return this.wantsToCopyWorkload;
    }

    public boolean wantsWorkloadsList() {
        return this.wantsWorkloadsList;
    }

    public String getDockerGrafanaTag() {
        return this.docker_grafana_tag;
    }

    public String getDockerPromTag() {
        return this.docker_prom_tag;
    }

    private ProgressSpec parseProgressSpec(String interval) {
        ProgressSpec progressSpec = new ProgressSpec();
        String[] parts = interval.split(":");
        switch (parts.length) {
            case 2: {
                Unit.msFor((String)parts[1]).orElseThrow(() -> new RuntimeException("Unable to parse progress indicator indicatorSpec '" + parts[1] + "'"));
                progressSpec.intervalSpec = parts[1];
            }
            case 1: {
                progressSpec.indicatorMode = IndicatorMode.valueOf((String)parts[0]);
                break;
            }
            default: {
                throw new RuntimeException("This should never happen.");
            }
        }
        return progressSpec;
    }

    public static enum Mode {
        ParseGlobalsOnly,
        ParseAllOptions;

    }

    private static class ProgressSpec {
        public String intervalSpec;
        public IndicatorMode indicatorMode;

        private ProgressSpec() {
        }

        public String toString() {
            return this.indicatorMode.toString() + ":" + this.intervalSpec;
        }
    }

    public static class LoggerConfigData {
        public String file;
        public String pattern = ".*";
        public String interval = "30 seconds";

        public LoggerConfigData(String histoLoggerSpec) {
            String[] words = histoLoggerSpec.split(":");
            switch (words.length) {
                case 3: {
                    this.interval = words[2].isEmpty() ? this.interval : words[2];
                }
                case 2: {
                    this.pattern = words[1].isEmpty() ? this.pattern : words[1];
                }
                case 1: {
                    this.file = words[0];
                    if (!this.file.isEmpty()) break;
                    throw new RuntimeException("You must not specify an empty file here for logging data.");
                }
                default: {
                    throw new RuntimeException("--log-histograms options must be in either 'regex:filename:interval' or 'regex:filename' or 'filename' format");
                }
            }
        }

        public String getFilename() {
            return this.file;
        }
    }
}

