/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.engine.api.activityapi.core.RunState;
import io.nosqlbench.engine.api.activityimpl.ProgressAndStateMeter;
import io.nosqlbench.engine.api.metrics.IndicatorMode;
import io.nosqlbench.engine.api.metrics.PeriodicRunnable;
import io.nosqlbench.engine.api.util.Unit;
import io.nosqlbench.engine.core.lifecycle.ScenarioController;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivityProgressIndicator
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ActivityProgressIndicator.class);
    private final String indicatorSpec;
    private final ScenarioController sc;
    private PeriodicRunnable<ActivityProgressIndicator> runnable;
    private IndicatorMode indicatorMode = IndicatorMode.console;
    private final Set<String> seen = new HashSet<String>();
    private long intervalMillis = 1L;

    public ActivityProgressIndicator(ScenarioController sc, String indicatorSpec) {
        this.sc = sc;
        this.indicatorSpec = indicatorSpec;
        this.start();
    }

    public void start() {
        this.parseProgressSpec(this.indicatorSpec);
        this.runnable = new PeriodicRunnable(this.intervalMillis, (Runnable)this);
        this.runnable.startDaemonThread();
    }

    private void parseProgressSpec(String interval) {
        String[] parts = interval.split(":");
        switch (parts.length) {
            case 2: {
                this.intervalMillis = (Long)Unit.msFor((String)parts[1]).orElseThrow(() -> new RuntimeException("Unable to parse progress indicator indicatorSpec '" + parts[1] + "'"));
            }
            case 1: {
                try {
                    this.indicatorMode = IndicatorMode.valueOf((String)parts[0]);
                    break;
                }
                catch (IllegalArgumentException ie) {
                    throw new RuntimeException("No such IndicatorMode exists for --progress: choose one of console or logonly. If you need to specify an interval such as 10m, then you must use --progress logonly:10m or --progress console:10m");
                }
            }
            default: {
                throw new RuntimeException("This should never happen.");
            }
        }
    }

    @Override
    public void run() {
        List<ProgressAndStateMeter> progressMeters = this.sc.getProgressMeters();
        for (ProgressAndStateMeter meter : progressMeters) {
            boolean lastReport = false;
            if (meter.getProgressRatio() >= 1.0 || meter.getRunState() == RunState.Finished) {
                if (this.seen.contains(meter.getProgressName())) continue;
                this.seen.add(meter.getProgressName());
                lastReport = true;
            }
            String progress = meter.getProgressName() + ": " + this.formatProgress(meter.getProgressRatio()) + "/" + meter.getRunState() + " (details: " + meter.getProgressSummary() + ")" + (lastReport ? " (last report)" : "");
            switch (this.indicatorMode) {
                case console: {
                    System.out.println(progress);
                }
                case logonly: {
                    logger.info(progress);
                }
            }
        }
    }

    private String formatProgress(double progress) {
        if (Double.isNaN(progress)) {
            return "Unknown";
        }
        return String.format(Locale.US, "%3.2f%%", 100.0 * progress);
    }

    public String toString() {
        return "ProgressIndicator/" + this.indicatorSpec;
    }
}

