/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.core.lifecycle.ScenarioController;
import java.security.InvalidParameterException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Value;

public class PolyglotScenarioController {
    private static final Logger logger = LogManager.getLogger((String)"SCENARIO/POLYGLOT");
    private final ScenarioController controller;

    public PolyglotScenarioController(ScenarioController inner) {
        this.controller = inner;
    }

    public synchronized void run(Object o) {
        if (o instanceof Value) {
            this.runValue((Value)o);
        } else if (o instanceof Map) {
            this.controller.run((Map)o);
        } else if (o instanceof String) {
            this.controller.run(o.toString());
        } else {
            throw new RuntimeException("Unrecognized type: " + o.getClass().getCanonicalName());
        }
    }

    public synchronized void run(int timeout, Object o) {
        if (o instanceof Value) {
            this.runValue(timeout, (Value)o);
        } else if (o instanceof Map) {
            this.controller.run(timeout, (Map)o);
        } else if (o instanceof String) {
            this.controller.run(timeout, o.toString());
        } else {
            throw new RuntimeException("Uncrecognized type: " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void runValue(Value v) {
        this.runValue(Integer.MAX_VALUE, v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void runValue(int timeout, Value spec) {
        logger.debug("run(Value) called with:" + spec);
        if (spec.isHostObject()) {
            this.controller.run(timeout, (ActivityDef)spec.asHostObject());
            return;
        } else if (spec.isString()) {
            this.controller.run(timeout, spec.asString());
            return;
        } else if (spec.hasMembers()) {
            this.controller.run(timeout, (Map)spec.as(Map.class));
            return;
        } else {
            if (!spec.isHostObject()) throw new RuntimeException("unrecognized polyglot base type for run: " + spec.toString());
            Object o = spec.asHostObject();
            if (!(o instanceof ActivityDef)) throw new RuntimeException("unrecognized polyglot host object type for run: " + spec.toString());
            this.controller.run(timeout, (ActivityDef)o);
        }
    }

    public synchronized void start(Object o) {
        if (o instanceof Value) {
            this.startValue((Value)o);
        } else if (o instanceof Map) {
            this.controller.start((Map)o);
        } else if (o instanceof String) {
            this.controller.start(o.toString());
        } else {
            throw new RuntimeException("unrecognized type " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void startValue(Value spec) {
        if (spec.isHostObject()) {
            this.controller.start((ActivityDef)spec.asHostObject());
        } else if (spec.isString()) {
            this.controller.start(spec.asString());
        } else if (spec.hasMembers()) {
            this.controller.start((Map)spec.as(Map.class));
        } else {
            throw new RuntimeException("unknown base type for graal polyglot: " + spec.toString());
        }
    }

    public synchronized void stop(Object o) {
        if (o instanceof Value) {
            this.stopValue((Value)o);
        } else if (o instanceof Map) {
            this.controller.stop((Map)o);
        } else if (o instanceof String) {
            this.controller.stop(o.toString());
        } else {
            throw new RuntimeException("unknown type " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void stopValue(Value spec) {
        if (spec.isHostObject()) {
            this.controller.stop((ActivityDef)spec.asHostObject());
        } else if (spec.isString()) {
            this.controller.stop(spec.asString());
        } else if (spec.hasMembers()) {
            this.controller.stop((Map)spec.as(Map.class));
        } else {
            throw new RuntimeException("unknown base type for graal polyglot: " + spec.toString());
        }
    }

    public synchronized void apply(Object o) {
        if (o instanceof Value) {
            this.applyValue((Value)o);
        } else if (o instanceof Map) {
            this.controller.apply((Map)o);
        } else {
            throw new RuntimeException("unknown type: " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void applyValue(Value spec) {
        Map map = (Map)spec.as(Map.class);
        this.controller.apply(map);
    }

    public synchronized void awaitActivity(Object o) {
        this.await(o);
    }

    public synchronized void await(Object o) {
        if (o instanceof String) {
            this.controller.await(o.toString());
        } else if (o instanceof Value) {
            this.awaitValue((Value)o);
        } else if (o instanceof Map) {
            this.controller.await((Map)o);
        } else {
            throw new RuntimeException("unknown type: " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void awaitValue(Value spec) {
        if (spec.isHostObject()) {
            this.controller.await((ActivityDef)spec.asHostObject());
        } else if (spec.hasMembers()) {
            this.controller.await((Map)spec.as(Map.class));
        } else if (spec.isString()) {
            this.controller.await(spec.asString());
        } else {
            throw new RuntimeException("unable to map type for await from polyglot value: " + spec);
        }
    }

    public synchronized void waitMillis(Object o) {
        if (o instanceof Value) {
            this.waitMillisValue((Value)o);
        } else if (o instanceof Integer) {
            this.controller.waitMillis(((Integer)o).intValue());
        } else if (o instanceof Long) {
            this.controller.waitMillis((Long)o);
        } else if (o instanceof String) {
            this.controller.waitMillis(Long.parseLong((String)o));
        } else {
            throw new RuntimeException("unknown type: " + o.getClass().getCanonicalName());
        }
    }

    private synchronized void waitMillisValue(Value spec) {
        if (spec.isString()) {
            this.controller.waitMillis(Long.parseLong(spec.asString()));
        } else if (spec.isNumber()) {
            this.controller.waitMillis(spec.asLong());
        } else {
            throw new InvalidParameterException("unable to convert polyglot type " + spec.toString() + " to a long for waitMillis");
        }
    }

    public synchronized boolean isRunningActivity(Object o) {
        if (o instanceof Value) {
            return this.isRunningActivityValue((Value)o);
        }
        if (o instanceof String) {
            return this.controller.isRunningActivity(o.toString());
        }
        if (o instanceof Map) {
            return this.controller.isRunningActivity((Map)o);
        }
        throw new RuntimeException("unknown type:" + o.getClass().getCanonicalName());
    }

    private synchronized boolean isRunningActivityValue(Value spec) {
        if (spec.isHostObject()) {
            return this.controller.isRunningActivity((ActivityDef)spec.asHostObject());
        }
        if (spec.isString()) {
            return this.controller.isRunningActivity(spec.asString());
        }
        if (spec.hasMembers()) {
            return this.controller.isRunningActivity((Map)spec.as(Map.class));
        }
        throw new InvalidParameterException("unable to map type for isRunningActivity from polyglot value: " + spec);
    }
}

