/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.nb.api.errors.BasicError;
import javax.script.ScriptException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.PolyglotException;

public class ScenarioErrorHandler {
    private static final Logger logger = LogManager.getLogger(ScenarioErrorHandler.class);

    public static String handle(Throwable t, boolean wantsStackTraces) {
        if (t instanceof ScriptException) {
            return ScenarioErrorHandler.handleScriptException((ScriptException)t, wantsStackTraces);
        }
        if (t instanceof BasicError) {
            return ScenarioErrorHandler.handleBasicError((BasicError)t, wantsStackTraces);
        }
        if (t instanceof Exception) {
            return ScenarioErrorHandler.handleInternalError((Exception)t, wantsStackTraces);
        }
        throw new RuntimeException("Error in exception handler", t);
    }

    private static String handleInternalError(Exception e, boolean wantsStackTraces) {
        String prefix = "internal error: ";
        if (e.getCause() != null && !e.getCause().getClass().getCanonicalName().contains("io.nosqlbench")) {
            prefix = "Error from driver or included library: ";
        }
        if (wantsStackTraces) {
            logger.error(prefix + e.getMessage(), (Throwable)e);
            if (e.getCause() != null) {
                logger.error("cause (see stack trace for details):" + e.getCause().getMessage());
            }
        } else {
            logger.error(e.getMessage());
            logger.error("for the full stack trace, run with --show-stacktraces");
        }
        return e.getMessage();
    }

    private static String handleScriptException(ScriptException e, boolean wantsStackTraces) {
        Throwable cause = e.getCause();
        if (cause instanceof PolyglotException) {
            Throwable hostException = ((PolyglotException)cause).asHostException();
            if (hostException instanceof BasicError) {
                ScenarioErrorHandler.handleBasicError((BasicError)hostException, wantsStackTraces);
            } else {
                ScenarioErrorHandler.handle(hostException, wantsStackTraces);
            }
        } else if (wantsStackTraces) {
            logger.error("Unknown script exception:", (Throwable)e);
        } else {
            logger.error(e.getMessage());
            logger.error("for the full stack trace, run with --show-stacktraces");
        }
        return e.getMessage();
    }

    private static String handleBasicError(BasicError e, boolean wantsStackTraces) {
        if (wantsStackTraces) {
            logger.error(e.getMessage(), (Throwable)e);
        } else {
            logger.error(e.getMessage());
            logger.error("for the full stack trace, run with --show-stacktraces");
        }
        return e.getMessage();
    }
}

