/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.core.logging.Log4JMetricsReporter;
import io.nosqlbench.engine.core.metrics.NBMetricsSummary;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScenarioResult {
    private static final Logger logger = LogManager.getLogger(ScenarioResult.class);
    private final long startedAt;
    private final long endedAt;
    private Exception exception;
    private final String iolog;

    public ScenarioResult(String iolog, long startedAt, long endedAt) {
        this.iolog = iolog;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
    }

    public ScenarioResult(Exception e, long startedAt, long endedAt) {
        this.iolog = e.getMessage();
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.exception = e;
    }

    public void reportElapsedMillis() {
        logger.info("-- SCENARIO TOOK " + this.getElapsedMillis() + "ms --");
    }

    public String getSummaryReport() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)ActivityMetrics.getMetricRegistry()).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).outputTo(ps).build();
        consoleReporter.report();
        ps.flush();
        String result = os.toString(StandardCharsets.UTF_8);
        return result;
    }

    public void reportToConsole() {
        String summaryReport = this.getSummaryReport();
        System.out.println(summaryReport);
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public void rethrowIfError() {
        if (this.exception != null) {
            if (this.exception instanceof RuntimeException) {
                throw (RuntimeException)this.exception;
            }
            throw new RuntimeException(this.exception);
        }
    }

    public String getIOLog() {
        return this.iolog;
    }

    public long getElapsedMillis() {
        return this.endedAt - this.startedAt;
    }

    public void reportTo(PrintStream out) {
        out.println(this.getSummaryReport());
    }

    public void reportToLog() {
        logger.debug("-- BEGIN METRICS DETAIL --");
        Log4JMetricsReporter reporter = Log4JMetricsReporter.forRegistry(ActivityMetrics.getMetricRegistry()).withLoggingLevel(Log4JMetricsReporter.LoggingLevel.DEBUG).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).outputTo(logger).build();
        reporter.report();
        logger.debug("-- END METRICS DETAIL --");
    }

    public void reportCountsTo(PrintStream printStream) {
        StringBuilder sb = new StringBuilder();
        ActivityMetrics.getMetricRegistry().getMetrics().forEach((k, v) -> {
            Number n;
            Object value;
            if (v instanceof Counting) {
                long count = ((Counting)v).getCount();
                if (count > 0L) {
                    NBMetricsSummary.summarize(sb, k, v);
                }
            } else if (v instanceof Gauge && (value = ((Gauge)v).getValue()) != null && value instanceof Number && (n = (Number)value).doubleValue() != 0.0) {
                NBMetricsSummary.summarize(sb, k, v);
            }
        });
        printStream.println("-- BEGIN NON-ZERO metric counts (run longer for full report):");
        printStream.print(sb.toString());
        printStream.println("-- END NON-ZERO metric counts:");
    }
}

