/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.engine.core.lifecycle.ScenarioResult;
import io.nosqlbench.engine.core.script.Scenario;
import io.nosqlbench.engine.core.script.ScenariosExecutor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScenariosResults {
    private static final Logger logger = LogManager.getLogger(ScenariosResults.class);
    private final String scenariosExecutorName;
    private final Map<Scenario, ScenarioResult> scenarioResultMap = new LinkedHashMap<Scenario, ScenarioResult>();

    public ScenariosResults(ScenariosExecutor scenariosExecutor) {
        this.scenariosExecutorName = scenariosExecutor.getName();
    }

    public ScenariosResults(ScenariosExecutor scenariosExecutor, Map<Scenario, ScenarioResult> map) {
        this.scenariosExecutorName = scenariosExecutor.getName();
        this.scenarioResultMap.putAll(map);
    }

    public String getExecutionSummary() {
        StringBuilder sb = new StringBuilder("executions: ");
        sb.append(this.scenarioResultMap.size()).append(" scenarios, ");
        sb.append(this.scenarioResultMap.values().stream().filter(r -> r.getException().isEmpty()).count()).append(" normal, ");
        sb.append(this.scenarioResultMap.values().stream().filter(r -> r.getException().isPresent()).count()).append(" errored");
        return sb.toString();
    }

    public ScenarioResult getOne() {
        if (this.scenarioResultMap.size() != 1) {
            throw new RuntimeException("getOne found " + this.scenarioResultMap.size() + " results instead of 1.");
        }
        return this.scenarioResultMap.values().stream().findFirst().orElseThrow(() -> new RuntimeException("Missing result."));
    }

    public void reportToLog() {
        for (Map.Entry<Scenario, ScenarioResult> entry : this.scenarioResultMap.entrySet()) {
            Scenario scenario = entry.getKey();
            ScenarioResult oresult = entry.getValue();
            logger.info("results for scenario: " + scenario);
            if (oresult != null) {
                oresult.reportElapsedMillis();
                continue;
            }
            logger.error(scenario.getScenarioName() + ": incomplete (missing result)");
        }
    }

    public boolean hasError() {
        return this.scenarioResultMap.values().stream().anyMatch(r -> r.getException().isPresent());
    }
}

