/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.script;

import com.codahale.metrics.MetricRegistry;
import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import io.nosqlbench.engine.api.extensions.ScriptingPluginInfo;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.api.scripting.ScriptEnvBuffer;
import io.nosqlbench.engine.core.annotation.Annotators;
import io.nosqlbench.engine.core.lifecycle.ActivityProgressIndicator;
import io.nosqlbench.engine.core.lifecycle.PolyglotScenarioController;
import io.nosqlbench.engine.core.lifecycle.ScenarioController;
import io.nosqlbench.engine.core.lifecycle.ScenarioResult;
import io.nosqlbench.engine.core.metrics.PolyglotMetricRegistryBindings;
import io.nosqlbench.engine.core.script.NashornActivityBindings;
import io.nosqlbench.engine.core.script.SandboxExtensionFinder;
import io.nosqlbench.engine.core.script.ScenarioContext;
import io.nosqlbench.engine.core.script.ScenarioShutdownHook;
import io.nosqlbench.engine.core.script.ScriptParams;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Layer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;

public class Scenario
implements Callable<ScenarioResult> {
    private final String commandLine;
    private final String reportSummaryTo;
    private final Path logsPath;
    private Logger logger = LogManager.getLogger((String)"SCENARIO");
    private State state = State.Scheduled;
    private volatile ScenarioShutdownHook scenarioShutdownHook;
    private Exception error;
    private static final ScriptEngineManager engineManager = new ScriptEngineManager();
    private final List<String> scripts = new ArrayList<String>();
    private ScriptEngine scriptEngine;
    private ScenarioController scenarioController;
    private ActivityProgressIndicator activityProgressIndicator;
    private String progressInterval = "console:1m";
    private boolean wantsGraaljsCompatMode;
    private ScenarioContext scriptEnv;
    private final String scenarioName;
    private ScriptParams scenarioScriptParams;
    private String scriptfile;
    private Engine engine = Engine.Graalvm;
    private boolean wantsStackTraces = false;
    private boolean wantsCompiledScript;
    private long startedAtMillis = -1L;
    private long endedAtMillis = -1L;

    public Scenario(String scenarioName, String scriptfile, Engine engine, String progressInterval, boolean wantsGraaljsCompatMode, boolean wantsStackTraces, boolean wantsCompiledScript, String reportSummaryTo, String commandLine, Path logsPath) {
        this.scenarioName = scenarioName;
        this.scriptfile = scriptfile;
        this.engine = engine;
        this.progressInterval = progressInterval;
        this.wantsGraaljsCompatMode = wantsGraaljsCompatMode;
        this.wantsStackTraces = wantsStackTraces;
        this.wantsCompiledScript = wantsCompiledScript;
        this.reportSummaryTo = reportSummaryTo;
        this.commandLine = commandLine;
        this.logsPath = logsPath;
    }

    public Scenario(String name, Engine engine, String reportSummaryTo) {
        this.scenarioName = name;
        this.reportSummaryTo = reportSummaryTo;
        this.engine = engine;
        this.commandLine = "";
        this.logsPath = Path.of("logs", new String[0]);
    }

    public Scenario setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Scenario addScriptText(String scriptText) {
        this.scripts.add(scriptText);
        return this;
    }

    public Scenario addScriptFiles(String ... args) {
        for (String scriptFile : args) {
            Path scriptPath = Paths.get(scriptFile, new String[0]);
            byte[] bytes = new byte[]{};
            try {
                bytes = Files.readAllBytes(scriptPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            Charset utf8 = StandardCharsets.UTF_8;
            String scriptData = utf8.decode(bb).toString();
            this.addScriptText(scriptData);
        }
        return this;
    }

    private void init() {
        this.logger.debug("Using engine " + this.engine.toString());
        MetricRegistry metricRegistry = ActivityMetrics.getMetricRegistry();
        switch (this.engine) {
            case Nashorn: {
                throw new RuntimeException("The nashorn engine has been deprecated in this version of NoSQLBench.");
            }
            case Graalvm: {
                Context.Builder contextSettings = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).allowNativeAccess(true).allowCreateThread(true).allowIO(true).allowHostClassLookup(s -> true).allowHostClassLoading(true).allowCreateProcess(true).allowAllAccess(true).allowEnvironmentAccess(EnvironmentAccess.INHERIT).allowPolyglotAccess(PolyglotAccess.ALL).option("js.ecmascript-version", "2020").option("js.nashorn-compat", "true");
                this.scriptEngine = GraalJSScriptEngine.create(null, (Context.Builder)contextSettings);
            }
        }
        this.scenarioController = new ScenarioController(this.scenarioName);
        if (!this.progressInterval.equals("disabled")) {
            this.activityProgressIndicator = new ActivityProgressIndicator(this.scenarioController, this.progressInterval);
        }
        this.scriptEnv = new ScenarioContext(this.scenarioController);
        this.scriptEngine.setContext((ScriptContext)((Object)this.scriptEnv));
        this.scriptEngine.put("params", this.scenarioScriptParams);
        if (this.engine == Engine.Graalvm) {
            if (this.wantsGraaljsCompatMode) {
                this.scriptEngine.put("scenario", this.scenarioController);
                this.scriptEngine.put("metrics", new PolyglotMetricRegistryBindings(metricRegistry));
                this.scriptEngine.put("activities", new NashornActivityBindings(this.scenarioController));
            } else {
                this.scriptEngine.put("scenario", new PolyglotScenarioController(this.scenarioController));
                this.scriptEngine.put("metrics", new PolyglotMetricRegistryBindings(metricRegistry));
                this.scriptEngine.put("activities", new NashornActivityBindings(this.scenarioController));
            }
        } else {
            if (this.engine == Engine.Nashorn) {
                throw new RuntimeException("The Nashorn engine has been deprecated in this version of NoSQLBench.");
            }
            throw new RuntimeException("Unsupported engine: " + this.engine);
        }
        for (ScriptingPluginInfo<?> extensionDescriptor : SandboxExtensionFinder.findAll()) {
            if (!extensionDescriptor.isAutoLoading()) {
                this.logger.info("Not loading " + extensionDescriptor + ", autoloading is false");
                continue;
            }
            Logger extensionLogger = LogManager.getLogger((String)("extensions." + extensionDescriptor.getBaseVariableName()));
            Object extensionObject = extensionDescriptor.getExtensionObject(extensionLogger, metricRegistry, (ScriptContext)((Object)this.scriptEnv));
            this.logger.trace("Adding extension object:  name=" + extensionDescriptor.getBaseVariableName() + " class=" + extensionObject.getClass().getSimpleName());
            this.scriptEngine.put(extensionDescriptor.getBaseVariableName(), extensionObject);
        }
    }

    public void runScenario() {
        this.scenarioShutdownHook = new ScenarioShutdownHook(this);
        Runtime.getRuntime().addShutdownHook(this.scenarioShutdownHook);
        this.state = State.Running;
        this.startedAtMillis = System.currentTimeMillis();
        Annotators.recordAnnotation(Annotation.newBuilder().session(this.scenarioName).now().layer(Layer.Scenario).detail("engine", this.engine.toString()).build());
        this.init();
        this.logger.debug("Running control script for " + this.getScenarioName() + ".");
        for (String script : this.scripts) {
            try {
                Object result = null;
                if (this.scriptEngine instanceof Compilable && this.wantsCompiledScript) {
                    this.logger.debug("Using direct script compilation");
                    Compilable compilableEngine = (Compilable)((Object)this.scriptEngine);
                    CompiledScript compiled = compilableEngine.compile(script);
                    this.logger.debug("-> invoking main scenario script (compiled)");
                    result = compiled.eval();
                    this.logger.debug("<- scenario completed (compiled)");
                } else if (this.scriptfile != null && !this.scriptfile.isEmpty()) {
                    String filename = this.scriptfile.replace("_SESSION_", this.scenarioName);
                    this.logger.debug("-> invoking main scenario script (interpreted from " + filename + ")");
                    Path written = Files.write(Path.of(filename, new String[0]), script.getBytes(StandardCharsets.UTF_8), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                    BufferedReader reader = Files.newBufferedReader(written);
                    this.scriptEngine.eval(reader);
                    this.logger.debug("<- scenario completed (interpreted from " + filename + ")");
                } else {
                    this.logger.debug("-> invoking main scenario script (interpreted)");
                    result = this.scriptEngine.eval(script);
                    this.logger.debug("<- scenario completed (interpreted)");
                }
                if (result != null) {
                    this.logger.debug("scenario result: type(" + result.getClass().getCanonicalName() + "): value:" + result.toString());
                }
                System.err.flush();
                System.out.flush();
            }
            catch (Exception e) {
                this.state = State.Errored;
                this.logger.warn("Error in scenario, shutting down.");
                this.scenarioController.forceStopScenario(5000, false);
                this.error = e;
                throw new RuntimeException(e);
            }
            finally {
                System.out.flush();
                System.err.flush();
                this.endedAtMillis = System.currentTimeMillis();
            }
        }
        int awaitCompletionTime = 1471228928;
        this.logger.debug("Awaiting completion of scenario for " + awaitCompletionTime + " millis.");
        this.scenarioController.awaitCompletion(awaitCompletionTime);
        Runtime.getRuntime().removeShutdownHook(this.scenarioShutdownHook);
        this.scenarioShutdownHook = null;
        this.finish();
    }

    public void finish() {
        this.logger.debug("finishing scenario");
        this.endedAtMillis = System.currentTimeMillis();
        if (this.state == State.Running) {
            this.state = State.Finished;
        }
        if (this.scenarioShutdownHook != null) {
            this.state = State.Interrupted;
            this.logger.warn("Scenario was interrupted by process exit, shutting down");
        }
        this.logger.info("scenario state: " + this.state);
        Annotation annotation = Annotation.newBuilder().session(this.scenarioName).interval(this.startedAtMillis, this.endedAtMillis).layer(Layer.Scenario).label("state", this.state.toString()).detail("command_line", this.commandLine).build();
        Annotators.recordAnnotation(annotation);
    }

    public long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    public long getEndedAtMillis() {
        return this.endedAtMillis;
    }

    @Override
    public ScenarioResult call() {
        this.runScenario();
        String iolog = this.scriptEnv.getTimedLog();
        ScenarioResult result = new ScenarioResult(iolog, this.startedAtMillis, this.endedAtMillis);
        result.reportToLog();
        this.doReportSummaries(this.reportSummaryTo, result);
        return result;
    }

    private void doReportSummaries(String reportSummaryTo, ScenarioResult result) {
        String[] destinationSpecs;
        ArrayList<PrintStream> fullChannels = new ArrayList<PrintStream>();
        ArrayList<PrintStream> briefChannels = new ArrayList<PrintStream>();
        for (String spec : destinationSpecs = reportSummaryTo.split(", *")) {
            if (spec == null || spec.isBlank()) continue;
            String[] split = spec.split(":", 2);
            String summaryTo = split[0];
            long summaryWhen = split.length == 2 ? Long.parseLong(split[1]) * 1000L : 0L;
            PrintStream out = null;
            switch (summaryTo.toLowerCase()) {
                case "console": 
                case "stdout": {
                    out = System.out;
                    break;
                }
                case "stderr": {
                    out = System.err;
                    break;
                }
                default: {
                    String outName = summaryTo.replaceAll("_SESSION_", this.getScenarioName()).replaceAll("_LOGS_", this.logsPath.toString());
                    try {
                        out = new PrintStream(new FileOutputStream(outName));
                        break;
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (result.getElapsedMillis() > summaryWhen) {
                fullChannels.add(out);
                continue;
            }
            this.logger.debug("Summarizing counting metrics only to " + spec + " with scenario duration of " + summaryWhen + "ms (<" + summaryWhen + ")");
            briefChannels.add(out);
        }
        fullChannels.forEach(result::reportTo);
        briefChannels.forEach(result::reportCountsTo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scenario scenario = (Scenario)o;
        return this.getScenarioName() != null ? this.getScenarioName().equals(scenario.getScenarioName()) : scenario.getScenarioName() == null;
    }

    public int hashCode() {
        return this.getScenarioName() != null ? this.getScenarioName().hashCode() : 0;
    }

    public String getScenarioName() {
        return this.scenarioName;
    }

    public ScenarioController getScenarioController() {
        return this.scenarioController;
    }

    public String getScriptText() {
        return this.scripts.stream().collect(Collectors.joining());
    }

    public Optional<List<String>> getIOLog() {
        return Optional.ofNullable(this.scriptEnv).map(ScriptEnvBuffer::getTimeLogLines);
    }

    public String toString() {
        return "name:'" + this.getScenarioName() + "'";
    }

    public void addScenarioScriptParams(ScriptParams scenarioScriptParams) {
        this.scenarioScriptParams = scenarioScriptParams;
    }

    public void addScenarioScriptParams(final Map<String, String> scriptParams) {
        this.addScenarioScriptParams(new ScriptParams(){
            {
                this.putAll(scriptParams);
            }
        });
    }

    public State getScenarioState() {
        return this.state;
    }

    public void enableCharting() {
        MetricRegistry metricRegistry = ActivityMetrics.getMetricRegistry();
    }

    public String getReportSummaryTo() {
        return this.reportSummaryTo;
    }

    public static enum State {
        Scheduled,
        Running,
        Errored,
        Interrupted,
        Finished;

    }

    public static enum Engine {
        Graalvm,
        Nashorn;

    }
}

