/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.script;

import io.nosqlbench.engine.core.lifecycle.IndexedThreadFactory;
import io.nosqlbench.engine.core.lifecycle.ScenarioController;
import io.nosqlbench.engine.core.lifecycle.ScenarioResult;
import io.nosqlbench.engine.core.lifecycle.ScenariosResults;
import io.nosqlbench.engine.core.script.Scenario;
import io.nosqlbench.engine.core.script.ScenarioExceptionHandler;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScenariosExecutor {
    private final Logger logger = LogManager.getLogger((String)"SCENARIOS");
    private final LinkedHashMap<String, SubmittedScenario> submitted = new LinkedHashMap();
    private final ExecutorService executor;
    private final String name;
    private RuntimeException stoppingException;

    public ScenariosExecutor(String name) {
        this(name, 1);
    }

    public ScenariosExecutor(String name, int threads) {
        this.executor = new ThreadPoolExecutor(1, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IndexedThreadFactory("scenarios", new ScenarioExceptionHandler(this)));
        this.name = name;
    }

    public synchronized void execute(Scenario scenario) {
        if (this.submitted.get(scenario.getScenarioName()) != null) {
            throw new BasicError("Scenario " + scenario.getScenarioName() + " is already defined. Remove it first to reuse the name.");
        }
        Future<ScenarioResult> future = this.executor.submit(scenario);
        SubmittedScenario s = new SubmittedScenario(scenario, future);
        this.submitted.put(s.getName(), s);
    }

    public String toString() {
        return super.toString();
    }

    public ScenariosResults awaitAllResults() {
        return this.awaitAllResults(0x3FFFFFFFFFFFFFFFL, 60000L);
    }

    public ScenariosResults awaitAllResults(long timeout, long updateInterval) {
        if (updateInterval > timeout) {
            throw new BasicError("timeout must be equal to or greater than updateInterval");
        }
        long timeoutAt = System.currentTimeMillis() + timeout;
        this.executor.shutdown();
        boolean isShutdown = false;
        while (!isShutdown && System.currentTimeMillis() < timeoutAt) {
            long waitedAt = System.currentTimeMillis();
            long updateAt = Math.min(timeoutAt, waitedAt + updateInterval);
            while (!isShutdown && System.currentTimeMillis() < timeoutAt) {
                while (!isShutdown && System.currentTimeMillis() < updateAt) {
                    try {
                        long timeRemaining = updateAt - System.currentTimeMillis();
                        isShutdown = this.executor.awaitTermination(timeRemaining, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                updateAt = Math.min(timeoutAt, System.currentTimeMillis() + updateInterval);
            }
            this.logger.debug("scenarios executor shutdown after " + (System.currentTimeMillis() - waitedAt) + "ms.");
        }
        if (!isShutdown) {
            throw new RuntimeException("executor still runningScenarios after awaiting all results for " + timeout + "ms.  isTerminated:" + this.executor.isTerminated() + " isShutdown:" + this.executor.isShutdown());
        }
        LinkedHashMap<Scenario, ScenarioResult> scenarioResultMap = new LinkedHashMap<Scenario, ScenarioResult>();
        this.getAsyncResultStatus().entrySet().forEach(es -> scenarioResultMap.put((Scenario)es.getKey(), (ScenarioResult)((Optional)es.getValue()).orElseGet(null)));
        return new ScenariosResults(this, scenarioResultMap);
    }

    public List<String> getPendingScenarios() {
        return new ArrayList<String>(this.submitted.values().stream().map(SubmittedScenario::getName).collect(Collectors.toCollection(ArrayList::new)));
    }

    public Map<Scenario, Optional<ScenarioResult>> getAsyncResultStatus() {
        LinkedHashMap<Scenario, Optional<ScenarioResult>> optResults = new LinkedHashMap<Scenario, Optional<ScenarioResult>>();
        for (SubmittedScenario submittedScenario : this.submitted.values()) {
            Future<ScenarioResult> resultFuture = submittedScenario.getResultFuture();
            Optional<Object> oResult = Optional.empty();
            if (resultFuture.isDone()) {
                try {
                    oResult = Optional.of(resultFuture.get());
                }
                catch (Exception e) {
                    long now = System.currentTimeMillis();
                    oResult = Optional.of(new ScenarioResult(e, now, now));
                }
            }
            optResults.put(submittedScenario.getScenario(), oResult);
        }
        return optResults;
    }

    public Optional<Scenario> getPendingScenario(String scenarioName) {
        return Optional.ofNullable(this.submitted.get(scenarioName)).map(SubmittedScenario::getScenario);
    }

    public Optional<ScenarioResult> getPendingResult(String scenarioName) {
        Future<ScenarioResult> resultFuture1 = this.submitted.get((Object)scenarioName).resultFuture;
        if (resultFuture1 == null) {
            throw new BasicError("Unknown scenario name:" + scenarioName);
        }
        long now = System.currentTimeMillis();
        if (resultFuture1.isDone()) {
            try {
                return Optional.ofNullable(resultFuture1.get());
            }
            catch (Exception e) {
                return Optional.of(new ScenarioResult(e, now, now));
            }
        }
        if (resultFuture1.isCancelled()) {
            return Optional.of(new ScenarioResult(new Exception("result was cancelled."), now, now));
        }
        return Optional.empty();
    }

    public synchronized void stopScenario(String scenarioName) {
        this.stopScenario(scenarioName, false);
    }

    public synchronized void stopScenario(String scenarioName, boolean rethrow) {
        Optional<Scenario> pendingScenario = this.getPendingScenario(scenarioName);
        if (pendingScenario.isPresent()) {
            ScenarioController controller = pendingScenario.get().getScenarioController();
            if (controller != null) {
                controller.forceStopScenario(0, rethrow);
            }
        } else {
            throw new RuntimeException("Unable to cancel scenario: " + scenarioName + ": not found");
        }
    }

    public synchronized void deleteScenario(String scenarioName) {
        this.stopScenario(scenarioName, false);
        Optional<Scenario> pendingScenario = this.getPendingScenario(scenarioName);
        if (!pendingScenario.isPresent()) {
            throw new RuntimeException("Unable to cancel scenario: " + scenarioName + ": not found");
        }
        this.submitted.remove(scenarioName);
        this.logger.info("cancelled scenario " + scenarioName);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void notifyException(Thread t, Throwable e) {
        this.stoppingException = new RuntimeException("Error in scenario thread " + t.getName(), e);
    }

    private static class SubmittedScenario {
        private final Scenario scenario;
        private final Future<ScenarioResult> resultFuture;

        SubmittedScenario(Scenario scenario, Future<ScenarioResult> resultFuture) {
            this.scenario = scenario;
            this.resultFuture = resultFuture;
        }

        public Scenario getScenario() {
            return this.scenario;
        }

        Future<ScenarioResult> getResultFuture() {
            return this.resultFuture;
        }

        public String getName() {
            return this.scenario.getScenarioName();
        }
    }
}

