/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.annotation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Annotator;
import io.nosqlbench.nb.api.config.standard.ConfigLoader;
import io.nosqlbench.nb.api.config.standard.NBConfigurable;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.NBMapConfigurable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Annotators {
    private static final Logger logger = LogManager.getLogger((String)"ANNOTATORS");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static List<Annotator> annotators;

    public static synchronized void init(String annotatorsConfig) {
        ConfigLoader loader = new ConfigLoader();
        annotators = new ArrayList<Annotator>();
        LinkedHashMap<String, ServiceLoader.Provider<Annotator>> providers = Annotators.getProviders();
        List configs = loader.load((CharSequence)annotatorsConfig, Map.class);
        if (configs != null) {
            for (Map cmap : configs) {
                Object typeObj = cmap.remove("type");
                String typename = typeObj.toString();
                ServiceLoader.Provider<Annotator> annotatorProvider = providers.get(typename);
                if (annotatorProvider == null) {
                    throw new RuntimeException("Annotation provider with selector '" + typename + "' was not found.");
                }
                Annotator annotator = annotatorProvider.get();
                if (annotator instanceof NBMapConfigurable) {
                    NBMapConfigurable NBMapConfigurable2 = (NBMapConfigurable)annotator;
                    NBMapConfigurable2.applyConfig(cmap);
                }
                if (annotator instanceof NBConfigurable) {
                    NBConfigurable nbConfigurable = (NBConfigurable)annotator;
                    NBConfiguration cfg = nbConfigurable.getConfigModel().apply(cmap);
                    nbConfigurable.applyConfig(cfg);
                }
                annotators.add(annotator);
            }
        }
        logger.debug("Initialized " + annotators.size() + " annotators, since the configuration is empty.");
    }

    private static List<Annotator> getAnnotators() {
        if (annotators != null) {
            return annotators;
        }
        logger.debug("Annotations are bypassed as no annotators were configured.");
        return List.of();
    }

    private static synchronized LinkedHashMap<String, ServiceLoader.Provider<Annotator>> getProviders() {
        ServiceLoader<Annotator> loader = ServiceLoader.load(Annotator.class);
        LinkedHashMap<String, ServiceLoader.Provider<Annotator>> providers = new LinkedHashMap<String, ServiceLoader.Provider<Annotator>>();
        loader.stream().forEach(provider -> {
            Class type = provider.type();
            if (!type.isAnnotationPresent(Service.class)) {
                throw new RuntimeException("Annotator services must be annotated with distinct selectors\nsuch as @Service(Annotator.class,selector=\"myimpl42\")");
            }
            Service service = type.getAnnotation(Service.class);
            providers.put(service.selector(), (ServiceLoader.Provider<Annotator>)provider);
        });
        return providers;
    }

    public static synchronized void recordAnnotation(Annotation annotation) {
        for (Annotator annotator : Annotators.getAnnotators()) {
            try {
                logger.trace("calling annotator " + annotator.getClass().getAnnotation(Service.class).selector());
                annotator.recordAnnotation(annotation);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

