/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityType;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.uniform.DriverAdapter;
import io.nosqlbench.engine.api.activityimpl.uniform.StandardActivityType;
import io.nosqlbench.nb.api.NBEnvironment;
import io.nosqlbench.nb.api.config.standard.ConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigurable;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.Param;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.spi.SimpleServiceLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActivityTypeLoader {
    private static final Logger logger = LogManager.getLogger(ActivityTypeLoader.class);
    private static final SimpleServiceLoader<ActivityType> ACTIVITYTYPE_SPI_FINDER = new SimpleServiceLoader(ActivityType.class);
    private static final SimpleServiceLoader<DriverAdapter> DRIVERADAPTER_SPI_FINDER = new SimpleServiceLoader(DriverAdapter.class);
    private final Set<URL> jarUrls = new HashSet<URL>();
    private static final NBConfigModel ACTIVITY_CFG_MODEL = ConfigModel.of(Activity.class, (Param[])new Param[0]).add(Param.optional((String)"threads").setRegex("\\d+|\\d+x|auto")).add(Param.optional(List.of("workload", "yaml"))).add(Param.optional((String)"cycles")).add(Param.optional((String)"alias")).add(Param.optional(List.of("cyclerate", "rate"))).add(Param.optional((String)"tags")).asReadOnly();

    public ActivityTypeLoader() {
        List libpaths = NBEnvironment.INSTANCE.interpolateEach((CharSequence)":", "$NBLIBDIR");
        Set<URL> urlsToAdd = new HashSet<URL>();
        for (String libpaths_entry : libpaths) {
            Path libpath = Path.of(libpaths_entry, new String[0]);
            if (Files.isDirectory(libpath, new LinkOption[0])) {
                urlsToAdd = this.addLibDir(urlsToAdd, libpath);
                continue;
            }
            if (Files.isRegularFile(libpath, new LinkOption[0]) && libpath.toString().toLowerCase().endsWith(".zip")) {
                urlsToAdd = this.addZipDir(urlsToAdd, libpath);
                continue;
            }
            if (!Files.isRegularFile(libpath, new LinkOption[0]) || !libpath.toString().toLowerCase().endsWith(".jar")) continue;
            urlsToAdd = this.addJarFile(urlsToAdd, libpath);
        }
        this.extendClassLoader(urlsToAdd);
    }

    private synchronized void extendClassLoader(String ... paths) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String path : paths) {
            URL url = null;
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            urls.add(url);
        }
        this.extendClassLoader(urls);
    }

    private synchronized void extendClassLoader(Set<URL> urls) {
        HashSet<URL> newUrls = new HashSet<URL>();
        if (!this.jarUrls.containsAll(urls)) {
            for (URL url : urls) {
                if (this.jarUrls.contains(url)) continue;
                newUrls.add(url);
                this.jarUrls.add(url);
            }
            URL[] newUrlAry = newUrls.toArray(new URL[0]);
            URLClassLoader ucl = URLClassLoader.newInstance(newUrlAry, Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(ucl);
            logger.debug("Extended class loader layering with " + newUrls);
        } else {
            logger.debug("All URLs specified were already in a class loader.");
        }
    }

    private Set<URL> addJarFile(Set<URL> urls, Path libpath) {
        try {
            urls.add(libpath.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }

    private Set<URL> addZipDir(Set<URL> urlsToAdd, Path libpath) {
        return urlsToAdd;
    }

    private Set<URL> addLibDir(Set<URL> urlsToAdd, Path libpath) {
        Set urls = NBIO.local().prefix(new String[]{libpath.toString()}).extension(new String[]{".jar"}).list().stream().map(Content::getURL).collect(Collectors.toSet());
        urlsToAdd.addAll(urls);
        return urlsToAdd;
    }

    public Optional<ActivityType> load(ActivityDef activityDef) {
        String driverName = (String)activityDef.getParams().getOptionalString(new String[]{"driver", "type"}).orElseThrow(() -> new BasicError("The parameter 'driver=' is required."));
        activityDef.getParams().getOptionalString(new String[]{"jar"}).map(jar -> {
            Set urls = NBIO.local().search(new String[]{jar}).list().stream().map(Content::getURL).collect(Collectors.toSet());
            return urls;
        }).ifPresent(this::extendClassLoader);
        return this.getDriverAdapter(driverName, activityDef).or(() -> ACTIVITYTYPE_SPI_FINDER.getOptionally(driverName));
    }

    private Optional<ActivityType> getDriverAdapter(String activityTypeName, ActivityDef activityDef) {
        Optional oda = DRIVERADAPTER_SPI_FINDER.getOptionally(activityTypeName);
        if (oda.isPresent()) {
            DriverAdapter driverAdapter = (DriverAdapter)oda.get();
            activityDef.getParams().remove((Object)"driver");
            if (driverAdapter instanceof NBConfigurable) {
                NBConfigModel cfgModel = ((NBConfigurable)driverAdapter).getConfigModel();
                cfgModel = cfgModel.add(ACTIVITY_CFG_MODEL);
                NBConfiguration cfg = cfgModel.apply((Map)activityDef.getParams());
                ((NBConfigurable)driverAdapter).applyConfig(cfg);
            }
            StandardActivityType activityType = new StandardActivityType(driverAdapter, activityDef);
            return Optional.of(activityType);
        }
        return Optional.empty();
    }

    public Set<String> getAllSelectors() {
        List allSelectors = ACTIVITYTYPE_SPI_FINDER.getAllSelectors(new Pattern[0]);
        List allDrivers = DRIVERADAPTER_SPI_FINDER.getAllSelectors(new Pattern[0]);
        HashSet<String> all = new HashSet<String>();
        all.addAll(allSelectors);
        all.addAll(allDrivers);
        return all;
    }
}

