/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.lifecycle;

import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityType;
import io.nosqlbench.engine.api.activityapi.core.RunState;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ParameterMap;
import io.nosqlbench.engine.api.activityimpl.ProgressAndStateMeter;
import io.nosqlbench.engine.api.activityimpl.input.StateCapable;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.core.annotation.Annotators;
import io.nosqlbench.engine.core.lifecycle.ActivityExecutor;
import io.nosqlbench.engine.core.lifecycle.ActivityFinisher;
import io.nosqlbench.engine.core.lifecycle.ActivityTypeLoader;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Layer;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.PrintStream;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScenarioController {
    private static final Logger logger = LogManager.getLogger(ScenarioController.class);
    private static final Logger scenariologger = LogManager.getLogger((String)"SCENARIO");
    private final Map<String, ActivityExecutor> activityExecutors = new ConcurrentHashMap<String, ActivityExecutor>();
    private final String sessionId;

    public ScenarioController(String sessionId) {
        this.sessionId = sessionId;
    }

    public synchronized void start(ActivityDef activityDef) {
        Annotators.recordAnnotation(Annotation.newBuilder().session(this.sessionId).now().layer(Layer.Activity).label("alias", activityDef.getAlias()).detail("command", "start").detail("params", activityDef.toString()).build());
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, true);
        scenariologger.debug("START " + activityDef.getAlias());
        activityExecutor.startActivity();
    }

    public synchronized void start(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.start(ad);
    }

    public synchronized void start(String alias) {
        this.start(ActivityDef.parseActivityDef((String)alias));
    }

    public synchronized void run(int timeout, Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.run(timeout, ad);
    }

    public synchronized void run(int timeout, ActivityDef activityDef) {
        Annotators.recordAnnotation(Annotation.newBuilder().session(this.sessionId).now().layer(Layer.Activity).label("alias", activityDef.getAlias()).detail("command", "run").detail("params", activityDef.toString()).build());
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, true);
        scenariologger.debug("RUN alias=" + activityDef.getAlias());
        scenariologger.debug(" (RUN/START) alias=" + activityDef.getAlias());
        activityExecutor.startActivity();
        scenariologger.debug(" (RUN/AWAIT before) alias=" + activityDef.getAlias());
        boolean completed = activityExecutor.awaitCompletion(timeout);
        scenariologger.debug(" (RUN/AWAIT after) completed=" + activityDef.getAlias());
    }

    public synchronized void run(int timeout, String activityDefString) {
        ActivityDef activityDef = ActivityDef.parseActivityDef((String)activityDefString);
        this.run(timeout, activityDef);
    }

    public synchronized void run(Map<String, String> activityDefMap) {
        this.run(Integer.MAX_VALUE, activityDefMap);
    }

    public synchronized void run(String activityDefString) {
        this.run(Integer.MAX_VALUE, activityDefString);
    }

    public synchronized void run(ActivityDef activityDef) {
        this.run(Integer.MAX_VALUE, activityDef);
    }

    public boolean isRunningActivity(String alias) {
        return this.isRunningActivity(this.aliasToDef(alias));
    }

    public boolean isRunningActivity(ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        return activityExecutor != null && activityExecutor.isRunning();
    }

    public boolean isRunningActivity(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        return this.isRunningActivity(ad);
    }

    public synchronized void stop(ActivityDef activityDef) {
        Annotators.recordAnnotation(Annotation.newBuilder().session(this.sessionId).now().layer(Layer.Activity).label("alias", activityDef.getAlias()).detail("command", "stop").detail("params", activityDef.toString()).build());
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        if (activityExecutor == null) {
            throw new RuntimeException("could not stop missing activity:" + activityDef);
        }
        RunState runstate = activityExecutor.getActivity().getRunState();
        if (runstate != RunState.Running) {
            logger.warn("NOT stopping activity '" + activityExecutor.getActivity().getAlias() + "' because it is in state '" + runstate + "'");
            return;
        }
        scenariologger.debug("STOP " + activityDef.getAlias());
        activityExecutor.stopActivity();
    }

    public synchronized void stop(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        this.stop(ad);
    }

    public synchronized void stop(String spec) {
        logger.debug("request->STOP '" + spec + "'");
        List<String> aliases = Arrays.asList(spec.split("[,; ]"));
        List matched = aliases.stream().map(String::trim).filter(s -> !s.isEmpty()).flatMap(aspec -> this.getMatchingAliases((String)aspec).stream()).collect(Collectors.toList());
        for (String alias : matched) {
            ActivityDef adef = this.aliasToDef(alias);
            scenariologger.debug("STOP " + adef.getAlias());
            this.stop(adef);
        }
    }

    public synchronized void modify(String alias, String param, String value) {
        if (param.equals("alias")) {
            throw new InvalidParameterException("It is not allowed to change the name of an existing activity.");
        }
        ActivityExecutor activityExecutor = this.getActivityExecutor(alias);
        ParameterMap params = activityExecutor.getActivityDef().getParams();
        scenariologger.debug("SET (" + alias + "/" + param + ")=(" + value + ")");
        params.set(param, (Object)value);
    }

    public synchronized void apply(Map<String, String> appliedParams) {
        String alias = appliedParams.get("alias");
        if (alias == null) {
            throw new BasicError("alias must be provided");
        }
        ActivityExecutor executor = this.activityExecutors.get(alias);
        if (executor == null) {
            logger.info("started scenario from apply:" + alias);
            this.start(appliedParams);
            return;
        }
        ParameterMap previousMap = executor.getActivityDef().getParams();
        for (String paramName : appliedParams.keySet()) {
            String appliedVal = appliedParams.get(paramName);
            Optional prevVal = previousMap.getOptionalString(new String[]{paramName});
            if (prevVal.isPresent() && ((String)prevVal.get()).equals(appliedVal)) continue;
            logger.info("applying new value to activity '" + alias + "': '" + (String)prevVal.get() + "' -> '" + appliedVal + "'");
            previousMap.set(paramName, (Object)appliedVal);
        }
    }

    private ActivityExecutor getActivityExecutor(String activityAlias) {
        Optional<ActivityExecutor> executor = Optional.ofNullable(this.activityExecutors.get(activityAlias));
        return executor.orElseThrow(() -> new RuntimeException("ActivityExecutor for alias " + activityAlias + " not found."));
    }

    private List<String> getMatchingAliases(String pattern) {
        if (pattern.matches("[a-zA-Z_][a-zA-Z0-9_.]*")) {
            Pattern matcher = Pattern.compile("^" + pattern + "$");
        } else {
            Pattern matcher = Pattern.compile(pattern);
        }
        List<String> matching = this.activityExecutors.keySet().stream().filter(a -> Pattern.matches(pattern, a)).peek(p -> logger.debug("MATCH " + pattern + " -> " + p)).collect(Collectors.toList());
        return matching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActivityExecutor getActivityExecutor(ActivityDef activityDef, boolean createIfMissing) {
        Map<String, ActivityExecutor> map = this.activityExecutors;
        synchronized (map) {
            ActivityExecutor executor = this.activityExecutors.get(activityDef.getAlias());
            if (executor == null && createIfMissing) {
                ActivityType activityType = new ActivityTypeLoader().load(activityDef).orElseThrow(() -> new RuntimeException("Could not load Driver for " + activityDef + "'"));
                executor = new ActivityExecutor(activityType.getAssembledActivity(activityDef, this.getActivityMap()), this.sessionId);
                this.activityExecutors.put(activityDef.getAlias(), executor);
            }
            return executor;
        }
    }

    public void waitMillis(long waitMillis) {
        scenariologger.debug("WAITMILLIS " + waitMillis);
        logger.trace("#> waitMillis(" + waitMillis + ")");
        long endTime = System.currentTimeMillis() + waitMillis;
        while (waitMillis > 0L) {
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException spurrious) {
                waitMillis = endTime - System.currentTimeMillis();
                continue;
            }
            waitMillis = 0L;
        }
    }

    public Set<String> getAliases() {
        return this.activityExecutors.keySet();
    }

    public List<ActivityDef> getActivityDefs() {
        return this.activityExecutors.values().stream().map(ActivityExecutor::getActivityDef).collect(Collectors.toList());
    }

    public ActivityDef getActivityDef(String alias) {
        return this.getActivityExecutor(alias).getActivityDef();
    }

    public synchronized void forceStopScenario(int waitTimeMillis, boolean rethrow) {
        logger.debug("Scenario force stopped.");
        this.activityExecutors.values().forEach(a -> a.forceStopScenarioAndThrow(waitTimeMillis, rethrow));
    }

    public boolean awaitCompletion(long waitTimeMillis) {
        boolean completed = true;
        long remaining = waitTimeMillis;
        ArrayList<ActivityFinisher> finishers = new ArrayList<ActivityFinisher>();
        for (ActivityExecutor ae : this.activityExecutors.values()) {
            ActivityFinisher finisher = new ActivityFinisher(ae, (int)remaining);
            finishers.add(finisher);
            finisher.start();
        }
        for (ActivityFinisher finisher : finishers) {
            try {
                finisher.join(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (ActivityFinisher finisher : finishers) {
            if (finisher.getResult()) continue;
            logger.debug("finisher for " + finisher.getName() + " did not signal TRUE");
            completed = false;
        }
        return completed;
    }

    private ActivityDef aliasToDef(String alias) {
        if (alias.contains("=")) {
            return ActivityDef.parseActivityDef((String)alias);
        }
        return ActivityDef.parseActivityDef((String)("alias=" + alias + ";"));
    }

    public boolean await(Map<String, String> activityDefMap) {
        return this.awaitActivity(activityDefMap);
    }

    public boolean awaitActivity(Map<String, String> activityDefMap) {
        ActivityDef ad = new ActivityDef(new ParameterMap(activityDefMap));
        return this.awaitActivity(ad);
    }

    public boolean await(String alias) {
        return this.awaitActivity(alias);
    }

    public boolean awaitActivity(String alias) {
        ActivityDef toAwait = this.aliasToDef(alias);
        return this.awaitActivity(toAwait);
    }

    public boolean await(ActivityDef activityDef) {
        return this.awaitActivity(activityDef);
    }

    public boolean awaitActivity(ActivityDef activityDef) {
        ActivityExecutor activityExecutor = this.getActivityExecutor(activityDef, false);
        if (activityExecutor == null) {
            throw new RuntimeException("Could not await missing activity: " + activityDef);
        }
        scenariologger.debug("AWAIT/before alias=" + activityDef.getAlias());
        boolean finished = activityExecutor.awaitFinish(Integer.MAX_VALUE);
        scenariologger.debug("AWAIT/after  completed=" + finished);
        return finished;
    }

    public Map<String, ActivityExecutor> getActivityExecutorMap() {
        return Collections.unmodifiableMap(this.activityExecutors);
    }

    public void reportMetrics() {
        ActivityMetrics.reportTo((PrintStream)System.out);
    }

    private Map<String, Activity> getActivityMap() {
        HashMap<String, Activity> activityMap = new HashMap<String, Activity>();
        for (Map.Entry<String, ActivityExecutor> entry : this.activityExecutors.entrySet()) {
            activityMap.put(entry.getKey(), entry.getValue().getActivity());
        }
        return activityMap;
    }

    public List<ProgressAndStateMeter> getProgressMeters() {
        ArrayList<ProgressAndStateMeter> indicators = new ArrayList<ProgressAndStateMeter>();
        for (ActivityExecutor ae : this.activityExecutors.values()) {
            indicators.add(new ProgressAndStateMeter(ae.getProgressMeter(), (StateCapable)ae.getActivity()));
        }
        indicators.sort((o1, o2) -> Long.compare(o1.getStartedAtMillis(), o2.getStartedAtMillis()));
        return indicators;
    }
}

