/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.logging;

import io.nosqlbench.nb.api.logging.NBLogLevel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class LoggerConfig
extends ConfigurationFactory {
    public static Map<String, String> STANDARD_FORMATS = Map.of("TERSE", "%8r %-5level [%t] %-12logger{0} %msg%n%throwable", "VERBOSE", "%d{DEFAULT}{GMT} [%t] %logger %-5level: %msg%n%throwable", "TERSE-ANSI", "%8r %highlight{%-5level} %style{%C{1.} [%t] %-12logger{0}} %msg%n%throwable", "VERBOSE-ANSI", "%d{DEFAULT}{GMT} [%t] %highlight{%logger %-5level}: %msg%n%throwable");
    public static Map<String, Level> BUILTIN_OVERRIDES = Map.of("oshi.util", Level.INFO);
    private static final String DEFAULT_CONSOLE_PATTERN = "%7r %-5level [%t] %-12logger{0} %msg%n%throwable";
    private String consolePattern = "%7r %-5level [%t] %-12logger{0} %msg%n%throwable";
    private NBLogLevel consoleLevel = NBLogLevel.DEBUG;
    private static final String DEFAULT_LOGFILE_PATTERN = "%d{DEFAULT}{GMT} [%t] %-5level: %msg%n";
    private final String logfilePattern = "%d{DEFAULT}{GMT} [%t] %-5level: %msg%n";
    private NBLogLevel fileLevel = NBLogLevel.DEBUG;
    private Map<String, String> logLevelOverrides = new LinkedHashMap<String, String>();
    private Path loggerDir = Path.of("logs", new String[0]);
    private String sessionName;
    private int maxLogfiles = 100;
    private String logfileLocation;
    private boolean ansiEnabled;
    private static final Comparator<File> fileTimeComparator = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return Long.compare(o1.lastModified(), o2.lastModified());
        }
    };

    public LoggerConfig setAnsiEnabled(boolean ansiEnabled) {
        this.ansiEnabled = ansiEnabled;
        return this;
    }

    public LoggerConfig setConsoleLevel(NBLogLevel level) {
        this.consoleLevel = level;
        return this;
    }

    public LoggerConfig setLogfileLevel(NBLogLevel level) {
        this.fileLevel = level;
        return this;
    }

    private NBLogLevel getEffectiveFileLevel() {
        if (this.fileLevel.isGreaterOrEqualTo(this.consoleLevel)) {
            return this.fileLevel;
        }
        return this.consoleLevel;
    }

    public LoggerConfig setMaxLogs(int maxLogfiles) {
        this.maxLogfiles = maxLogfiles;
        return this;
    }

    Configuration createConfiguration(String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        Level internalLoggingStatusThreshold = Level.ERROR;
        Level builderThresholdLevel = Level.INFO;
        Level fileLevel = Level.valueOf((String)this.getEffectiveFileLevel().toString());
        Level consoleLevel = Level.valueOf((String)this.consoleLevel.toString());
        Level rootLoggingLevel = fileLevel;
        RootLoggerComponentBuilder rootBuilder = builder.newRootLogger(rootLoggingLevel);
        builder.setConfigurationName(name);
        builder.setStatusLevel(internalLoggingStatusThreshold);
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", builderThresholdLevel));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("console", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", this.consolePattern));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG).add(builder.newAppenderRef("console"))).addAttribute("additivity", false));
        if (this.sessionName != null) {
            String logfilePath;
            if (!Files.exists(this.loggerDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.loggerDir, new FileAttribute[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to create logger directory:" + this.loggerDir);
                }
            }
            LayoutComponentBuilder logfileLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", DEFAULT_LOGFILE_PATTERN);
            String filebase = this.getSessionName().replaceAll("\\s", "_");
            this.logfileLocation = logfilePath = this.loggerDir.resolve(filebase + ".log").toString();
            String archivePath = this.loggerDir.resolve(filebase + "-TIMESTAMP.log.gz").toString().replaceAll("TIMESTAMP", "%d{MM-dd-yy}");
            ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("CronTriggeringPolicy").addAttribute("schedule", "0 0 0 * * ?")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "100M"));
            AppenderComponentBuilder logsAppenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("SCENARIO_APPENDER", "RollingFile").addAttribute("fileName", logfilePath)).addAttribute("filePattern", archivePath)).addAttribute("append", false)).add(logfileLayout).addComponent(triggeringPolicy);
            builder.add(logsAppenderBuilder);
            rootBuilder.add((AppenderRefComponentBuilder)builder.newAppenderRef("SCENARIO_APPENDER").addAttribute("level", fileLevel));
        }
        rootBuilder.add((AppenderRefComponentBuilder)builder.newAppenderRef("console").addAttribute("level", consoleLevel));
        builder.add(rootBuilder);
        BUILTIN_OVERRIDES.forEach((k, v) -> builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger(k, v).add(builder.newAppenderRef("console"))).add(builder.newAppenderRef("SCENARIO_APPENDER"))).addAttribute("additivity", true)));
        this.logLevelOverrides.forEach((k, v) -> {
            Level olevel = Level.valueOf((String)v);
            builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger(k, olevel).add(builder.newAppenderRef("console"))).add(builder.newAppenderRef("SCENARIO_APPENDER"))).addAttribute("additivity", true));
        });
        BuiltConfiguration builtConfig = (BuiltConfiguration)builder.build();
        return builtConfig;
    }

    private String getSessionName() {
        return this.sessionName;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        return this.getConfiguration(loggerContext, source.toString(), null);
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationBuilder builder = LoggerConfig.newConfigurationBuilder();
        return this.createConfiguration(name, (ConfigurationBuilder<BuiltConfiguration>)builder);
    }

    protected String[] getSupportedTypes() {
        return new String[]{"*"};
    }

    public void activate() {
        if (!Files.exists(this.loggerDir, new LinkOption[0])) {
            try {
                FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwx---"));
                Path path = Files.createDirectory(this.loggerDir, attrs);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while creating directory " + this.loggerDir.toString() + ": " + e.getMessage(), e);
            }
        }
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)this);
    }

    public LoggerConfig setConsolePattern(String consoleLoggingPattern) {
        consoleLoggingPattern = this.ansiEnabled && STANDARD_FORMATS.containsKey(consoleLoggingPattern + "-ANSI") ? consoleLoggingPattern + "-ANSI" : consoleLoggingPattern;
        this.consolePattern = STANDARD_FORMATS.getOrDefault(consoleLoggingPattern, consoleLoggingPattern);
        return this;
    }

    public LoggerConfig setLogfilePattern(String logfileLoggingPattern) {
        logfileLoggingPattern = logfileLoggingPattern.endsWith("-ANSI") && STANDARD_FORMATS.containsKey(logfileLoggingPattern) ? logfileLoggingPattern.substring(logfileLoggingPattern.length() - 5) : logfileLoggingPattern;
        this.logfileLocation = STANDARD_FORMATS.getOrDefault(logfileLoggingPattern, logfileLoggingPattern);
        return this;
    }

    public LoggerConfig getLoggerLevelOverrides(Map<String, String> logLevelOverrides) {
        this.logLevelOverrides = logLevelOverrides;
        return this;
    }

    public Map<String, String> getLogLevelOverrides() {
        return this.logLevelOverrides;
    }

    public LoggerConfig setSessionName(String sessionName) {
        this.sessionName = sessionName;
        return this;
    }

    public LoggerConfig purgeOldFiles(Logger logger) {
        if (this.maxLogfiles == 0) {
            logger.debug("Not purging old files, since maxLogFiles is 0.");
            return this;
        }
        File[] files = this.loggerDir.toFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".log") || pathname.getPath().endsWith(".log.gz");
            }
        });
        if (files == null) {
            return this;
        }
        List<File> filesList = Arrays.asList(files);
        int remove = filesList.size() - this.maxLogfiles;
        if (remove <= 0) {
            return this;
        }
        List toDelete = filesList.stream().sorted(fileTimeComparator).limit(remove).collect(Collectors.toList());
        for (File file : toDelete) {
            logger.info("removing extra logfile: " + file.getPath());
            if (file.delete()) continue;
            logger.warn("unable to delete: " + file);
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public String getLogfileLocation() {
        return this.logfileLocation;
    }

    public LoggerConfig setLogsDirectory(Path logsDirectory) {
        this.loggerDir = logsDirectory;
        return this;
    }
}

