/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.metrics;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Annotator;
import io.nosqlbench.nb.api.config.standard.ConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.NBMapConfigurable;
import io.nosqlbench.nb.api.config.standard.Param;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=Annotator.class, selector="log")
public class LoggingAnnotator
implements Annotator,
NBMapConfigurable {
    private static final Logger annotatorLog = LogManager.getLogger((String)"ANNOTATION");
    private Level level;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();

    public void recordAnnotation(Annotation annotation) {
        String inlineForm = annotation.asJson();
        annotatorLog.log(this.level, inlineForm);
    }

    public void applyConfig(Map<String, ?> providedConfig) {
        NBConfigModel configModel = this.getConfigModel();
        NBConfiguration cfg = configModel.apply(providedConfig);
        String levelName = cfg.get("level");
        this.level = Level.valueOf((String)levelName);
    }

    public NBConfigModel getConfigModel() {
        return ConfigModel.of(this.getClass(), (Param[])new Param[0]).add(Param.defaultTo((String)"level", (Object)"INFO").setDescription("The logging level to use for this annotator")).asReadOnly();
    }
}

