/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.metrics;

import com.codahale.metrics.Metric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class MetricMap
implements ProxyObject {
    private static final Logger logger = LogManager.getLogger(MetricMap.class);
    private final String name;
    private final String parent_name;
    private final HashMap<String, Object> map = new HashMap();

    public MetricMap(String name, String parent) {
        this.name = name;
        this.parent_name = parent;
    }

    public MetricMap findOwner(String metricName) {
        String[] names = metricName.split("\\.");
        String[] pathTraversal = Arrays.copyOfRange(names, 0, names.length - 1);
        MetricMap owner = this.findPath(pathTraversal);
        return owner;
    }

    public String toString() {
        return "MetricMap{name='" + this.name + "', map=" + this.map + (String)(this.parent_name != null ? ", parent=" + this.parent_name : "") + "}";
    }

    public MetricMap findPath(String ... names) {
        MetricMap current = this;
        for (int i = 0; i < names.length; ++i) {
            String edgeName = names[i];
            if (current.map.containsKey(edgeName)) {
                Object element = current.map.get(edgeName);
                if (element instanceof MetricMap) {
                    current = (MetricMap)element;
                    logger.trace("traversing edge:" + edgeName);
                    continue;
                }
                String error = "edge exists at level:" + i;
                logger.error(error);
                throw new RuntimeException(error);
            }
            MetricMap newMap = new MetricMap(edgeName, this.name);
            current.map.put(edgeName, newMap);
            current = newMap;
            logger.trace("adding edge:" + edgeName);
        }
        return current;
    }

    public void add(String name, Metric metric) {
        MetricMap owner = this.findOwner(name);
        String leafName = name.substring(name.lastIndexOf(".") + 1);
        owner.map.put(leafName, metric);
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Object getMember(String key) {
        Object got = this.get(key);
        return got;
    }

    public Object getMemberKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.getKeys());
        return keys;
    }

    public boolean hasMember(String key) {
        boolean got = this.getKeys().contains(key);
        return got;
    }

    public void putMember(String key, Value value) {
        throw new RuntimeException("Not allowed here");
    }
}

