/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.metrics;

import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

public class NBMetricsSummary {
    public static void summarize(StringBuilder sb, String name, Metric metric) {
        sb.append(String.format("%-40s", name));
        if (metric instanceof Counting) {
            sb.append(" count=").append(((Counting)metric).getCount());
        }
        if (metric instanceof Gauge) {
            sb.append(" value=").append(((Gauge)metric).getValue());
        }
        sb.append("\n");
    }

    public static void summarize(StringBuilder sb, MetricRegistry registry) {
        registry.getMetrics().forEach((k, v) -> NBMetricsSummary.summarize(sb, k, v));
    }

    private static String fmt(Number n) {
        NumberFormat fmt = NumberFormat.getNumberInstance(Locale.US);
        fmt.setMaximumFractionDigits(3);
        fmt.setGroupingUsed(false);
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        return fmt.format(n);
    }
}

