/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import io.nosqlbench.engine.core.metrics.MetricMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class PolyglotMetricRegistryBindings
implements ProxyObject,
MetricRegistryListener {
    private static final Logger logger = LogManager.getLogger((String)"METRICS");
    private final MetricRegistry registry;
    MetricMap metrics = new MetricMap("ROOT", null);

    public PolyglotMetricRegistryBindings(MetricRegistry registry) {
        this.registry = registry;
        registry.addListener((MetricRegistryListener)this);
    }

    public Object getMember(String key) {
        logger.trace("get member: " + key);
        Object o = this.metrics.get(key);
        return o;
    }

    public Object getMemberKeys() {
        logger.trace("get member keys");
        ArrayList<String> keys = new ArrayList<String>(this.metrics.getKeys());
        return keys;
    }

    public boolean hasMember(String key) {
        logger.trace("has member? " + key);
        boolean b = this.metrics.containsKey(key);
        return b;
    }

    public void putMember(String key, Value value) {
        throw new UnsupportedOperationException("This view is not meant to be modified by users. It is modified automatically by metrics registry updates.");
    }

    public boolean removeMember(String key) {
        throw new UnsupportedOperationException("This view is not meant to be modified by users. It is modified automatically by metrics registry updates.");
    }

    public void onGaugeAdded(String name, Gauge<?> gauge) {
        this.metrics.add(name, (Metric)gauge);
        logger.debug("gauge added: " + name);
    }

    public void onGaugeRemoved(String name) {
        this.metrics.findOwner(name).remove(name);
        logger.debug("gauge removed: " + name);
    }

    public void onCounterAdded(String name, Counter counter) {
        this.metrics.add(name, (Metric)counter);
        logger.debug("counter added: " + name + ", " + counter);
    }

    public void onCounterRemoved(String name) {
        this.metrics.findOwner(name).remove(name);
        logger.debug("counter removed: " + name);
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        this.metrics.add(name, (Metric)histogram);
        logger.debug("histogram added: " + name + ", " + histogram);
    }

    public void onHistogramRemoved(String name) {
        this.metrics.findOwner(name).remove(name);
        logger.debug("histogram removed: " + name);
    }

    public void onMeterAdded(String name, Meter meter) {
        this.metrics.add(name, (Metric)meter);
        logger.debug("meter added: " + name + ", " + meter);
    }

    public void onMeterRemoved(String name) {
        this.metrics.findOwner(name).remove(name);
        logger.debug("meter removed: " + name);
    }

    public void onTimerAdded(String name, Timer timer) {
        this.metrics.add(name, (Metric)timer);
        logger.debug("timer added: " + name);
    }

    public void onTimerRemoved(String name) {
        this.metrics.findOwner(name).remove(name);
        logger.debug("timer removed: " + name);
    }

    public Map<String, Metric> getMetrics() {
        return this.getMetrics(new LinkedHashMap<String, Metric>(), "metrics", this.metrics);
    }

    private Map<String, Metric> getMetrics(Map<String, Metric> totalMap, String prefix, MetricMap map) {
        for (String key : map.getKeys()) {
            Object o = map.get(key);
            String name = prefix + "." + key;
            if (o instanceof Metric) {
                totalMap.put(name, (Metric)o);
                continue;
            }
            if (o instanceof MetricMap) {
                this.getMetrics(totalMap, name, (MetricMap)o);
                continue;
            }
            throw new RuntimeException("entry value must be either a Metric or a MetricMap");
        }
        return totalMap;
    }
}

