/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.script;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ParameterMap;
import io.nosqlbench.engine.core.lifecycle.ScenarioController;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.Bindings;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class NashornActivityBindings
implements Bindings,
ProxyObject {
    private final ScenarioController scenario;
    private final Map<String, Bindings> elementMap = new HashMap<String, Bindings>();

    public NashornActivityBindings(ScenarioController scenarioController) {
        this.scenario = scenarioController;
    }

    @Override
    public Object put(String name, Object value) {
        throw new RuntimeException("ScenarioBindings do not allow put(...)");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        throw new RuntimeException("ScenarioBindings do not allow putAll(...)");
    }

    @Override
    public void clear() {
        throw new RuntimeException("ScenarioBindings do not allow clear(...)");
    }

    @Override
    public Set<String> keySet() {
        return this.scenario.getAliases();
    }

    @Override
    public Collection<Object> values() {
        return this.wrap(this.scenario.getActivityDefs());
    }

    private Collection<Object> wrap(List<ActivityDef> activityDefs) {
        return activityDefs.stream().map(s -> (Bindings)s).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> newset = new HashSet<Map.Entry<String, Object>>();
        for (ActivityDef activityDef : this.scenario.getActivityDefs()) {
            newset.add(new AbstractMap.SimpleImmutableEntry<String, ActivityDef>(activityDef.getAlias(), activityDef));
        }
        return newset;
    }

    @Override
    public int size() {
        return this.scenario.getActivityDefs().size();
    }

    @Override
    public boolean isEmpty() {
        return this.scenario.getActivityDefs().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.scenario.getAliases().contains(String.valueOf(key));
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("Should this be used?");
    }

    @Override
    public Bindings get(Object key) {
        ParameterMap activityDef = this.scenario.getActivityDef(String.valueOf(key)).getParams();
        return activityDef;
    }

    @Override
    public Object remove(Object key) {
        throw new RuntimeException("this is not the advised way to forceStopMotors an activity");
    }

    public Object getMember(String key) {
        Bindings bindings = this.get(key);
        return bindings;
    }

    public Object getMemberKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.keySet());
        return keys;
    }

    public boolean hasMember(String key) {
        boolean b = this.containsKey(key);
        return b;
    }

    public void putMember(String key, Value value) {
        if (!value.isHostObject()) {
            throw new RuntimeException("Unable to put a non-host object into the activities bindings layer:" + value);
        }
        this.put(key, value.asHostObject());
    }
}

