/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.core.script;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;

public class ScriptParams
extends HashMap<String, String>
implements ProxyObject {
    private static final Logger logger = LogManager.getLogger(ScriptParams.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public ScriptParams withOverrides(Object overrides) {
        Map map;
        if (overrides instanceof Map) {
            map = overrides;
        } else if (overrides instanceof Value) {
            Value v = (Value)overrides;
            map = (Map)v.as(Map.class);
        } else {
            throw new RuntimeException("Unrecognized overrides type: " + overrides.getClass().getCanonicalName());
        }
        if (overrides == null) {
            logger.warn("A null map was provided to withOverrides. This could be a bug in your script.");
            overrides = Map.of();
        }
        ScriptParams.checkForNulls("params", "calling withOverrides", this);
        ScriptParams.checkForNulls("overrides", "calling withOverrides", map);
        ScriptParams result = new ScriptParams();
        result.putAll(this);
        for (Map.Entry overrideEntry : map.entrySet()) {
            String oKey = (String)overrideEntry.getKey();
            String oVal = (String)overrideEntry.getValue();
            if (oVal.toUpperCase().endsWith("UNDEF") || oVal.toUpperCase(Locale.ROOT).endsWith("UNSET")) {
                String removed = (String)result.remove(oKey);
                logger.trace("Removed key '" + oKey + "': '" + removed + "' from script params because it was " + oVal + " in overrides");
                continue;
            }
            String was = (String)result.get(oKey);
            was = was == null ? "NULL" : was;
            result.put(oKey, oVal);
            logger.trace("Overrode key '" + oKey + "': from '" + was + " to " + oVal);
        }
        ScriptParams p = new ScriptParams();
        p.putAll(result);
        return p;
    }

    public ScriptParams withDefaults(Object defaults) {
        Map<String, String> map;
        if (defaults instanceof Map) {
            map = (Map<String, String>)defaults;
        } else if (defaults instanceof Value) {
            map = (Map)((Value)defaults).as(Map.class);
        } else {
            throw new RuntimeException("Unrecognized type for defaults: " + defaults.getClass().getCanonicalName());
        }
        if (map == null) {
            logger.warn("A null map was provided to withDefaults. This could be a bug in your script.");
            map = Map.of();
        }
        ScriptParams result = new ScriptParams();
        ScriptParams.checkForNulls("params", "calling withDefaults", this);
        ScriptParams.checkForNulls("defaults", "calling withDefaults", map);
        result.putAll(map);
        result.putAll(this);
        ScriptParams p = new ScriptParams();
        p.putAll(result);
        return p;
    }

    private static void checkForNulls(String name, String action, Map<String, String> map) {
        for (String s : map.keySet()) {
            if (s == null) {
                ScriptParams.printMapToLog(name, map);
                throw new BasicError("Found a null key in " + name + " while " + action + ". Please ensure that you only provide non-null keys and values in parameter maps.");
            }
            if (map.get(s) != null) continue;
            ScriptParams.printMapToLog(name, map);
            throw new BasicError("Found a null value for key '" + s + "' in " + name + " while " + action + ". Please ensure you provide non-null keys and values in parameter maps.");
        }
    }

    private static void printMapToLog(String name, Map<String, String> map) {
        logger.info("contents of map '" + name + "':");
        String mapdetail = map.entrySet().stream().map(e -> ScriptParams.valueOf(e.getKey()) + ":" + ScriptParams.valueOf(e.getValue())).collect(Collectors.joining(","));
        logger.info(mapdetail);
    }

    @Override
    public String toString() {
        return gson.toJson((Object)this, Map.class);
    }

    private static String valueOf(Object o) {
        if (o == null) {
            return "NULL";
        }
        return String.valueOf(o);
    }

    public Object getMember(String key) {
        if (key.equals("withDefaults")) {
            return this::withDefaults;
        }
        if (key.equals("withOverrides")) {
            return this::withOverrides;
        }
        return super.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return key.equals("withOverrides") || key.equals("withDefaults") || super.containsKey(key);
    }

    public Object getMemberKeys() {
        ArrayList memberKeys = new ArrayList(super.keySet());
        memberKeys.add("withDefaults");
        memberKeys.add("withOverride");
        return memberKeys;
    }

    public boolean hasMember(String key) {
        if (super.containsKey(key)) {
            return true;
        }
        return key.equals("withOverrides") || key.equals("withDefaults");
    }

    public void putMember(String key, Value value) {
        super.put(key, value.asString());
    }
}

