/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.okhttp.OkHttpDockerCmdExecFactory;
import com.sun.security.auth.module.UnixSystem;
import io.nosqlbench.engine.docker.RestHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerHelper {
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_HOST_ADDR = "unix:///var/run/docker.sock";
    private DockerClientConfig config;
    private DockerClient dockerClient;
    private Logger logger = LoggerFactory.getLogger(DockerHelper.class);

    public DockerHelper() {
        System.getProperties().setProperty(DOCKER_HOST, DOCKER_HOST_ADDR);
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(DOCKER_HOST_ADDR).build();
        AbstractDockerCmdExecFactory dockerCmdExecFactory = new OkHttpDockerCmdExecFactory().withReadTimeout(Integer.valueOf(60000)).withConnectTimeout(Integer.valueOf(60000));
        this.dockerClient = DockerClientBuilder.getInstance((DockerClientConfig)this.config).withDockerCmdExecFactory((DockerCmdExecFactory)dockerCmdExecFactory).build();
    }

    public String startDocker(String IMG, String tag, String name, List<Integer> ports, List<String> volumeDescList, List<String> envList, List<String> cmdList, String reload) {
        CreateContainerResponse containerResponse;
        this.logger.debug("Starting docker with img=" + IMG + ", tag=" + tag + ", name=" + name + ", ports=" + ports + ", volumes=" + volumeDescList + ", env=" + envList + ", cmds=" + cmdList + ", reload=" + reload);
        boolean existingContainer = this.removeExitedContainers(name);
        Container containerId = this.searchContainer(name, reload);
        if (containerId != null) {
            this.logger.debug("container is already up with the id: " + containerId.getId());
            return null;
        }
        Info info = (Info)this.dockerClient.infoCmd().exec();
        this.dockerClient.buildImageCmd();
        String term = IMG.split("/")[1];
        List dockerList = (List)this.dockerClient.listImagesCmd().withImageNameFilter(IMG).exec();
        if (dockerList.size() == 0) {
            ((PullImageResultCallback)this.dockerClient.pullImageCmd(IMG).withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            dockerList = (List)this.dockerClient.listImagesCmd().withImageNameFilter(IMG).exec();
            if (dockerList.size() == 0) {
                this.logger.error(String.format("Image %s not found, unable to automatically pull image. Check `docker images`", IMG));
                System.exit(1);
            }
        }
        this.logger.info("Search returned" + dockerList.toString());
        ArrayList<Object> tcpPorts = new ArrayList<Object>();
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>();
        for (Integer port : ports) {
            ExposedPort tcpPort = ExposedPort.tcp((int)port);
            Ports.Binding binding = new Ports.Binding("0.0.0.0", String.valueOf(port));
            PortBinding pb = new PortBinding(binding, tcpPort);
            tcpPorts.add(tcpPort);
            portBindings.add(pb);
        }
        ArrayList<Volume> volumeList = new ArrayList<Volume>();
        ArrayList<Bind> volumeBindList = new ArrayList<Bind>();
        for (String volumeDesc : volumeDescList) {
            String volFrom = volumeDesc.split(":")[0];
            String volTo = volumeDesc.split(":")[1];
            Volume vol = new Volume(volTo);
            volumeList.add(vol);
            volumeBindList.add(new Bind(volFrom, vol));
        }
        if (envList == null) {
            containerResponse = this.dockerClient.createContainerCmd(IMG + ":" + tag).withCmd(cmdList).withExposedPorts(tcpPorts).withHostConfig(new HostConfig().withPortBindings(portBindings).withPublishAllPorts(Boolean.valueOf(true)).withBinds(volumeBindList)).withName(name).exec();
        } else {
            long user = new UnixSystem().getUid();
            containerResponse = this.dockerClient.createContainerCmd(IMG + ":" + tag).withEnv(envList).withExposedPorts(tcpPorts).withHostConfig(new HostConfig().withPortBindings(portBindings).withPublishAllPorts(Boolean.valueOf(true)).withBinds(volumeBindList)).withName(name).withUser("" + user).exec();
        }
        this.dockerClient.startContainerCmd(containerResponse.getId()).exec();
        if (existingContainer) {
            this.logger.debug("Started existing container");
            return null;
        }
        return containerResponse.getId();
    }

    private boolean startStoppedContainer(String name) {
        ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withStatusFilter(List.of("stopped"));
        listContainersCmd.getFilters().put("name", Arrays.asList(name));
        List stoppedContainers = null;
        try {
            stoppedContainers = (List)listContainersCmd.exec();
            for (Container stoppedContainer : stoppedContainers) {
                String id = stoppedContainer.getId();
                this.logger.info("Removing exited container: " + id);
                this.dockerClient.removeContainerCmd(id).exec();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to contact docker, make sure docker is up and try again.");
            this.logger.error("If docker is installed make sure this user has access to the docker group.");
            this.logger.error("$ sudo gpasswd -a ${USER} docker && newgrp docker");
            System.exit(1);
        }
        return false;
    }

    private boolean removeExitedContainers(String name) {
        ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withStatusFilter(List.of("exited"));
        listContainersCmd.getFilters().put("name", Arrays.asList(name));
        List stoppedContainers = null;
        try {
            stoppedContainers = (List)listContainersCmd.exec();
            Iterator iterator = stoppedContainers.iterator();
            if (iterator.hasNext()) {
                Container stoppedContainer = (Container)iterator.next();
                String id = stoppedContainer.getId();
                this.logger.info("Removing exited container: " + id);
                this.dockerClient.removeContainerCmd(id).exec();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to contact docker, make sure docker is up and try again.");
            this.logger.error("If docker is installed make sure this user has access to the docker group.");
            this.logger.error("$ sudo gpasswd -a ${USER} docker && newgrp docker");
            System.exit(1);
        }
        return false;
    }

    public Container searchContainer(String name, String reload) {
        ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withStatusFilter(List.of("running"));
        listContainersCmd.getFilters().put("name", Arrays.asList(name));
        List runningContainers = null;
        try {
            runningContainers = (List)listContainersCmd.exec();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to contact docker, make sure docker is up and try again.");
            System.exit(1);
        }
        if (runningContainers.size() >= 1) {
            this.logger.info(String.format("The container %s is already running", name));
            this.logger.info(String.format("Hupping config", new Object[0]));
            if (reload != null) {
                try {
                    RestHelper.post(reload, null, false, "reloading config");
                }
                catch (Exception e) {
                    this.logger.error(String.format("Unexpected config/state for docker container %s, consider removing the container", name));
                }
            }
            return (Container)runningContainers.get(0);
        }
        return null;
    }

    public void pollLog(String containerId, ResultCallbackTemplate<LogContainerResultCallback, Frame> logCallback) {
        LogContainerResultCallback loggingCallback = new LogContainerResultCallback();
        LogContainerCmd cmd = this.dockerClient.logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll();
        boolean[] httpStarted = new boolean[]{false};
        cmd.exec(logCallback);
        try {
            loggingCallback.awaitCompletion(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("Error getting docker log and detect start for containerId: " + containerId);
            e.printStackTrace();
        }
    }
}

