/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.docker;

import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import io.nosqlbench.engine.docker.DockerHelper;
import io.nosqlbench.engine.docker.RestHelper;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMetricsManager {
    public static final String GRAFANA_TAG = "grafana_tag";
    private final DockerHelper dh;
    String userHome = System.getProperty("user.home");
    private final Logger logger = LoggerFactory.getLogger(DockerMetricsManager.class);

    public DockerMetricsManager() {
        this.dh = new DockerHelper();
    }

    public void startMetrics(Map<String, String> options) {
        String ip = this.startGraphite();
        this.startPrometheus(ip);
        this.startGrafana(ip, options.get(GRAFANA_TAG));
    }

    private void startGrafana(String ip, String tag) {
        String GRAFANA_IMG = "grafana/grafana";
        tag = tag == null || tag.isEmpty() ? "latest" : tag;
        String name = "grafana";
        List<Integer> port = Arrays.asList(3000);
        boolean grafanaFilesExist = this.grafanaFilesExist();
        if (!grafanaFilesExist) {
            this.setupGrafanaFiles(ip);
        }
        List<String> volumeDescList = Arrays.asList(this.userHome + "/.nosqlbench/grafana:/var/lib/grafana:rw");
        List<String> envList = Arrays.asList("GF_SECURITY_ADMIN_PASSWORD=admin", "GF_AUTH_ANONYMOUS_ENABLED=\"true\"", "GF_SNAPSHOTS_EXTERNAL_SNAPSHOT_URL=https://assethub.datastax.com:3001", "GF_SNAPSHOTS_EXTERNAL_SNAPSHOT_NAME=\"Upload to DataStax\"");
        String reload = null;
        ArrayList<String> linkNames = new ArrayList<String>();
        linkNames.add("prom");
        String containerId = this.dh.startDocker(GRAFANA_IMG, tag, name, port, volumeDescList, envList, null, reload, linkNames);
        if (containerId == null) {
            return;
        }
        this.dh.pollLog(containerId, new LogCallback());
        this.logger.info("grafana container started, http listening");
        if (!grafanaFilesExist) {
            this.configureGrafana();
        }
    }

    private void startPrometheus(String ip) {
        this.logger.info("preparing to start docker metrics");
        String PROMETHEUS_IMG = "prom/prometheus";
        String tag = "latest";
        String name = "prom";
        List<Integer> port = Arrays.asList(9090);
        if (!this.promFilesExist()) {
            this.setupPromFiles(ip);
        }
        List<String> volumeDescList = Arrays.asList(this.userHome + "/.nosqlbench/prometheus-conf:/etc/prometheus", this.userHome + "/.nosqlbench/prometheus:/prometheus");
        List<String> envList = null;
        List<String> cmdList = Arrays.asList("--config.file=/etc/prometheus/prometheus.yml", "--storage.tsdb.path=/prometheus", "--storage.tsdb.retention=183d", "--web.enable-lifecycle");
        String reload = "http://localhost:9090/-/reload";
        ArrayList<String> linkNames = new ArrayList<String>();
        this.dh.startDocker(PROMETHEUS_IMG, tag, name, port, volumeDescList, envList, cmdList, reload, linkNames);
        this.logger.info("prometheus started and listenning");
    }

    private String startGraphite() {
        this.logger.info("preparing to start graphite exporter container...");
        String GRAPHITE_EXPORTER_IMG = "prom/graphite-exporter";
        String tag = "latest";
        String name = "graphite-exporter";
        List<Integer> port = Arrays.asList(9108, 9109);
        ArrayList<String> volumeDescList = new ArrayList<String>();
        this.setupGraphiteFiles(volumeDescList);
        List<String> envList = Arrays.asList(new String[0]);
        String reload = null;
        ArrayList<String> linkNames = new ArrayList<String>();
        List<String> cmdOpts = Arrays.asList("--graphite.mapping-config=/tmp/graphite_mapping.conf");
        this.dh.startDocker(GRAPHITE_EXPORTER_IMG, tag, name, port, volumeDescList, envList, cmdOpts, reload, linkNames);
        this.logger.info("graphite exporter container started");
        this.logger.info("searching for graphite exporter container ip");
        ContainerNetworkSettings settings = this.dh.searchContainer(name, null).getNetworkSettings();
        Map networks = settings.getNetworks();
        String ip = null;
        for (String key : networks.keySet()) {
            ContainerNetwork network = (ContainerNetwork)networks.get(key);
            ip = network.getIpAddress();
        }
        return ip;
    }

    private void setupGraphiteFiles(List<String> volumeDescList) {
        String exporterConfig = NBIO.readCharBuffer((String)"docker/graphite/graphite_mapping.conf", (String[])new String[0]).toString();
        File nosqlbenchdir = new File(this.userHome, "/.nosqlbench/");
        this.mkdir(nosqlbenchdir);
        File graphiteExporterDir = new File(this.userHome, "/.nosqlbench/graphite-exporter");
        this.mkdir(graphiteExporterDir);
        Path mappingPath = Path.of(this.userHome, ".nosqlbench", "graphite-exporter", "graphite_mapping.conf");
        if (!Files.exists(mappingPath, new LinkOption[0])) {
            try {
                Files.writeString(mappingPath, (CharSequence)exporterConfig, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing initial graphite mapping config in " + mappingPath, e);
            }
        }
        volumeDescList.add(mappingPath.toString() + ":/tmp/graphite_mapping.conf");
    }

    private void setupPromFiles(String ip) {
        String datasource = NBIO.readCharBuffer((String)"docker/prometheus/prometheus.yml", (String[])new String[0]).toString();
        if (ip == null) {
            this.logger.error("IP for graphite container not found");
            System.exit(1);
        }
        datasource = datasource.replace("!!!GRAPHITE_IP!!!", ip);
        File nosqlbenchDir = new File(this.userHome, "/.nosqlbench/");
        this.mkdir(nosqlbenchDir);
        File prometheusDir = new File(this.userHome, "/.nosqlbench/prometheus");
        this.mkdir(prometheusDir);
        File promConfDir = new File(this.userHome, "/.nosqlbench/prometheus-conf");
        this.mkdir(promConfDir);
        Path prometheusDirPath = Paths.get(this.userHome, "/.nosqlbench/prometheus");
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_WRITE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        try {
            Files.setPosixFilePermissions(prometheusDirPath, perms);
        }
        catch (IOException e) {
            this.logger.error("failed to set permissions on prom backup directory " + this.userHome + "/.nosqlbench/prometheus)");
            e.printStackTrace();
            System.exit(1);
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(this.userHome + "/.nosqlbench/prometheus-conf/prometheus.yml", false));){
            out.println(datasource);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.logger.error("error writing prometheus yaml file to ~/.prometheus");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("creating file in ~/.prometheus");
            System.exit(1);
        }
    }

    private void mkdir(File dir) {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdir()) {
            if (dir.canWrite()) {
                System.out.println("no write access");
            }
            if (dir.canRead()) {
                System.out.println("no read access");
            }
            System.out.println("Could not create directory " + dir.getPath());
            System.out.println("fix directory permissions to run --docker-metrics");
            System.exit(1);
        }
    }

    private boolean grafanaFilesExist() {
        File nosqlbenchDir = new File(this.userHome, "/.nosqlbench/");
        boolean exists = nosqlbenchDir.exists();
        if (exists) {
            File grafana = new File(this.userHome, "/.nosqlbench/grafana");
            exists = grafana.exists();
        }
        return exists;
    }

    private boolean promFilesExist() {
        File nosqlbenchDir = new File(this.userHome, "/.nosqlbench/");
        boolean exists = nosqlbenchDir.exists();
        if (exists) {
            File prom = new File(this.userHome, "/.nosqlbench/grafana");
            exists = prom.exists();
        }
        return exists;
    }

    private void setupGrafanaFiles(String ip) {
        File grafanaDir = new File(this.userHome, "/.nosqlbench/grafana");
        this.mkdir(grafanaDir);
        Path grafanaDirPath = Paths.get(this.userHome, "/.nosqlbench/grafana");
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(grafanaDirPath, perms);
        }
        catch (IOException e) {
            this.logger.error("failed to set permissions on grafana directory directory " + this.userHome + "/.nosqlbench/grafana)");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void configureGrafana() {
        List dashboardContent = NBIO.all().prefix(new String[]{"docker/dashboards"}).extension(new String[]{".json"}).list();
        for (Content content : dashboardContent) {
            String dashboardData = content.asString();
            RestHelper.post("http://localhost:3000/api/dashboards/db", () -> dashboardData, true, "load dashboard from " + content.asPath().toString());
        }
        List datasources = NBIO.all().prefix(new String[]{"docker/datasources"}).extension(new String[]{".yaml"}).list();
        for (Content datasource : datasources) {
            String datasourceContent = datasource.asString();
            RestHelper.post("http://localhost:3000/api/datasources", () -> datasourceContent, true, "configure data source from " + datasource.asPath().toString());
        }
        this.logger.warn("default grafana creds are admin/admin");
    }

    public void stopMetrics() {
    }

    private class LogCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        private LogCallback() {
        }

        public void onNext(Frame item) {
            if (item.toString().contains("HTTP Server Listen")) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

