/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory;
import com.sun.security.auth.module.UnixSystem;
import io.nosqlbench.engine.api.util.NosqlBenchFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerMetricsHelper {
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_HOST_ADDR = "unix:///var/run/docker.sock";
    String userHome = System.getProperty("user.home");
    private Client rsClient = ClientBuilder.newClient();
    private DockerClientConfig config;
    private DockerClient dockerClient;
    private Logger logger = LoggerFactory.getLogger(DockerMetricsHelper.class);

    public DockerMetricsHelper() {
        System.getProperties().setProperty(DOCKER_HOST, DOCKER_HOST_ADDR);
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(DOCKER_HOST_ADDR).build();
        JerseyDockerCmdExecFactory dockerCmdExecFactory = new JerseyDockerCmdExecFactory().withReadTimeout(Integer.valueOf(1000)).withConnectTimeout(Integer.valueOf(1000));
        this.dockerClient = DockerClientBuilder.getInstance((DockerClientConfig)this.config).withDockerCmdExecFactory((DockerCmdExecFactory)dockerCmdExecFactory).build();
    }

    public void startMetrics() {
        this.logger.info("preparing to startg graphite exporter container");
        String GRAPHITE_EXPORTER_IMG = "prom/graphite-exporter";
        String tag = "latest";
        String name = "graphite-exporter";
        List<Integer> port = Arrays.asList(9108, 9109);
        List<String> volumeDescList = Arrays.asList(new String[0]);
        List<String> envList = Arrays.asList(new String[0]);
        String reload = null;
        this.startDocker(GRAPHITE_EXPORTER_IMG, tag, name, port, volumeDescList, envList, null, reload);
        this.logger.info("graphite exporter container started");
        this.logger.info("searching for graphite exporter container ip");
        ContainerNetworkSettings settings = this.searchContainer(name, null).getNetworkSettings();
        Map networks = settings.getNetworks();
        String ip = null;
        for (String key : networks.keySet()) {
            ContainerNetwork network = (ContainerNetwork)networks.get(key);
            ip = network.getIpAddress();
        }
        this.logger.info("preparing to start docker metrics");
        String PROMETHEUS_IMG = "prom/prometheus";
        tag = "v2.4.3";
        name = "prom";
        port = Arrays.asList(9090);
        this.setupPromFiles(ip);
        volumeDescList = Arrays.asList(this.userHome + "/.nosqlbench/prometheus-conf:/etc/prometheus", this.userHome + "/.nosqlbench/prometheus:/prometheus");
        envList = null;
        List<String> cmdList = Arrays.asList("--config.file=/etc/prometheus/prometheus.yml", "--storage.tsdb.path=/prometheus", "--storage.tsdb.retention=183d", "--web.enable-lifecycle");
        reload = "http://localhost:9090/-/reload";
        this.startDocker(PROMETHEUS_IMG, tag, name, port, volumeDescList, envList, cmdList, reload);
        String GRAFANA_IMG = "grafana/grafana";
        tag = "5.3.2";
        name = "grafana";
        port = Arrays.asList(3000);
        this.setupGrafanaFiles(ip);
        volumeDescList = Arrays.asList(this.userHome + "/.nosqlbench/grafana:/var/lib/grafana:rw");
        envList = Arrays.asList("GF_SECURITY_ADMIN_PASSWORD=admin", "GF_AUTH_ANONYMOUS_ENABLED=\"true\"", "GF_SNAPSHOTS_EXTERNAL_SNAPSHOT_URL=https://assethub.datastax.com:3001", "GF_SNAPSHOTS_EXTERNAL_SNAPSHOT_NAME=\"Upload to DataStax\"");
        reload = null;
        String containerId = this.startDocker(GRAFANA_IMG, tag, name, port, volumeDescList, envList, null, reload);
        LogContainerResultCallback loggingCallback = new LogContainerResultCallback();
        try {
            LogContainerCmd cmd = this.dockerClient.logContainerCmd(containerId).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withTailAll();
            boolean[] httpStarted = new boolean[]{false};
            cmd.exec((ResultCallback)new LogCallback());
            loggingCallback.awaitCompletion(10L, TimeUnit.SECONDS);
            this.logger.info("grafana container started, http listenning");
            this.configureGrafana();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logger.error("unable to detect grafana start");
        }
    }

    private void setupPromFiles(String ip) {
        String datasource = NosqlBenchFiles.readFile((String)"docker/prometheus/prometheus.yml");
        if (ip == null) {
            this.logger.error("IP for graphite container not found");
            System.exit(1);
        }
        datasource = datasource.replace("!!!GRAPHITE_IP!!!", ip);
        File prometheusDir = new File(this.userHome, ".nosqlbench/prometheus");
        prometheusDir.mkdir();
        new File(this.userHome, ".nosqlbench/prometheus-conf").mkdir();
        Path prometheusDirPath = Paths.get(this.userHome, ".nosqlbench/prometheus");
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_WRITE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        try {
            Files.setPosixFilePermissions(prometheusDirPath, perms);
        }
        catch (IOException e) {
            this.logger.error("failed to set permissions on prom backup directory (~/.nosqlbench/prometheus)");
            e.printStackTrace();
            System.exit(1);
        }
        try (PrintWriter out = new PrintWriter(new FileWriter(this.userHome + "/.nosqlbench/prometheus-conf/prometheus.yml", false));){
            out.println(datasource);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.logger.error("error writing prometheus yaml file to ~/.prometheus");
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("creating file in ~/.prometheus");
            System.exit(1);
        }
    }

    private void setupGrafanaFiles(String ip) {
        File grafanaDir = new File(this.userHome, ".nosqlbench/grafana");
        grafanaDir.mkdir();
        Path grafanaDirPath = Paths.get(this.userHome, ".nosqlbench/grafana");
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(grafanaDirPath, perms);
        }
        catch (IOException e) {
            this.logger.error("failed to set permissions on prom backup directory (~/.nosqlbench/prometheus)");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void configureGrafana() {
        Response response = this.post("http://localhost:3000/api/dashboards/db", "docker/dashboards/analysis.json", true);
        response = this.post("http://localhost:3000/api/datasources", "docker/datasources/prometheus-datasource.yaml", true);
    }

    private Response post(String url, String path, boolean auth) {
        Response response;
        if (auth) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)"admin", (String)"admin");
            this.rsClient.register((Object)feature);
        }
        WebTarget webTarget = this.rsClient.target(url);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        if (path != null) {
            String dashboard = NosqlBenchFiles.readFile((String)path);
            response = invocationBuilder.post(Entity.entity((Object)dashboard, (String)"application/json"));
        } else {
            response = invocationBuilder.post(Entity.entity(null, (String)"application/json"));
        }
        return response;
    }

    private String startDocker(String IMG, String tag, String name, List<Integer> ports, List<String> volumeDescList, List<String> envList, List<String> cmdList, String reload) {
        CreateContainerResponse containerResponse;
        ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withStatusFilter(List.of("exited"));
        listContainersCmd.getFilters().put("name", Arrays.asList(name));
        List stoppedContainers = null;
        try {
            stoppedContainers = (List)listContainersCmd.exec();
            for (Container stoppedContainer : stoppedContainers) {
                String id = stoppedContainer.getId();
                this.logger.info("Removing exited container: " + id);
                this.dockerClient.removeContainerCmd(id).exec();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to contact docker, make sure docker is up and try again.");
            this.logger.error("If docker is installed make sure this user has access to the docker group.");
            this.logger.error("$ sudo gpasswd -a ${USER} docker && newgrp docker");
            System.exit(1);
        }
        Container containerId = this.searchContainer(name, reload);
        if (containerId != null) {
            return containerId.getId();
        }
        Info info = (Info)this.dockerClient.infoCmd().exec();
        this.dockerClient.buildImageCmd();
        String term = IMG.split("/")[1];
        List dockerList = (List)this.dockerClient.listImagesCmd().withImageNameFilter(IMG).exec();
        if (dockerList.size() == 0) {
            ((PullImageResultCallback)this.dockerClient.pullImageCmd(IMG).withTag(tag).exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
            dockerList = (List)this.dockerClient.listImagesCmd().withImageNameFilter(IMG).exec();
            if (dockerList.size() == 0) {
                this.logger.error(String.format("Image %s not found, unable to automatically pull image. Check `docker images`", IMG));
                System.exit(1);
            }
        }
        this.logger.info("Search returned" + dockerList.toString());
        ArrayList<Object> tcpPorts = new ArrayList<Object>();
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>();
        for (Integer port : ports) {
            ExposedPort tcpPort = ExposedPort.tcp((int)port);
            Ports.Binding binding = new Ports.Binding("0.0.0.0", String.valueOf(port));
            PortBinding pb = new PortBinding(binding, tcpPort);
            tcpPorts.add(tcpPort);
            portBindings.add(pb);
        }
        ArrayList<Volume> volumeList = new ArrayList<Volume>();
        ArrayList<Bind> volumeBindList = new ArrayList<Bind>();
        for (String volumeDesc : volumeDescList) {
            String volFrom = volumeDesc.split(":")[0];
            String volTo = volumeDesc.split(":")[1];
            Volume vol = new Volume(volTo);
            volumeList.add(vol);
            volumeBindList.add(new Bind(volFrom, vol));
        }
        if (envList == null) {
            containerResponse = this.dockerClient.createContainerCmd(IMG + ":" + tag).withCmd(cmdList).withExposedPorts(tcpPorts).withHostConfig(new HostConfig().withPortBindings(portBindings).withPublishAllPorts(Boolean.valueOf(true)).withBinds(volumeBindList)).withName(name).exec();
        } else {
            long user = new UnixSystem().getUid();
            containerResponse = this.dockerClient.createContainerCmd(IMG + ":" + tag).withEnv(envList).withExposedPorts(tcpPorts).withHostConfig(new HostConfig().withPortBindings(portBindings).withPublishAllPorts(Boolean.valueOf(true)).withBinds(volumeBindList)).withName(name).withUser("" + user).exec();
        }
        this.dockerClient.startContainerCmd(containerResponse.getId()).exec();
        return containerResponse.getId();
    }

    private Container searchContainer(String name, String reload) {
        ListContainersCmd listContainersCmd = this.dockerClient.listContainersCmd().withStatusFilter(List.of("running"));
        listContainersCmd.getFilters().put("name", Arrays.asList(name));
        List runningContainers = null;
        try {
            runningContainers = (List)listContainersCmd.exec();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Unable to contact docker, make sure docker is up and try again.");
            System.exit(1);
        }
        if (runningContainers.size() >= 1) {
            this.logger.info(String.format("The container %s is already running", name));
            this.logger.info(String.format("Hupping config", new Object[0]));
            if (reload != null) {
                this.post(reload, null, false);
            }
            return (Container)runningContainers.get(0);
        }
        return null;
    }

    public void stopMetrics() {
    }

    private class LogCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        private LogCallback() {
        }

        public void onNext(Frame item) {
            if (item.toString().contains("HTTP Server Listen")) {
                try {
                    this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

